//LabPlot : PlotSettingsDialog.h

#ifndef PLOTSETTINGSDIALOG_H
#define PLOTSETTINGSDIALOG_H

#include <qtoolbutton.h>
#include <qcolor.h>
#include <qcheckbox.h>
#include "Worksheet.h"
#include "Dialog.h"

class PlotSettingsDialog: public Dialog
{
	Q_OBJECT
public:
	PlotSettingsDialog(Worksheet *p, const char *name);
public slots:
	void ok_clicked() {apply_clicked(); accept(); }
	void apply_clicked();
	void autoscalex();
	void autoscaley();
	void autoscalez();
private:
	Plot *plot;
	int type;
	KLineEdit *posx, *posy, *sizex, *sizey;
	KLineEdit *borderwidth, *baselinele;
	KColorButton *bgcolor, *gbgcolor;
	KLineEdit *xmin, *xmax, *ymin, *ymax, *zmin, *zmax, *cliple;
	QCheckBox *baselinecb, *regioncb, *transparentcb;
	KLineEdit *regionminle, *regionmaxle;
};

#endif //PLOTSETTINGSDIALOG_H
