//LabPlot : ListDialog.cc

#include <stdio.h>
#include <stdlib.h>
#include <iostream>
#include <qstring.h>
#include <qfiledialog.h>
#include <klocale.h>
#include "ListDialog.h"
#include "DumpDialog.h"
#include "EditDialog.h"
#include "InfoDialog.h"
#include "VTKDialog.h"
#include "GRASSDialog.h"
#include "DataDialog.h"
#include "FunctionDialog.h"

ListDialog::ListDialog(Worksheet *p,const char *name)
	: Dialog(p, name), p(p)
{
	type=p->getPlot(p->getAPI())->getType();
		
	lv = new GraphListView(vbox);
	
	// popup menu
	menu = new QPopupMenu( lv );
	menu->insertItem( i18n( "Show/Hide" ),this,SLOT(toggleShown()) );
	menu->insertItem( i18n( "Delete" ),this,SLOT(deleteGraph()) );
	menu->insertItem( i18n( "Change" ),this,SLOT(changeGraph()) );
	menu->insertItem( i18n( "Edit" ),this,SLOT(editGraph()) );
	menu->insertItem( i18n( "Export" ),this,SLOT(dumpGraph()) );
	menu->insertItem( i18n( "Statistics" ),this,SLOT(statGraph()) );
	
	connect(lv, SIGNAL( rightButtonPressed( QListViewItem *, const QPoint& , int ) ),
		this, SLOT( Menu(QListViewItem *, const QPoint& , int) ) );

	setMinimumSize(vbox->minimumSizeHint()+gbox->minimumSizeHint());

	updateList();
}

void ListDialog::updateList() {
	lv->clear();
	lv->setSorting(-1);
		
	GraphList *graphlist = p->getPlot(p->getAPI())->getGraphList();
	for (int i= graphlist->getNumber()-1;i>=0;i--) {
		QStringList s;
		if (type == P2D) {
			GRAPHType st = graphlist->getStruct(i);
			if (st == GRAPH2D) {		// x-y
				Graph2D *g = graphlist->getGraph2D(i);
				s = g->Info();
			}
			else if (st == GRAPH3D) {	// x-y-dy
				lv->showZ();
				Graph3D *g = graphlist->getGraph3D(i);
				s = g->Info();
			}
			else if (st == GRAPH4D) {	// x-y-dx-dy, x-y-dy1-dy2
				lv->showZ();lv->showT();
				Graph4D *g = graphlist->getGraph4D(i);
				s = g->Info();
			}
		}
		else if (type == P3D ){
			GRAPHType st = graphlist->getStruct(i);
			if (st == GRAPH3D) {
				lv->showZ();
				Graph3D *g = graphlist->getGraph3D(i);
				s = g->Info();
			}
			else if (st == GRAPHM){
				GraphM *g = graphlist->getGraphM(i);
				s = g->Info();
			}
		}
		else if (type == PSURFACE) {
			GraphM *g = graphlist->getGraphM(i);
			s = g->Info();
		}
		else if (type == PPIE || type == PPOLAR) {
			Graph2D *g = graphlist->getGraph2D(i);
			s = g->Info();
		}
		else if (type == PGRASS) {
			GraphGRASS *g = graphlist->getGraphGRASS(i);
			s = g->Info();
		}
		else if (type == PVTK) {
			GraphVTK *g = graphlist->getGraphVTK(i);
			s = g->Info();
		}
		else if (type == PTERNARY) {
			lv->showZ();
			Graph3D *g = graphlist->getGraph3D(i);
			s = g->Info();
		}
		QListViewItem *lvi = new QListViewItem(lv);
		for (unsigned int j = 0;j < s.count();j++) {
			lvi->setText(j,s[j]);
		}
	}
	
	// select at least last item
	lv->setSelected(lv->currentItem(),TRUE);
	
	p->getMainWin()->setModified();
}

// toggle shown of selected graph
void ListDialog::toggleShown() {
	QListViewItemIterator it(lv);
	for ( ; it.current(); ++it ) {
		if(it.current()->isSelected()) {
			int item = (int) (lv->itemPos(it.current())/it.current()->height());

			Graph *g = p->getPlot(p->getAPI())->getGraphList()->getGraph(item);
			if(g->isShown())
				g->setShown(FALSE);
			else
				g->setShown(TRUE);
		}
	}
	
	updateList();
	p->repaint();
	p->resetRanges();
}

// delete selected graph
void ListDialog::deleteGraph() {
	QListViewItemIterator it(lv);
	for ( ; it.current(); ++it ) {
		if(it.current()->isSelected()) {
			int item = (int) (lv->itemPos(it.current())/it.current()->height());
			p->getPlot(p->getAPI())->getGraphList()->delGraph(item);
		}
	}
	
	p->resetRanges();

	updateList();
	p->repaint();
}

void ListDialog::changeGraph() {
	Plot *plot = p->getPlot(p->getAPI());
	PType type = plot->getType();
	
	QListViewItemIterator it(lv);
	for ( ; it.current(); ++it ) {
		if(it.current()->isSelected()) {
			int item = (int) (lv->itemPos(it.current())/it.current()->height());
			QString name = it.current()->text(0);

			if(type == PVTK) 
				(new VTKDialog(p,name,item))->show();
			else if (type == PGRASS)
				(new GRASSDialog(p,name,item))->show();
			else {	// everything else
				if(name.at(0) == QChar('/')) 			// criteria for data/ function
					(new DataDialog(p,name,this,item,plot->getType()))->show();
				else
					(new FunctionDialog(p,name,this,item,plot->getType()))->show();
			}
		}
	}
}

//! dump the selected graph data to a file
void ListDialog::dumpGraph() {
	QListViewItemIterator it(lv);
	for ( ; it.current(); ++it ) {
		if(it.current()->isSelected()) {
			int item = (int) (lv->itemPos(it.current())/it.current()->height());
			QString name = it.current()->text(0);
			(new DumpDialog(p,name,item))->show();
		}
	}
}

//! edit the selected graph data
void ListDialog::editGraph() {
	QListViewItemIterator it(lv);
	for ( ; it.current(); ++it ) {
		if(it.current()->isSelected()) {
			int item = (int) (lv->itemPos(it.current())/it.current()->height());
			QString name = it.current()->text(0);
			(new EditDialog(p,name,item,this))->show();
		}
	}
}

//! show selected graph info and statistics
void ListDialog::statGraph() {
	QListViewItemIterator it(lv);
	for ( ; it.current(); ++it ) {
		if(it.current()->isSelected()) {
			int item = (int) (lv->itemPos(it.current())/it.current()->height());
			QString name = it.current()->text(0);
			(new InfoDialog(p,name,item))->show();
		}
	}
}

// update range (ale-ble) when selecting another graph
void ListDialog::updateRange() {
	int item = (int) (lv->itemPos(lv->currentItem())/18);

	GraphList *gl = p->getPlot(p->getAPI())->getGraphList();
	GRAPHType s = gl->getStruct(item);
	LRange range=0;

	if (s == GRAPH2D) {
		Graph2D *g = gl->getGraph2D(item);
		range = g->getRange(0);
		ale->setText(QString::number(range.Min()));
		ble->setText(QString::number(range.Max()));
	}
}
