//LabPlot : GraphList.cc

#include <stdio.h>
#include <iostream>
#include <kdebug.h>
#include "GraphList.h"

using namespace std;

GraphList::GraphList() {
	clear();
}

void GraphList::clear() {
	nr2D = nr3D = nrM = nrGRASS = nrVTK = nr4D = 0;
	for (int i=0;i<6*MAX_NR;i++)
		id[i]=-1;
}

int GraphList::addGraph2D(Graph2D *g) {
	kdDebug()<<"GraphList::addGraph2D  Name = "<<g->Name()<<endl;
	kdDebug()<<"GraphList::addGraph2D : isNotFull() = "<<isNotFull()<<endl;
	kdDebug()<<"GraphList::addGraph2D : nr(2D,3D,M,GRASS,VTK) = "<<endl;
	kdDebug()<<nr2D<<" "<<nr3D<<" "<<nrM<<" "<<nrGRASS<<" "<<nrVTK<<endl;

	if(isNotFull() && nr2D<MAX_NR) {
		id[nr2D]=nr2D+nr3D+nrM+nrGRASS+nrVTK+nr4D;
		list2D[nr2D++] = *g;

		kdDebug()<<"GraphList::addGraph2D : nr2D = "<<nr2D<<endl;

		return 1;
	}
	return 0;
}

int GraphList::addGraph3D(Graph3D *g) {
	kdDebug()<<"GraphList::addGraph3D : isNotFull() = "<<isNotFull()<<endl;
	kdDebug()<<"GraphList::addGraph3D : nr(2D,3D,M) = "<<nr2D<<" "<<nr3D<<" "<<nrM<<endl;

	if(isNotFull() && nr3D<MAX_NR) {
		id[MAX_NR+nr3D]=nr2D+nr3D+nrM+nrGRASS+nrVTK+nr4D;
		list3D[nr3D++] = *g;

		kdDebug()<<"GraphList::addGraph3D : nr3D = "<<nr3D<<endl;
		kdDebug()<<"GraphList::addGraph3D : id["<<MAX_NR+nr3D-1<<"] = "<<endl;
		kdDebug()<<id[MAX_NR+nr3D-1]<<endl;
		kdDebug()<<"Type = "<<g->Type()<<endl;
		kdDebug()<<"Type = "<<list3D[nr3D-1].Type()<<endl;

		return 1;
	}
	return 0;
}

int GraphList::addGraphM(GraphM *g) {
	kdDebug()<<"GraphList::addGraphM : isNotFull() = "<<isNotFull()<<endl;
	kdDebug()<<"GraphList::addGraphM : nr(2D,3D,M) = "<<nr2D<<" "<<nr3D<<" "<<nrM<<endl;

	if(isNotFull() && nrM<MAX_NR) {
		id[2*MAX_NR+nrM]=nr2D+nr3D+nrM+nrGRASS+nrVTK+nr4D;
		listM[nrM++] = *g;

		kdDebug()<<"GraphList::addGraphM : nrM = "<<nrM<<endl;
		kdDebug()<<"GraphList::addGraph3D : id["<<2*MAX_NR+nrM-1<<"] = "<<endl;
		kdDebug()<<id[2*MAX_NR+nrM-1]<<endl;
		kdDebug()<<"Type = "<<g->Type()<<endl;
		kdDebug()<<"Type = "<<listM[nrM-1].Type()<<endl;

		return 1;
	}
	return 0;
}

int GraphList::addGraphGRASS(GraphGRASS *g) {
	kdDebug()<<"GraphList::addGraphGRASS : isNotFull() = "<<isNotFull()<<endl;
	kdDebug()<<"GraphList::addGraphGRASS : nr(2D,3D,M,GRASS) = "<<nr2D<<" "<<nr3D<<" "<<nrM<<" "<<nrGRASS<<endl;

	if(isNotFull() && nrGRASS<MAX_NR) {
		id[3*MAX_NR+nrGRASS]=nr2D+nr3D+nrM+nrGRASS+nrVTK+nr4D;
		listGRASS[nrGRASS++] = *g;

		kdDebug()<<"GraphList::addGraphGRASS : nrGRASS = "<<nrGRASS<<endl;
		kdDebug()<<"GraphList::addGraphGRASS : id["<<3*MAX_NR+nrGRASS-1<<"] = "<<endl;
		kdDebug()<<id[3*MAX_NR+nrGRASS-1]<<endl;
		kdDebug()<<"Type = "<<g->Type()<<endl;
		kdDebug()<<"Type = "<<listGRASS[nrGRASS-1].Type()<<endl;

		return 1;
	}
	return 0;
}

int GraphList::addGraphVTK(GraphVTK *g) {
	kdDebug()<<"GraphList::addGraphVTK : isNotFull() = "<<isNotFull()<<endl;
	kdDebug()<<"GraphList::addGraphVTK : nr(2D,3D,M,GRASS) = "<<nr2D<<" "<<nr3D<<" "<<nrM<<" "<<nrGRASS<<endl;

	if(isNotFull() && nrVTK<MAX_NR) {
		id[4*MAX_NR+nrVTK]=nr2D+nr3D+nrM+nrGRASS+nrVTK+nr4D;
		listVTK[nrVTK++] = *g;

		kdDebug()<<"GraphList::addGraphVTK : nrVTK = "<<nrVTK<<endl;
		kdDebug()<<"GraphList::addGraphVTK : id["<<4*MAX_NR+nrVTK-1<<"] = "<<endl;
		kdDebug()<<id[4*MAX_NR+nrVTK-1]<<endl;
		kdDebug()<<"Type = "<<g->Type()<<endl;
		kdDebug()<<"Type = "<<listVTK[nrVTK-1].Type()<<endl;

		return 1;
	}
	return 0;
}

int GraphList::addGraph4D(Graph4D *g) {
	kdDebug()<<"GraphList::addGraph4D : isNotFull() = "<<isNotFull()<<endl;
	kdDebug()<<"GraphList::addGraph4D : nr(2D,3D,M) = "<<nr2D<<" "<<nr3D<<" "<<nrM<<endl;

	if(isNotFull() && nr4D<MAX_NR) {
		id[5*MAX_NR+nr4D]=nr2D+nr3D+nrM+nrGRASS+nrVTK+nr4D;
		list4D[nr4D++] = *g;

		kdDebug()<<"GraphList::addGraph4D : nr4D = "<<nr4D<<endl;
		kdDebug()<<"GraphList::addGraph4D : id["<<5*MAX_NR+nr4D-1<<"] = "<<endl;
		kdDebug()<<id[5*MAX_NR+nr4D-1]<<endl;
		kdDebug()<<"Type = "<<g->Type()<<endl;
		kdDebug()<<"Type = "<<list4D[nr4D-1].Type()<<endl;

		return 1;
	}
	return 0;
}

int GraphList::delGraph(unsigned int index) {
	unsigned int i=index;

	//kdDebug()<<"GraphList::delGraph : index = "<<index<<endl;

	if(index <= nr2D+nr3D+nrM+nrGRASS+nrVTK+nr4D) {
		GRAPHType s = getStruct(index);
		switch (s) {
		case GRAPH2D:
			nr2D--;
			while (i<nr2D) {
				list2D[i] = list2D[i+1];
				i++;
			}
			break;
		case GRAPH3D:
			nr3D--;
			while (i<nr3D) {
				list3D[i] = list3D[i+1];
				i++;
			}
			break;
		case GRAPHM:
			nrM--;
			while (i<nrM) {
				listM[i] = listM[i+1];
				i++;
			}
			break;
		case GRAPHGRASS:
			nrGRASS--;
			while (i<nrGRASS) {
				listGRASS[i] = listGRASS[i+1];
				i++;
			}
			break;
		case GRAPHVTK:
			nrVTK--;
			while (i<nrVTK) {
				listVTK[i] = listVTK[i+1];
				i++;
			}
			break;
		case GRAPH4D:
			nr4D--;
			while (i<nr4D) {
				list4D[i] = list4D[i+1];
				i++;
			}
			break;
		}	

		kdDebug()<<"GraphList::delGraph : nr(2D,3D,M,GRASS,VTK,4D) = ";
		kdDebug()<<nr2D<<' '<<nr3D<<' '<<nrM<<' '<<nrGRASS<<' '<<nrVTK<<' '<<nr4D<<endl;

		return 1;
	}
	return 0;
}

GRAPHType GraphList::getStruct(int index) {
	for(int i=0;i<MAX_NR;i++) {
		//printf("\ti=%d, id[i]=%d,id[i+MAX_NR]=%d,id[i+2*MAX_NR]=%d\n",
		//		i,id[i],id[i+MAX_NR],id[i+2*MAX_NR]);

		if (id[i] == index) {
			return GRAPH2D;
		}
		else if (id[MAX_NR+i] == index) {
			return GRAPH3D;
		}
		else if (id[2*MAX_NR+i] == index) {
			return GRAPHM;
		}
		else if (id[3*MAX_NR+i] == index) {
			return GRAPHGRASS;
		}
		else if (id[4*MAX_NR+i] == index) {
			return GRAPHVTK;
		}
		else if (id[5*MAX_NR+i] == index) {
			return GRAPH4D;
		}
	}
	return GRAPH2D;	//default return
}

int GraphList::getIndex(int index) {
	for(int i=0;i<MAX_NR;i++) {
		if (id[i] == index || id[MAX_NR+i] == index || id[2*MAX_NR+i] == index || 
			id[3*MAX_NR+i] == index || id[4*MAX_NR+i] == index || id[5*MAX_NR+i] == index) {
			return i;
		}
	}
	return 0;
}

Graph *GraphList::getGraph(unsigned int i) {
	kdDebug()<<"GraphList::getGraph(i) i="<<i<<endl;
	if(i <= nr2D+nr3D+nrM+nrGRASS+nrVTK+nr4D) {
		GRAPHType s = getStruct(i);
		kdDebug()<<"Graph Struct = "<<s<<endl;
		kdDebug()<<"Index = "<<getIndex(i)<<endl;
		switch (s) {
		case GRAPH2D:
			return (Graph *) &list2D[getIndex(i)];
			break;
		case GRAPH3D:
			return (Graph *) &list3D[getIndex(i)];
			break;
		case GRAPHM:
			return (Graph *) &listM[getIndex(i)];
			break;
		case GRAPHGRASS:
			return (Graph *) &listGRASS[getIndex(i)];
			break;
		case GRAPHVTK:
			return (Graph *) &listVTK[getIndex(i)];
			break;
		case GRAPH4D:
			return (Graph *) &list4D[getIndex(i)];
			break;
		}
	}
	return 0;
}

Graph2D *GraphList::getGraph2D(int i) {
	if (i >= getIndex(i))
		return &list2D[getIndex(i)];
	return 0;
}	

Graph3D *GraphList::getGraph3D(int i) {
	if (i >= getIndex(i))
		return &list3D[getIndex(i)];
	return 0;
}	

GraphM *GraphList::getGraphM(int i) {
	if (i >= getIndex(i))
		return &listM[getIndex(i)];
	return 0;
}	

GraphGRASS *GraphList::getGraphGRASS(int i) {
	if (i >= getIndex(i))
		return &listGRASS[getIndex(i)];
	return 0;
}	

GraphVTK *GraphList::getGraphVTK(int i) {
	if (i >= getIndex(i))
		return &listVTK[getIndex(i)];
	return 0;
}

Graph4D *GraphList::getGraph4D(int i) {
	if (i >= getIndex(i))
		return &list4D[getIndex(i)];
	return 0;
}	

