//LabPlot : Graph.h

#ifndef GRAPH_H
#define GRAPH_H

#include <qstring.h>
#include <qstringlist.h>
#include <klocale.h>
#include "LRange.h"
#include "Style.h"
#include "Symbol.h"
#include "AnnotateValues.h"
#include "defs.h"

class Graph
{
public:
	Graph(QString n="", QString label="",int t=0, Style st=Style(), 
			Symbol sy=Symbol(),int nr=0, bool s=TRUE);
	void openGraph(QTextStream *t,int version);
	void saveGraph(QTextStream *t);
	QString Name() { return name; }
	QString Label() { return label; }
	void setLabel(QString l) { label=l; }
	PType Type() { return type; }
	Style getStyle() { return style; }
	void setStyle(Style s) { style = s; }
	Symbol getSymbol() { return symbol; }
	void setSymbol(Symbol s) { symbol = s; }
	int Number() { return number; }
	void setNumber(int n) { number = n; }
	bool isShown() { return shown; }
	void setShown(bool b) { shown = b; }
	AnnotateValues getAnnotateValues() { return av; }
	void setAnnotateValues(AnnotateValues a) { av=a;}
	
protected:
	QString name, label;	// name and label (plotted name)
	PType type;		// plot type of a graph
	Style style;
	Symbol symbol;
	int number;
	bool shown;		// shown/hidden
	AnnotateValues av;
};

#endif // GRAPH_H
