//LabPlot : FilterNETCDF.h

#ifndef FILTERNETCDF_H
#define FILTERNETCDF_H

#include <qstring.h>
#include <qstringlist.h>

#include <netcdf.h>

struct ncdim {			// dimension
    char name[NC_MAX_NAME];
    size_t size;
};

struct ncvar {				// variable
    char name[NC_MAX_NAME];
    nc_type type;
    int ndims;
    int dims[MAX_VAR_DIMS];
    int natts;
    bool has_fillval;
    double fillval;
};

struct ncatt {				// attribute
    int var;
    char name[NC_MAX_NAME];
    nc_type type;
    size_t len;
    char *string;				// for text attributes (type = NC_CHAR)
    double *vals;			// for numeric attributes of all types
};

class FilterNETCDF
{
public:
	FilterNETCDF(QString filename=0);
	bool fileOK() { return fileok; }
	QString version() { return QString(nc_inq_libvers());}
	int getNDims() { return ndims; }
	int getNVars() { return nvars; }
	int getNAtts() { return natts; }
	int getDimId() { return xdimid; }
	QString getDim(int dimid);				// get dimension dimid
	QString getVar(int varid);					// get variable varid
	QString getAtt(int aid) { return pr_att(ncid, NC_GLOBAL, "", aid); } // get attribute aid
	int getVarLen(QString var);				// get length of variable var
	QStringList getDataString(int varid);		// get variable data as string
	double getData(QString var,const size_t index);		// get data for variable var at index
protected:
	QString typeName(nc_type type);
	QString pr_att_string(size_t len,const char *string);
	QString pr_att_vals(nc_type type,size_t len,const double *vals);
	QString pr_att(int ncid,int varid,const char *varname, int ia);
private:
	QString filename;					// file
	bool fileok;						// is a netcdf file and readable
	int ncid, ndims, nvars, natts, xdimid;	// netcdf id / number of dimensions / vars / attributes / dim id
	ncdim dims[NC_MAX_DIMS];			// nc dimensions
};

#endif //FILTERNETCDF_H
