/***************************************************************************
 *
 *  $Id: kzenprogressdialog.h,v 1.4 2005/06/28 18:54:31 muszilla Exp $
 *
 *  Copyright (C) 2005 by Andreas Mussgiller
 *  muszilla@users.sourceforge.net
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the
 *  Free Software Foundation, Inc.,
 *  59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 ***************************************************************************/

#ifndef KZENPROGRESSDIALOG_H
#define KZENPROGRESSDIALOG_H

#include <libnjb.h>

#include <kdialogbase.h>
#include <klistview.h>

class KZenTrack;

/**
@author Andreas Mussgiller
*/
class KZenProgressDialog : public KDialogBase
{
  Q_OBJECT

 public:

  KZenProgressDialog(QWidget *parent = 0, 
		     const char *name = 0);
  virtual ~KZenProgressDialog();

  void                        addTrack(KZenTrack *, bool upload);
  void                        removeFirst();

  void                        refresh(int percentage);

  int                         getCount() { return fCount; }

 protected slots:

  void                        slotCancel();

 signals:

  void                        cancelRequest(bool);

 protected:

  KListView                  *fListView;
  int                         fCount;
};

#endif
