/***************************************************************************
 *   Copyright (C) 2005 by Roland Weigert                                  *
 *   roweigert@t-online.de                                                 *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
using namespace std;

#include "verzeichnis.h"

extern databasewrapper *database;
extern rcdatei einstellungen;

verzeichnis::verzeichnis(QString name,fileselector *mother=0)
{
    motherwidget=mother;
    arbeitsverzeichnis=new QDir();
    verzeichnisname=name;
    vor=TRUE;
    progress=0;
    abortscan=FALSE;
    vzaehler=0;
    dzaehler=0;
    KIconLoader *loader=new KIconLoader("KYamo");
    QString picname;
    picname="folder.png";
    folderpic=loader->loadIcon(picname,KIcon::NoGroup);
    folderpic=folderpic.smoothScale(16,16,QImage::ScaleFree);
    picname="mime_sound.png";
    filepic=loader->loadIcon(picname,KIcon::NoGroup);
    filepic=filepic.smoothScale(16,16,QImage::ScaleFree);
    picname="filesave.png";
    savedpic=loader->loadIcon(picname,KIcon::NoGroup);
    savedpic=savedpic.smoothScale(16,16,QImage::ScaleFree);
    picname="ok.png";
    saveokpic=loader->loadIcon(picname,KIcon::NoGroup);
    saveokpic=saveokpic.smoothScale(16,16,QImage::ScaleFree);
    delete loader;
    if (!verzeichnisname.endsWith("/"))
    {
        //immer / anh�gen da sonst crash
        verzeichnisname.append("/");
    }
    if (!verzeichnisname.compare("/"))
    {
        QMessageBox::warning(0,i18n("access error"),i18n("I will not scan in the root-directory"),"&Ok",QString::null,QString::null,1);
        abortscan=TRUE;
        return;
    }
    QFileInfo dateiinfo(verzeichnisname);
    if (!dateiinfo.exists())
    {
        QMessageBox::warning(0,i18n("access error"),i18n("the reading directory doesn't exist"),"&Ok",QString::null,QString::null,1);
        abortscan=TRUE;
        {
            return;
        }
    }
    arbeitsverzeichnis->setCurrent(verzeichnisname);
    arbeitsverzeichnis->setNameFilter("*.mp3;*.ogg");
    arbeitsverzeichnis->setSorting(arbeitsverzeichnis->Files);
    dateiliste=arbeitsverzeichnis->entryList();
    arbeitsverzeichnis->setNameFilter("*");
    arbeitsverzeichnis->setFilter (arbeitsverzeichnis->Dirs);
    arbeitsverzeichnis->setSorting(arbeitsverzeichnis->Dirs);
    QStringList puffer=arbeitsverzeichnis->entryList();
    //alle Eintr�e mit Punkt am Anfang berspringen und in Rest in verzeichnisliste schreiben
    QStringList::Iterator index=puffer.begin();
    do
    {
        if (!(QString(*index).startsWith(".")))
            verzeichnisliste.append(*index);
        ++index;
    }
    while (index != puffer.end());
}

verzeichnis::~verzeichnis()
{
    delete arbeitsverzeichnis;
}

void verzeichnis::rekursivmodus(QString name)
{
    QFileInfo dateiinfo(name);
    if (!dateiinfo.isReadable()||dateiinfo.isSymLink())
    {
        return;//Wenn nicht lesbar, auslassen!
    }
    if (!abortscan)
    {
        QString kompletterpfad;
        if (QString::compare(name,this->verzeichnisname))//Wenn nicht startverzeichnis
        {
            arbeitsverzeichnis->setCurrent(name);
            //Alle bearbeitbaren Dateien mit Pfad in dateiliste eintragen
            arbeitsverzeichnis->setNameFilter("*.mp3;*.ogg");
            arbeitsverzeichnis->setSorting(QDir::Files);
            arbeitsverzeichnis->setFilter(QDir::Files);
            QStringList puffer;
            QStringList::Iterator index;
            puffer=arbeitsverzeichnis->entryList();
            index=puffer.begin();
            while(index != puffer.end())
            {
                QString dateiname=QString("%1/%2").arg(name,QString(*index));
                this->dateiliste.append(dateiname);
                dzaehler++;
                index++;
            };
            arbeitsverzeichnis->setNameFilter("*");
            arbeitsverzeichnis->setFilter (QDir::Dirs);
            arbeitsverzeichnis->setSorting(QDir::Dirs);
            puffer=arbeitsverzeichnis->entryList();
            //alle Eintr�e mit Punkt am Anfang berspringen
            index=puffer.begin();
            while (index != puffer.end())
            {
                if (!(QString(*index).startsWith(".")))
                {
                    kompletterpfad=QString("%1/%2").arg(name,QString(*index));
                    this->rekursivmodus(kompletterpfad);//in n�hste rekursionsstufe springen
                }
                index++;
            };
        }
        else
        {
            QStringList::Iterator index=this->verzeichnisliste.begin();
            while(index != this->verzeichnisliste.end())
            {
                kompletterpfad=QString("%1%2").arg(name,QString(*index));
                this->rekursivmodus(kompletterpfad);
                vzaehler++;
                index++;
            };
        }
    }
}

void verzeichnis::treemodus(QString name,fileselectoritem *folder,progressinfo *scanprocess)
{
    if (!this->abbruch)
    {
        //folder as motherwidget to organise tree
        QString kompletterpfad;
        QString progresstext;
        QFileInfo dateiinfo(name);
        if (!dateiinfo.isReadable())
            return;//Wenn Verzeichnis nicht lesbar, auslassen
        if (QString::compare(name,verzeichnisname))//Wenn nicht startverzeichnis
        {
            arbeitsverzeichnis->setCurrent(name);
            //Alle bearbeitbaren Dateien mit Pfad in dateiliste eintragen
            arbeitsverzeichnis->setNameFilter("*.mp3;*.ogg");
            arbeitsverzeichnis->setSorting(QDir::Files);
            arbeitsverzeichnis->setFilter(QDir::Files);
            QStringList puffer;
            QStringList::Iterator index;
            puffer=arbeitsverzeichnis->entryList();
            index=puffer.begin();
            while(index != puffer.end())
            {
                QString completename=QString("%1/%2").arg(name,QString(*index));
                new fileselectoritem(folder,*index,completename,FALSE,motherwidget);
                QString dateiname=QString("%1/%2").arg(name,QString(*index));
                dateiliste.append(dateiname);
                dzaehler++;
                progresstext=QString(i18n("%1 musicfiles")).arg(dzaehler)+QString(i18n(" %1 directories")).arg(vzaehler);
                scanprocess->setText(progresstext);
                index++;
            };
            arbeitsverzeichnis->setNameFilter("*");
            arbeitsverzeichnis->setFilter (QDir::Dirs);
            arbeitsverzeichnis->setSorting(QDir::Dirs);
            puffer=arbeitsverzeichnis->entryList();
            //alle Eintr�e mit Punkt am Anfang berspringen
            index=puffer.begin();
            while (index != puffer.end()&&!abbruch)
            {
                if (!(QString(*index).startsWith(".")))
                {
                    kompletterpfad=QString("%1/%2").arg(name,QString(*index));
                    QFileInfo linktest(kompletterpfad);
                    if (!linktest.isSymLink())
                    {
                        QString completename=QString("%1/%2").arg(name,QString(*index));
                        fileselectoritem *aktuell=new fileselectoritem(folder,*index,completename,TRUE,motherwidget);
                        vzaehler++;
                        progresstext=QString(i18n("%1 musicfiles")).arg(dzaehler)+QString(i18n(" %1 directories")).arg(vzaehler);
                        scanprocess->setText(progresstext);
                        aktuell->setExpandable(TRUE);
                        this->treemodus(kompletterpfad,aktuell,scanprocess);//in n�hste rekursionsstufe springen
                    }
                }
                index++;
            };
        }
        else
        {
            //alte Dateiliste in Sicherheit bringen, um sie hinten an Baum anzuh�gen
            QStringList dateiliste2=dateiliste;
            QStringList::Iterator dirindex=this->verzeichnisliste.begin();
            while(dirindex != this->verzeichnisliste.end()&&!abbruch)
            {
                kompletterpfad=QString("%1%2").arg(name,*dirindex);
                QFileInfo linktest(kompletterpfad);
                if (!linktest.isSymLink())
                {
                    fileselectoritem *aktuell=new fileselectoritem(folder,*dirindex,kompletterpfad,TRUE,motherwidget);
                    vzaehler++;
                    progresstext=QString(i18n("%1 musicfiles")).arg(dzaehler)+QString(i18n(" %1 directories")).arg(vzaehler);
                    scanprocess->setText(progresstext);
                    this->treemodus(kompletterpfad,aktuell,scanprocess);
                    dirindex++;
                }
            };
            QStringList::Iterator dateiindex=dateiliste2.begin();
            while(dateiindex !=dateiliste2.end())
            {
                QString completename;
                if (name.endsWith("/"))
                    completename=QString("%1%2").arg(name,*dateiindex);
                else
                    completename=QString("%1/%2").arg(name,*dateiindex);
                fileselectoritem *aktuell=new fileselectoritem(folder,*dateiindex,completename,FALSE,motherwidget);
                dzaehler++;
                progresstext=QString(i18n("%1 musicfiles")).arg(dzaehler)+QString(i18n(" %1 directories")).arg(vzaehler);
                scanprocess->setText(progresstext);
                dateiindex++;
            };
        }
        progresstext=QString(i18n("%1 musicfiles")).arg(dzaehler)+QString(i18n(" %1 directories")).arg(vzaehler);
    }
}

void verzeichnis::scanverzeichnis(progresswithbar *scanprocess)
{
    if (!abbruch)
    {
        QString aktuelledatei;
        long zaehler=0;
        abbruch=FALSE;
        connect(scanprocess,SIGNAL(cancelled()),SLOT(abbruchslot()));
        QStringList::Iterator index = this->dateiliste.begin();
        QString progresstext;
        if (verzeichnisname.endsWith("/"))
            verzeichnisname=verzeichnisname.left(verzeichnisname.length()-1);
        while( index != this->dateiliste.end()&&!abbruch)
        {
            if (!QString(*index).startsWith("/"))
                aktuelledatei=QString("%1/%2").arg(verzeichnisname,*index);
            else
                aktuelledatei=QString(*index);
            //first check, if we need to read the file in, or if it is already standing with this timestamp in the table
            if(!database->checkModified(aktuelledatei))
            {
                mediafile *file=new mediafile(aktuelledatei);
                if (file->readsuccess)
                {
                    file->readTags();
                    if (file->containsTag)
                    {
                        mediatag Song;
                        Song=file->taginfo;
                        database->writetag(&Song,aktuelledatei);
                    }
                }
                delete file;
            }
            scanprocess->setProgress(zaehler++);
            ++index;
        }
    }
}

int verzeichnis::musikgefunden()
{
    if(!dateiliste.isEmpty())
        return TRUE;
    else
        return FALSE;
}

void verzeichnis::abbruchslot()
{
    abbruch=TRUE;
    abortscan=TRUE;
}

void verzeichnis::zaehlen()
{
    dzaehler=0;
    QStringList::Iterator dateiindex=dateiliste.begin();
    while(dateiindex !=dateiliste.end())
    {
        dzaehler++;
        dateiindex++;
    }
}
