/***************************************************************************
 *   Copyright (C) 2005 by Roland Weigert   *
 *   roweigert@t-online.de   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef _TAGGGUESSER_H_
#define _TAGGGUESSER_H_

#include <qdialog.h>
#include <qstring.h>
#include <qstringlist.h>
#include <qfile.h>
#include <qdir.h>
#include <qtextstream.h>
#include <qmessagebox.h>
#include <qpixmap.h>
#include <qimage.h>
#include <kapp.h>
#include <klocale.h>

#include "tagenginewrapper.h"
#include "mediatag.h"
#include "fileselector.h"
#include "mnemnomic.h"
#include "choicebox.h"
#include "filtergenerator.h"
#include "databasewrapper.h"
#include "musicbrainz-interface.h"

using namespace std;

class guessfilter;
extern musicbrainzconnect *mbhelp;

/*This Dialog is for tagguessing
 *It only pops up, if it needs help from user
 *It uses filters stored in the k-yamo-filters, and initializes them in memory before first use*/

class tagguesser : public QDialog
{
public:
    tagguesser(fileselector *);
    ~tagguesser();
    bool checkfile(fileselectoritem *);
    bool changedtags;
private:
    fileselector *directorytree;
    void initfilters();
    void savefilters();
    bool setFilter(QString);
    bool generateNewFilter(QString);
    void guess(fileselectoritem *);
    bool success;
    QString filename;
    mediatag filetags;
    QStringList filterlist;
    QPtrList<guessfilter> workingfilters;
    QPtrList<guessfilter> matchingfilters;
    guessfilter *defaultfilter;
};

//This class is here to keep all filters initialized in the memory, when the tagguesser is running

class guessfilter
{
public:
    guessfilter(QString);
    ~guessfilter();
    QString filtertext;
    QStringList mnemnomiclist;
    bool filterok;
    QString errortext;
};
#endif //_TAGGUESSER_H_
