/***************************************************************************
 *   Copyright (C) 2005 by Roland Weigert   *
 *   roweigert@t-online.de   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#include "progress.h"

progressmainwindow::progressmainwindow(bool mode)
{
    multimode=mode;
    userabort=FALSE;
    this->setModal(TRUE);
    runningprogresses=0;
    iscancelled=FALSE;
    progresslayout = new QVBox(this);
    taskslayout=new QVBox(progresslayout);
    if (multimode)
    {
        cancelallbutton=new QPushButton(i18n("Cancel all Processes"),progresslayout);
        KIconLoader *loader=new KIconLoader("KYamo");
        QString picname;
        picname="cancel.png";
        QImage cancelpic;
        cancelpic=loader->loadIcon(picname,KIcon::NoGroup);
        QIconSet buttonset(cancelpic);
        cancelallbutton->setIconSet(buttonset);
        delete loader;
        connect (cancelallbutton,SIGNAL(clicked()),SLOT(cancelAll()));
    }
    //connect a timer to the update-slot, so gui gets refrehed smoothly
    refreshtimer=new QTimer(this);
    connect (refreshtimer,SIGNAL(timeout()),this,SLOT(refreshdialog()));
    refreshtimer->start(20,0);
}

progressmainwindow::~ progressmainwindow()
{
   cerr<<"progresswindow destructor"<<endl;
    if (multimode)
    delete cancelallbutton;
    delete taskslayout;
    delete progresslayout;
    delete refreshtimer;
}

void progressmainwindow::refreshdialog()
{
    taskslayout->adjustSize();
    progresslayout->adjustSize();
    this->adjustSize();
}

void progressmainwindow::closeEvent(QCloseEvent* ce)
{
    cancelAll();
    ce->accept();
    return;
}

//Startfunctions for the progresswidgets
progresswithbar * progressmainwindow::startProgress(QString text,long max,KProcess *proc)
{
    runningprogresses++;
    if (runningprogresses>1)
        this->setCaption(i18n("%1 Processes are running").arg(QString::number(runningprogresses)));
    if (runningprogresses==1)
        this->setCaption(i18n("1 Process is running"));
    progresswithbar *object=new progresswithbar(text,max,taskslayout,proc);
    object->barbox->show();
    resizeprogresswindow();
    connect(this,SIGNAL(cancelprogresses()),object,SLOT(cancelProcess()));
    return object;
}

progresswithbar * progressmainwindow::startProgress(QString text,long max)
{
    runningprogresses++;
    if (runningprogresses>1)
        this->setCaption(i18n("%1 Processes are running").arg(QString::number(runningprogresses)));
    if (runningprogresses==1)
        this->setCaption(i18n("1 Process is running"));
    progresswithbar *object=new progresswithbar(text,max,taskslayout);
    object->barbox->show();
    connect(this,SIGNAL(cancelprogresses()),object,SLOT(cancelProcess()));
    return object;
}

progressinfo * progressmainwindow::startInfo(QString text)
{
    runningprogresses++;
    if (runningprogresses>1)
        this->setCaption(i18n("%1 Processes are running").arg(QString::number(runningprogresses)));
    if (runningprogresses==1)
        this->setCaption(i18n("1 Process is running"));
    progressinfo *object=new progressinfo(text,taskslayout,this);
    object->infobox->show();
    connect(this,SIGNAL(cancelprogresses()),object,SLOT(cancelProcess()));
    return object;
}

progressinfoonly * progressmainwindow::startInfoOnly(QString text)
{
    runningprogresses++;
    if (runningprogresses>1)
        this->setCaption(i18n("%1 Processes are running").arg(QString::number(runningprogresses)));
    if (runningprogresses==1)
        this->setCaption(i18n("1 Process is running"));
    progressinfoonly *object=new progressinfoonly(text,taskslayout,this);
    object->infobox->show();
    return object;
}

void progressmainwindow::resizeprogresswindow()
{
    taskslayout->adjustSize();
    progresslayout->adjustSize();
    this->adjustSize();
}

//deletefunctions for the progresswidgets
void progressmainwindow::killProgress(progresswithbar *object)
{
    this->runningprogresses--;
    if (this->runningprogresses>1)
        this->setCaption(i18n("%1 Processes are running").arg(QString::number(runningprogresses)));
    if (this->runningprogresses==1)
        this->setCaption(i18n("1 Process is running"));
    delete object;
}

void progressmainwindow::killProgress(progressinfo *object)
{
    runningprogresses--;
    delete object;
    if (runningprogresses>1)
        this->setCaption(i18n("%1 Processes are running").arg(QString::number(runningprogresses)));
    if (runningprogresses==1)
        this->setCaption(i18n("1 Process is running"));
}

void progressmainwindow::killProgress(progressinfoonly *object)
{
    runningprogresses--;
    delete object;
    if (runningprogresses>1)
        this->setCaption(i18n("%1 Processes are running").arg(QString::number(runningprogresses)));
    if (runningprogresses==1)
        this->setCaption(i18n("1 Process is running"));
}

void progressmainwindow::cancelAll()
{
    iscancelled=TRUE;
    userabort=TRUE;
    emit cancelprogresses();
}

//Different Progresswidgets

//Progressbar-Class
progresswithbar::progresswithbar(QString text,long max,QWidget *parent,KProcess *proc)
{
    iscancelled=FALSE;
    progressedProcess=proc;
    barbox=new QGroupBox(1,Qt::Horizontal,parent);
    line1box=new QGroupBox(2,Qt::Horizontal,barbox);
    barlabel=new QLabel(text,line1box);
    cancelbutton=new QPushButton(i18n("Cancel"),line1box);
    bar=new QProgressBar(max,barbox,"progress");
    KIconLoader *loader=new KIconLoader("KYamo");
    QString picname;
    picname="stop.png";
    QImage cancelpic;
    cancelpic=loader->loadIcon(picname,KIcon::NoGroup);
    QIconSet buttonset(cancelpic);
    cancelbutton->setIconSet(buttonset);
    connect(cancelbutton,SIGNAL(clicked()),SLOT(cancelProcess()));
}

progresswithbar::progresswithbar(QString text,long max,QWidget *parent)
{
    progressedProcess=NULL;
    iscancelled=FALSE;
    barbox=new QGroupBox(1,Qt::Horizontal,parent);
    line1box=new QGroupBox(2,Qt::Horizontal,barbox);
    barlabel=new QLabel(text,line1box);
    cancelbutton=new QPushButton(i18n("Cancel"),line1box);
    bar=new QProgressBar(max,barbox,"progress");
    KIconLoader *loader=new KIconLoader("KYamo");
    QString picname;
    picname="stop.png";
    QImage cancelpic;
    cancelpic=loader->loadIcon(picname,KIcon::NoGroup);
    QIconSet buttonset(cancelpic);
    cancelbutton->setIconSet(buttonset);
    connect(cancelbutton,SIGNAL(clicked()),SLOT(cancelProcess()));
}

progresswithbar::~progresswithbar()
{
    delete cancelbutton;
    delete bar;
    delete barlabel;
    delete line1box;
    delete barbox;
}


void progresswithbar::setProgress(long value)
{
    bar->setProgress(value);
    kapp->processEvents();
}

void progresswithbar::cancelProcess()
{
    if(progressedProcess)
        this->progressedProcess->kill();
    iscancelled=TRUE;
    emit cancelled();
}

//Infobox-Class

progressinfo::progressinfo(QString text,QWidget *parent,progressmainwindow *pointer)
{
    progresswindow=pointer;
    infobox=new QGroupBox(1,Qt::Horizontal,parent);
    infolabel=new QLabel(text,infobox);
    cancelbutton=new QPushButton(i18n("Cancel"),infobox);
    KIconLoader *loader=new KIconLoader("KYamo");
    QString picname;
    picname="stop.png";
    QImage cancelpic;
    cancelpic=loader->loadIcon(picname,KIcon::NoGroup);
    QIconSet buttonset(cancelpic);
    cancelbutton->setIconSet(buttonset);
    connect(cancelbutton,SIGNAL(clicked()),SLOT(cancelProcess()));
     refreshtimer=new QTimer(this);
    connect (refreshtimer,SIGNAL(timeout()),this,SLOT(refreshwidget()));
    refreshtimer->start(20,0);
}

progressinfo::~ progressinfo()
{
    delete cancelbutton;
    delete infolabel;
    delete infobox;
}

void progressinfo::setText(QString text)
{
    infolabel->setText(text);
    kapp->processEvents();
}

void progressinfo::cancelProcess()
{
    emit cancelled();
}
void progressinfo::refreshwidget()
{
    infolabel->adjustSize();
    infobox->adjustSize();
}

//Infobox without cancel class

progressinfoonly::progressinfoonly(QString text,QWidget *parent,progressmainwindow *pointer)
{
    progresswindow=pointer;
    infobox=new QGroupBox(1,Qt::Vertical,parent);
    infolabel=new QLabel(text,infobox);
    infobox->adjustSize();
     refreshtimer=new QTimer(this);
    connect (refreshtimer,SIGNAL(timeout()),this,SLOT(refreshwidget()));
    refreshtimer->start(20,0);
   kapp->processEvents();
}

progressinfoonly::~progressinfoonly()
{
    delete infolabel;
    delete infobox;
}

void progressinfoonly::setText(QString text)
{
    infolabel->setText(text);
    kapp->processEvents();
}

void progressinfoonly::refreshwidget()
{
    infolabel->adjustSize();
    infobox->adjustSize();
}
