/***************************************************************************
 *   Copyright (C) 2005 by Roland Weigert   *
 *   roweigert@t-online.de   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#include <iostream>

using namespace std;

#include "ogg-interface.h"

oggfile::oggfile(QString attachedfile)
{
  containsTag=FALSE;
  readsuccess=FALSE;
  bitrate=0;
  workingfile=NULL;
  filename=attachedfile.local8Bit();
  /* Check for the file first, before any further actions, to avoid opening not existing files
   * Calling routine will recognize this over the boolean readsuccess */
  QFileInfo filecheck(filename);
  if (filecheck.exists()&&filecheck.isFile())
    {
      readsuccess=TRUE;
      workingfile=new TagLib::FileRef(filename.local8Bit());
      bitrate=workingfile->audioProperties()->bitrate();
      v1tag.songlength=workingfile->audioProperties()->length();
    }
  else
    readsuccess=FALSE;
}

oggfile::~oggfile()
{
  //if workingfile points to valid file, delete it
  if (workingfile)
    delete workingfile;
}

void oggfile::setTags(mediatag song)
{
  //We use v1tag, to keep almost the same api, than the other file-classes
  v1tag=song;
}

void oggfile::readTags()
{
  v1tag.number=workingfile->tag()->track();
  v1tag.title=TStringToQString(workingfile->tag()->title());
  v1tag.album=TStringToQString(workingfile->tag()->album());
  v1tag.artist=TStringToQString(workingfile->tag()->artist());
  v1tag.year=workingfile->tag()->year();
  v1tag.genre=TStringToQString(workingfile->tag()->genre());
  if (!v1tag.album.isEmpty()||!v1tag.artist.isEmpty()||!v1tag.title.isEmpty()||!v1tag.genre.isEmpty())
    containsTag=TRUE;
}

bool oggfile::saveFile()
{
  workingfile->tag()->setTrack(v1tag.number);
  workingfile->tag()->setYear(v1tag.year);
  workingfile->tag()->setTitle(QStringToTString(v1tag.title));
  workingfile->tag()->setAlbum(QStringToTString(v1tag.album));
  workingfile->tag()->setArtist(QStringToTString(v1tag.artist));
  workingfile->tag()->setGenre(QStringToTString(v1tag.genre));
  workingfile->save();
}
