/***************************************************************************
 *   Copyright (C) 2005 by Roland Weigert   *
 *   roweigert@t-online.de   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#include "mplayerinterface.h"

extern rcdatei settingsfile;

mplayerinterface::mplayerinterface()
{
    maxtime=0;
    actualtime=0;
    isplaying=FALSE;
    playerProcess=new KProcess;
}

mplayerinterface::~mplayerinterface()
{
    delete playerProcess;
}

void mplayerinterface::stop()
{
    if (playerProcess->isRunning())
        playerProcess->kill();
    delete playerProcess;
    playerProcess=new KProcess;
}

void mplayerinterface::pause()
{
    char command[]=" ";
    playerProcess->writeStdin(command,sizeof(command));
    kapp->processEvents();
}

int mplayerinterface::play(QString filename)
{
    int status=0;
    maxtime=0;
    emit songtime(0);
    /*first check if the file exists and check the mplayerexe
      give back FALSE, if something seems to be strange*/
    if (settingsfile.mplayerexe.contains("mplayer"))
    {
        QFileInfo checkmplayer(settingsfile.mplayerexe);
        QFileInfo checktrack(filename);
        status=checkmplayer.exists()&&checktrack.exists();
        if (status)
        {
            connect(playerProcess,SIGNAL(processExited(KProcess *)),SLOT(playerstopped(KProcess *)));
            connect(playerProcess,SIGNAL(receivedStdout (KProcess *,char *,int)),this,SLOT(getstatus(KProcess *,char *,int)));
            *playerProcess<<settingsfile.mplayerexe;
            *playerProcess<<"\""<<filename<<"\"";
            playerProcess->start(KProcess::RunMode(1),KProcess::Communication(7));
            isplaying=TRUE;
        }
        else
        {
            if (!checkmplayer.exists()&&!checktrack.exists())
            {
                //Track and player missing
                QMessageBox::warning(0,i18n("Player error"),i18n("Mplayer-Executable and the selected track are missing"),QMessageBox::Ok,QMessageBox::NoButton,QMessageBox::NoButton);
            }
            if (checkmplayer.exists()&&!checktrack.exists())
            {
                //Track missing
                int choice=QMessageBox::warning(0,i18n("Player error"),i18n("The selected track is missing"),QMessageBox::Ok,QMessageBox::Cancel,QMessageBox::NoButton);
                if(choice==1)
                    status=-1;
            }
            if (!checkmplayer.exists()&&checktrack.exists())
            {
                //Player missing
                QMessageBox::warning(0,i18n("Player error"),i18n("Mplayer-Executable is missing"),QMessageBox::Ok,QMessageBox::NoButton,QMessageBox::NoButton);
            }
        }
    }
    else
    {
                QMessageBox::critical(0,i18n("Player error"),i18n("You did not select the mplayer-executable!"),QMessageBox::Ok,QMessageBox::NoButton,QMessageBox::NoButton);
    }
    return status;
}

void mplayerinterface::seekforward(int offset)
{
    while(offset>0)
    {
        char command[]="\E[C";
        //jump 10 seconds per send
        playerProcess->writeStdin(command,sizeof(command));
        //this is needed, otherwise, our commandos will not be sent
        kapp->processEvents();
        offset-=10;
    }
}

void mplayerinterface::seekbackward(int offset)
{
    while(offset<0)
    {
        char command[]="\E[D";
        //jump 10 seconds per send
        playerProcess->writeStdin(command,sizeof(command));
        //this is needed, otherwise, our commandos will not be sent
        kapp->processEvents();
        offset+=10;
    }
}

void mplayerinterface::getstatus(KProcess *,char * data,int)
{
    //search in the data from mplayer for the time
    QString buffer=data;
    bool ok;
    if (buffer.contains("%"))
    {
        buffer=buffer.remove(0,buffer.find(":")+1);
        while(buffer.startsWith(" "))
            buffer=buffer.remove(0,1);
        QString currentvalue=buffer.left(buffer.find("("));
        actualtime=(int) currentvalue.toDouble(&ok);
        if (actualtime)
            emit songtime(actualtime);
        if (maxtime==0)
        {
            buffer=buffer.remove(0,buffer.find("of")+3);
            QString songmax=buffer.left(buffer.find("("));
            maxtime=(int) songmax.toDouble(&ok);
            //send the songtime to the playerinterface
            emit songlength(maxtime);
        }
    }
}

void mplayerinterface::playerstopped(KProcess *runningproc)
{
    disconnect(playerProcess,SIGNAL(processExited(KProcess *)),this,SLOT(playerstopped(KProcess *)));
    disconnect(playerProcess,SIGNAL(receivedStdout (KProcess *,char *,int)),this,SLOT(getstatus(KProcess *,char *,int)));
    delete runningproc;
    playerProcess=new KProcess;
    isplaying=FALSE;
    emit playerstopped();
}
