/***************************************************************************
 *   Copyright (C) 2005 by Roland Weigert   *
 *   roweigert@t-online.de   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#ifndef _LIBID3TAG_INTERFACE_H_
#define _LIBID3TAG_INTERFACE_H_

#define ID3V1 1
#define ID3V2 2
#define FRONT_COVER 3

//QT-Libs used
#include <qstring.h>
#include <qpixmap.h>
#include <qfileinfo.h>
#include <qcstring.h>
#include <qbuffer.h>

//libid3tag-library
#include <id3/tag.h>

//own includes from kyamo
#include "mediatag.h"
#include "genrehelper.h"

//We need the Prototype of mediatag here, cause we need it for id3libfile
class mediatag;

//Prototype of ID3_Tag-class so we can use libid3tag
class ID3_Tag;

//Our motherclass for id3tags is the id3libfile

/*Class for handling libid3-related files
 *only constructor save and set functions are reachable from not members of the class
 *all the other stuff is handled by this 3 functions
 *also the tags themself are reachable from outside
 *so the class is easy to handle from outside*/
class id3libfile
{
public:
  id3libfile(QString);
  ~id3libfile()
  {};
  bool saveFile(int);
  void readTags();
  void readPicture();
  void setTags(mediatag);
  bool containsV1Tag;
  bool containsV2Tag;
  bool readsuccess;
  mediatag v1tag;
  mediatag v2tag;
private:
  ID3_Tag workingfile;
  QString filename;
  //helperfunctions needed top get libid3tag running
  QString stripText(ID3_Tag,ID3_FrameID);
  QPixmap stripPicture(ID3_Tag);
  void removePicture(ID3_Tag *);
  void setPicture(ID3_Tag *,QPixmap);
  void putText(ID3_Tag *,ID3_FrameID,QString);
  void setTagContentv1(ID3_Tag *,mediatag *);
  void setTagContentv2(ID3_Tag *,mediatag *);
  void getTagContent(ID3_Tag,mediatag*);
};

#endif //_LIBID3TAG_INTERFACE_H_
