/***************************************************************************
 *   Copyright (C) 2005 by Roland Weigert   *
 *   roweigert@t-online.de   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#include "gogo-encoder.h"

gogoengine::gogoengine(QString source,QString destination,mediatag Song,progressmainwindow *progresswindow)
{
    //split up the options into a stringlist
    QStringList optionslist;
    QString buffer=settingsfile.gogooptions;
    buffer=buffer.remove(' ');
    while(!buffer.isEmpty())
    {
        if (buffer.startsWith("-"))
        {
            //this is the right thing, so we can copy all up to the next - or till the end into the stringlist
            QString newparameter;
            if (buffer.contains('-')>1)
            {
                int position=buffer.find('-',1);
                newparameter=buffer.left(position);
                buffer=buffer.remove(newparameter);
            }
            else
            {
                newparameter=buffer;
                buffer=QString::null;
            }
            optionslist.append(newparameter);
        }
        else
        {
            //try to find a -, and set complete buffer to null
            if (!buffer.contains('-'))
                buffer=QString::null;
            else
            {
                int position=buffer.find('-');
                buffer=buffer.right(buffer.length()-(position+1));
            }
        }
    }
    Songtags=Song;
    wavfile=source;
    mp3file=destination;
    KProcess *gogoProcess=new KProcess;
    progress=progresswindow->startProgress(QString(i18n("encoding track %1 with gogo")).arg(QString::number(Song.number)),100,gogoProcess);
    progresswindow->show();
    *gogoProcess<<settingsfile.gogoexe;
    QStringList::Iterator parameters=optionslist.begin();
    while(parameters!=optionslist.end())
    {
        *gogoProcess<<*parameters;
        parameters++;
    }
    if (settingsfile.gogobitrate)
        *gogoProcess<<"-b"<<QString(QString::number(settingsfile.gogobitrate))<<source<<destination;
    else
        *gogoProcess<<"--vbr-new"<<source<<destination;
    connect(gogoProcess,SIGNAL(receivedStderr(KProcess *,char *,int)),SLOT(readprogressinfo(KProcess *,char *,int)));
    connect(gogoProcess,SIGNAL(processExited(KProcess *)),SLOT(finishedProcess(KProcess *)));
    connect(this,SIGNAL(killProgress(progresswithbar *)),progresswindow,SLOT(killProgress(progresswithbar *)));
    gogoProcess->start(KProcess::RunMode(1),KProcess::Communication(6));
}

void gogoengine::readprogressinfo(KProcess  *proc,char *text,int length)
{
    QString buffer=text;
    int percent=0;
    while (buffer.contains('%'))
    {
        QString line=buffer.left(buffer.find('%'));
        buffer=buffer.remove(0,buffer.find('%')+1);
        line=line.remove(0,line.find('(')+1);
        percent=line.toInt();
    }
    progress->setProgress(percent);
}

void gogoengine::finishedProcess(KProcess *proc)
{
    disconnect(proc,SIGNAL(receivedStderr(KProcess *,char *,int)),this,SLOT(readprogressinfo(KProcess *,char *,int)));
    disconnect(proc,SIGNAL(processExited(KProcess *)),this,SLOT(finishedProcess(KProcess *)));
    emit killProgress(progress);
    QFile wav(wavfile);
    wav.remove();
    mediafile file(mp3file);
    if (file.readsuccess)
    {
        file.setTags(Songtags);
        file.saveFile();
    }
}

