/***************************************************************************
 *   Copyright (C) 2005 by Roland Weigert   *
 *   roweigert@t-online.de   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#ifndef _FILTERGENERATOR_H_
#define _FILTERGENERATOR_H_

#include <qdialog.h>
#include <qmessagebox.h>
#include <qstring.h>
#include <qlabel.h>
#include <qpushbutton.h>
#include <qlineedit.h>
#include <qlayout.h>
#include <qgroupbox.h>
#include <qimage.h>
#include <qiconset.h>

#include <kapp.h>
#include <klocale.h>
#include <kiconloader.h>

using namespace std;

#include <iostream>

class filtergenerator : public QDialog
{
    Q_OBJECT
public:
    filtergenerator(QString);
    ~filtergenerator();
    int ready;
    QString filter;
private:
    void    closeEvent(QCloseEvent *);
    void redrawfilter();
    bool setselected(int);
    QString matchfile;
    QString errordisplay;
    int *alreadyselected;
    QLineEdit *fileline;
    QLabel *filterline;
    QPushButton *okbutton;
    QPushButton *restorebutton;
    QPushButton *Cancelbutton;
    QGroupBox *filtersbox;
    QGroupBox *filterbuttonsbox;
    QGroupBox *userbuttons;
    QBoxLayout *mainlayout;
    QPushButton *formatbutton;
    QPushButton *yearbutton;
    QPushButton *artistbutton;
    QPushButton *songbutton;
    QPushButton *trackbutton;
    QPushButton *albumbutton;
    QPushButton *genrebutton;
    QImage okpic;
    QImage Cancelpic;
    QImage restorepic;
public slots:
    void yearslot();
    void formatslot();
    void artistslot();
    void songslot();
    void trackslot();
    void albumslot();
    void genreslot();
    void okslot();
    void Cancelslot();
    void restoreslot();
};

#endif //_FILTERGENERATOR_H_
