/***************************************************************************
 *   Copyright (C) 2005 by Roland Weigert   *
 *   roweigert@t-online.de   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

using namespace std;
#include <iostream>

#include "databasewrapper.h"

#define MYSQL 1
#define POSTGRESQL 2
#define SQLLITE 3


extern rcdatei settingsfile;

databasewrapper::databasewrapper()
{
    mysqldatabaseconnect=NULL;
    switch (settingsfile.databasetype)
    {
    case(MYSQL):
        {
            mysqldatabaseconnect=new mysqldatabase();
            if(mysqldatabaseconnect->quit)
            {
                quit=TRUE;
            }
            else
                quit=FALSE;
            break;
        }
    case (POSTGRESQL):
        {}
    case (SQLLITE):
        {}
    }
}

databasewrapper::~ databasewrapper()
{
    cerr<<"databasewrapper destructor"<<endl;
    if (mysqldatabaseconnect)
    {
        delete mysqldatabaseconnect;
    }
}

void databasewrapper::fillCombo(QComboBox *combobox,QString tablename,QString sortcriteria)
{
    switch (settingsfile.databasetype)
    {
    case (MYSQL):
        {
            mysqldatabaseconnect->fillCombo(combobox,tablename,sortcriteria);
            break;
        }
    case (POSTGRESQL):
        {}
    case (SQLLITE):
        {}
    }
}

void databasewrapper::fillSortedCombo(QComboBox *combobox,QString tablename,QString sqlquery,QString criteria)
{
    switch(settingsfile.databasetype)
    {
    case (MYSQL):
        {
            mysqldatabaseconnect->fillSortedCombo(combobox,tablename,sqlquery,criteria);
            break;
        }
    case (POSTGRESQL):
        {}
    case(SQLLITE):
        {}
    }
}

void databasewrapper::fillSortedCombo(QComboBox *combobox,QString tablename,QString sqlquery,QString criteria,QString realtable)
{
    switch (settingsfile.databasetype)
    {
    case (MYSQL):
        {
            mysqldatabaseconnect->fillSortedCombo(combobox,tablename,sqlquery,criteria,realtable);
            break;
        }
    case (POSTGRESQL):
        {}
    case (SQLLITE):
        {}
    }
}

bool databasewrapper::albumexists(long artistid,long albumid,QStringList *songlist)
{
    bool result=FALSE;
    switch (settingsfile.databasetype)
    {
    case (MYSQL):
        {
            result=mysqldatabaseconnect->albumexists(artistid,albumid,songlist);
            break;
        }
    case (POSTGRESQL):
        {}
    case (SQLLITE):
        {}
    }
    return result;
}

bool databasewrapper::checkdiscid(QString discid,QComboBox *artistbox,QComboBox *albumbox)
{
    bool result=FALSE;
    switch (settingsfile.databasetype)
    {
    case (MYSQL):
        {
            result=mysqldatabaseconnect->checkdiscid(discid,artistbox,albumbox);
            break;
        }
    case (POSTGRESQL):
        {}
    case (SQLLITE):
        {}
    }
    return result;
}

QString databasewrapper::translateartist(long artistindex)
{
    QString result;
    switch (settingsfile.databasetype)
    {
    case (MYSQL):
        {
            result=mysqldatabaseconnect->translateartist(artistindex);
            break;
        }
    case (POSTGRESQL):
        {}
    case (SQLLITE):
        {}
    }
    return result;
}

QString databasewrapper::translatealbum(long albumindex)
{
    QString result;
    switch (settingsfile.databasetype)
    {
    case (MYSQL):
        {
            result=mysqldatabaseconnect->translatealbum(albumindex);
            break;
        }
    case (POSTGRESQL):
        {}
    case (SQLLITE):
        {}
    }
    return result;
}

QString databasewrapper::translategenre(long genreindex)
{
    QString result;
    switch (settingsfile.databasetype)
    {
    case (MYSQL):
        {
            result=mysqldatabaseconnect->translategenre(genreindex);
            break;
        }
    case (POSTGRESQL):
        {}
    case (SQLLITE):
        {}
    }
    return result;
}

long databasewrapper::translateartist(QString artistname)
{
    long result=0;
    switch (settingsfile.databasetype)
    {
    case (MYSQL):
        {
            result=mysqldatabaseconnect->translateartist(artistname);
            break;
        }
    case (POSTGRESQL):
        {}
    case (SQLLITE):
        {}
    }
    return result;
}

long databasewrapper::translatealbum(QString album)
{
    long result=0;
    switch (settingsfile.databasetype)
    {
    case (MYSQL):
        {
            result=mysqldatabaseconnect->translatealbum(album);
            break;
        }
    case (POSTGRESQL):
        {}
    case (SQLLITE):
        {}
    }
    return result;
}

long databasewrapper::translategenre(QString genre)
{
    long result=0;
    switch (settingsfile.databasetype)
    {
    case (MYSQL):
        {
            result=mysqldatabaseconnect->translategenre(genre);
            break;
        }
    case (POSTGRESQL):
        {}
    case (SQLLITE):
        {}
    }
    return result;
}

long databasewrapper::getyear(long albumindex)
{
    long result=0;
    switch (settingsfile.databasetype)
    {
    case (MYSQL):
        {
            result=mysqldatabaseconnect->getyear(albumindex);
            break;
        }
    case (POSTGRESQL):
        {}
    case (SQLLITE):
        {}
    }
    return result;
}

void databasewrapper::gettrack(QComboBox *trackbox,long artistid,long albumid,int tracknumber)
{
    switch (settingsfile.databasetype)
    {
    case (MYSQL):
        {
            mysqldatabaseconnect->gettrack(trackbox,artistid,albumid,tracknumber);
            break;
        }
    case (POSTGRESQL):
        {}
    case (SQLLITE):
        {}
    }
}

void databasewrapper::writetag(mediatag *Song)
{
    switch (settingsfile.databasetype)
    {
    case (MYSQL):
        {
            mysqldatabaseconnect->writetag(Song);
            break;
        }
    case (POSTGRESQL):
        {}
    case (SQLLITE):
        {}
    }
}

bool databasewrapper::checkModified(QString filetocheck)
{
    bool result=FALSE;
    switch (settingsfile.databasetype)
    {
    case (MYSQL):
        {
            result=mysqldatabaseconnect->checkModified(filetocheck);
            break;
        }
    case (POSTGRESQL):
        {}
    case (SQLLITE):
        {}
    }
    return result;
}

void databasewrapper::writetag(mediatag *Song,QString actualfile)
{
    switch (settingsfile.databasetype)
    {
    case (MYSQL):
        {
            mysqldatabaseconnect->writetag(Song,actualfile);
            break;
        }
    case (POSTGRESQL):
        {}
    case (SQLLITE):
        {}
    }
}

void databasewrapper::updatetag(mediatag *Song,QString actualfile)
{
    switch (settingsfile.databasetype)
    {
    case (MYSQL):
        {
            mysqldatabaseconnect->updatetag(Song,actualfile);
            break;
        }
    case (POSTGRESQL):
        {}
    case (SQLLITE):
        {}
    }
}

void databasewrapper::writealbum(QString discid,QString discartist,QString discalbum,QString discgenre,long discyear,QStringList *tracklist)
{
    switch (settingsfile.databasetype)
    {
    case (MYSQL):
        {
            mysqldatabaseconnect->writealbum(discid,discartist,discalbum,discgenre,discyear,tracklist);
            break;
        }
    case (POSTGRESQL):
        {}
    case (SQLLITE):
        {}
    }
}

void databasewrapper::writealbum(musicbrainzalbum *currentalbum)
{
//Bring the album we got from musicbrainz in a format the database knows, and send it to the right engine
QStringList songlist;
QPtrList<musicbrainztrack>::Iterator trackiterator=currentalbum->tracklist.begin();
while (trackiterator!=currentalbum->tracklist.end())
{
songlist.append((*trackiterator)->trackname);
trackiterator++;
}
    switch (settingsfile.databasetype)
    {
    case (MYSQL):
        {
             mysqldatabaseconnect->writealbum(QString::null,currentalbum->artistname,currentalbum->albumname,QString::null,currentalbum->releasedate,&songlist);
            break;
        }
    case (POSTGRESQL):
        {}
    case (SQLLITE):
        {}
    }
}

void databasewrapper::removefile(QString filetoremove)
{
    switch (settingsfile.databasetype)
    {
    case (MYSQL):
        {
            mysqldatabaseconnect->removefile(filetoremove);
            break;
        }
    case (POSTGRESQL):
        {}
    case (SQLLITE):
        {}
    }
}
