/***************************************************************************
 *   Copyright (C) 2003 by Stephen Allewell                                *
 *   stephen@mirramar.fsnet.co.uk                                          *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 ***************************************************************************/

#include <qpainter.h>
#include <qimage.h>
#include <kprinter.h>
#include <kdebug.h>
#include "preview.h"
#include "kxstitchview.h"
#include "kxstitchdoc.h"

PreView::PreView(KXStitchDoc* doc, QWidget* parent)
  : QScrollView(parent),
    m_doc(doc)
{
  setVScrollBarMode(AlwaysOff);
  setHScrollBarMode(AlwaysOff);
  resizeContents(0,0);
  setBackgroundMode(PaletteBackground);
}

int PreView::print(KPrinter *printer, QPainter *painter, int width, int height, int pages)
{
  /** TODO
      contents of header and footer should be user defined
      fonts should be user defined
      layout should be user defined
      all options to be stored in the document to allow per document settings.
    */
  // print header
  //  title
  //  Created by
  //  author
  QFont f = painter->font();
  QString title = m_doc->title();
  QString author = m_doc->author();
  QString copyright = m_doc->copyright();
  int y = 0; // top of page
  // print the title if there is one
  if (!title.isEmpty())
  {
    QFont titleFont = f;
    titleFont.setPointSize(titleFont.pointSize()*2);
    titleFont.setBold(true);
    painter->setFont(titleFont);
    int dy = painter->fontMetrics().lineSpacing();
    painter->drawText(0,y,width,dy,Qt::AlignHCenter,title);
    y += dy;
    painter->setFont(f);
  }
  // print the creaters name if there is one
  if (!author.isEmpty())
  {
    int dy = painter->fontMetrics().lineSpacing();
    painter->drawText(0,y,width,dy,Qt::AlignHCenter,"Created by");
    y += dy;
    painter->drawText(0,y,width,dy,Qt::AlignHCenter,author);
  }
  // print the preview in the centre of the page
  QPixmap* pixmap = m_doc->m_preview;
  QImage image(pixmap->convertToImage());
  image = image.smoothScale(width/2,height/2,QImage::ScaleMin);
  QPoint imageOrigin = QPoint(width/2,height/2)-QPoint(image.width()/2,image.height()/2);
  painter->drawImage(imageOrigin,image);
  // draw a border around the image
  painter->drawRect(QRect(imageOrigin-QPoint(10,10),image.size()+QSize(20,20)));
  // print footer
  //  copyright symbol and message
  if (!copyright.isEmpty())
  {
    int dy = painter->fontMetrics().lineSpacing();
    painter->drawText(0,height-dy,width,dy,Qt::AlignHCenter,QString("%1 %2").arg(QChar(169)).arg(m_doc->copyright()));
  }
  return ++pages;
}

void PreView::setVisibleCells(QRect cells)
{
  m_visible = cells;
  viewport()->repaint(false);
}

void PreView::contentsMousePressEvent(QMouseEvent* e)
{
  m_point = e->pos();
  m_moved = false;
  setCursor(sizeAllCursor);
}

void PreView::contentsMouseMoveEvent(QMouseEvent* e)
{
  QPoint p = e->pos();
  m_moved = true;
  if (p != m_point)
  {
    int dx = m_point.x()-p.x();
    int dy = m_point.y()-p.y();
    scrollBy(dx,dy);
  }
}

void PreView::contentsMouseReleaseEvent(QMouseEvent*)
{
  setCursor(arrowCursor);
  if (!m_moved)
    emit clicked(QPoint(m_point.x()/2,m_point.y()/2)); // stitch coordinate
}

void PreView::drawContents(QPainter* p, int, int, int, int)
{
  QPixmap* pixmap = m_doc->m_preview;
  resizeContents(pixmap->width(), pixmap->height());
  p->drawPixmap(QPoint(0,0),*pixmap);
  if (m_visible.width() < pixmap->width() || m_visible.height() < pixmap->height())
    p->drawRect(m_visible.left()*2, m_visible.top()*2, m_visible.width()*2, m_visible.height()*2);
}
