/***************************************************************************
                           kxetreeviewsettings.cpp
                           -----------------------
    begin                : Tue Dec 02 2003
    copyright            : (C) 2003 by The KXMLEditor Team
    email                : hartig@users.sourceforge.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "kxetreeviewsettings.h"
#include "kxetreeviewsettingspage.h"

#include <klocale.h>
#include <kconfig.h>
#include <kdebug.h>

#include <qframe.h>
#include <qcheckbox.h>
#include <qspinbox.h>
#include <qbuttongroup.h>
#include <qradiobutton.h>

#define CONF_ENTRY_NAME_ITEMS_ON_DEMAND "Create items on demand"
#define DFLT_VALUE_ITEMS_ON_DEMAND true

#define CONF_ENTRY_NAME_DFLT_EXP_LEVEL "Expand to level"
#define DFLT_VALUE_DFLT_EXP_LEVEL 5

#define CONF_ENTRY_NAME_DECORATE_ROOT "Root decorated"
#define DFLT_VALUE_DECORATE_ROOT false

#define CONF_ENTRY_NAME_ENABLE_DRAG "Enable Dragging"
#define DFLT_VALUE_ENABLE_DRAG true

#define CONF_ENTRY_NAME_ENABLE_DROP "Enable Dropping"
#define DFLT_VALUE_ENABLE_DROP true

#define CONF_ENTRY_NAME_ELEM_DISPL_MODE "Element display mode"
#define DFLT_VALUE_ELEM_DISPL_MODE NoAttributes


KXETreeViewSettings::KXETreeViewSettings( QObject * pParent, const char * pszName )
 : KXESettings( "Tree View", pParent, pszName ),
   m_bCreateItemsOnDemand( DFLT_VALUE_ITEMS_ON_DEMAND ),
   m_iDfltExpLevel( DFLT_VALUE_DFLT_EXP_LEVEL ),
   m_bDecorateRoot( DFLT_VALUE_DECORATE_ROOT ),
   m_bEnableDragging( DFLT_VALUE_ENABLE_DRAG ),
   m_bEnableDropping( DFLT_VALUE_ENABLE_DROP ),
   m_enmElemDisplMode( DFLT_VALUE_ELEM_DISPL_MODE ),
   m_pDialogPage(0)
{
}

void KXETreeViewSettings::write( KConfig * pConfig ) const
{
	pConfig->writeEntry( CONF_ENTRY_NAME_ITEMS_ON_DEMAND, m_bCreateItemsOnDemand );
	pConfig->writeEntry( CONF_ENTRY_NAME_DFLT_EXP_LEVEL, m_iDfltExpLevel );
	pConfig->writeEntry( CONF_ENTRY_NAME_DECORATE_ROOT, m_bDecorateRoot );
	pConfig->writeEntry( CONF_ENTRY_NAME_ENABLE_DRAG, m_bEnableDragging );
	pConfig->writeEntry( CONF_ENTRY_NAME_ENABLE_DROP, m_bEnableDropping );
	pConfig->writeEntry( CONF_ENTRY_NAME_ELEM_DISPL_MODE, m_enmElemDisplMode );
}

void KXETreeViewSettings::read( const KConfig * pConfig )
{
	m_bCreateItemsOnDemand = pConfig->readBoolEntry( CONF_ENTRY_NAME_ITEMS_ON_DEMAND, DFLT_VALUE_ITEMS_ON_DEMAND );
	m_iDfltExpLevel = pConfig->readNumEntry( CONF_ENTRY_NAME_DFLT_EXP_LEVEL, DFLT_VALUE_DFLT_EXP_LEVEL );
	m_bDecorateRoot = pConfig->readBoolEntry( CONF_ENTRY_NAME_DECORATE_ROOT, DFLT_VALUE_DECORATE_ROOT );
	m_bEnableDragging = pConfig->readBoolEntry( CONF_ENTRY_NAME_ENABLE_DRAG, DFLT_VALUE_ENABLE_DRAG );
	m_bEnableDropping = pConfig->readBoolEntry( CONF_ENTRY_NAME_ENABLE_DROP, DFLT_VALUE_ENABLE_DROP );
	m_enmElemDisplMode = static_cast<AttributeVisibility> ( pConfig->readNumEntry( CONF_ENTRY_NAME_ELEM_DISPL_MODE, DFLT_VALUE_ELEM_DISPL_MODE ) );
}

QString KXETreeViewSettings::dialogPageName() const
{
	return i18n( "Tree View" );
}

QString KXETreeViewSettings::dialogPageHeader() const
{
	return i18n( "Tree view properties" );
}

QString KXETreeViewSettings::dialogPageIcon() const
{
	return "view_tree";
}


QWidget * KXETreeViewSettings::dialogPage( QFrame * pParent )
{
	if ( ! m_pDialogPage )
	{
		// create the page if necessary
		m_pDialogPage = new KXETreeViewSettingsPage( pParent, "tree view config.dialog page" );

		// and fill its widgets with the corresponding values
		updatePage();

		connect( m_pDialogPage->m_pCreateItemsOnDemand, SIGNAL(toggled(bool)), this, SIGNAL(sigDialogPageChanged()) );
		connect( m_pDialogPage->m_pDecorateRoot, SIGNAL(toggled(bool)), this, SIGNAL(sigDialogPageChanged()) );
		connect( m_pDialogPage->m_pDfltExpLevel, SIGNAL(valueChanged(int)), this, SIGNAL(sigDialogPageChanged()) );
		connect( m_pDialogPage->m_pEnableDrag, SIGNAL(toggled(bool)), this, SIGNAL(sigDialogPageChanged()) );
		connect( m_pDialogPage->m_pEnableDrop, SIGNAL(toggled(bool)), this, SIGNAL(sigDialogPageChanged()) );
		connect( m_pDialogPage->m_pElemDisplMode1, SIGNAL(toggled(bool)), this, SIGNAL(sigDialogPageChanged()) );
		connect( m_pDialogPage->m_pElemDisplMode2, SIGNAL(toggled(bool)), this, SIGNAL(sigDialogPageChanged()) );
		connect( m_pDialogPage->m_pElemDisplMode3, SIGNAL(toggled(bool)), this, SIGNAL(sigDialogPageChanged()) );
	}

	return m_pDialogPage;
}


void KXETreeViewSettings::setFromPage()
{
	if ( m_pDialogPage )
	{
		m_bCreateItemsOnDemand = m_pDialogPage->m_pCreateItemsOnDemand->isChecked();
		m_bDecorateRoot = m_pDialogPage->m_pDecorateRoot->isChecked();
		m_iDfltExpLevel = m_pDialogPage->m_pDfltExpLevel->value();
		m_bEnableDragging = m_pDialogPage->m_pEnableDrag->isChecked();
		m_bEnableDropping = m_pDialogPage->m_pEnableDrop->isChecked();

		if ( m_pDialogPage->m_pElemDisplMode1->isChecked() )
			m_enmElemDisplMode = NoAttributes;
		else if ( m_pDialogPage->m_pElemDisplMode2->isChecked() )
			m_enmElemDisplMode = NamesOnly;
		else if ( m_pDialogPage->m_pElemDisplMode3->isChecked() )
			m_enmElemDisplMode = NamesAndValues;
	}
}

void KXETreeViewSettings::updatePage() const
{
	if ( m_pDialogPage )
	{
		m_pDialogPage->m_pCreateItemsOnDemand->setChecked( m_bCreateItemsOnDemand );
		m_pDialogPage->m_pDecorateRoot->setChecked( m_bDecorateRoot );
		m_pDialogPage->m_pDfltExpLevel->setValue( m_iDfltExpLevel );
		m_pDialogPage->m_pEnableDrag->setChecked( m_bEnableDragging );
		m_pDialogPage->m_pEnableDrop->setChecked( m_bEnableDropping );

		switch ( m_enmElemDisplMode )
		{
			case NoAttributes:
				m_pDialogPage->m_pElemDisplMode->setButton( m_pDialogPage->m_pElemDisplMode->id( m_pDialogPage->m_pElemDisplMode1 ) );
				break;
			case NamesOnly:
				m_pDialogPage->m_pElemDisplMode->setButton( m_pDialogPage->m_pElemDisplMode->id( m_pDialogPage->m_pElemDisplMode2 ) );
				break;
			case NamesAndValues:
				m_pDialogPage->m_pElemDisplMode->setButton( m_pDialogPage->m_pElemDisplMode->id( m_pDialogPage->m_pElemDisplMode3 ) );
				break;
			default:
				kdError() << "KXETreeViewSettings::updatePage: unknown element display mode" << endl;
		}
	}
}
