/***************************************************************************
                          commands_insert  -  description
                             -------------------
    begin                : Wed Nov 26 2003
    copyright            : (C) 2003 by The KXMLEditor Team
    email                : lvanek.sourceforge.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
#ifndef COMMANDS_INSERT_H
#define COMMANDS_INSERT_H

#include <klocale.h>

#include "kxecommand.h"
#include "kxechardatadialog.h"

/**
@author The KXMLEditor Team
*/
class KXEElementCommand : public KXECommand
{
	public:
		KXEElementCommand(KXEDocument*, QDomDocument *, QString, QString, QString);
		KXEElementCommand(KXEDocument*, QDomElement &, QString, QString, QString, bool);
		~KXEElementCommand();
		virtual void execute();
		virtual void unexecute();
		virtual QString name() const { return i18n("Insert element"); }

	protected:
		QDomDocument * m_pDomDoc;
		QDomElement m_domParentElement;
		bool m_bAtTop;
		QDomElement m_domElement;
};

class KXEAttributeCommand : public KXECommand
{
	public:
		KXEAttributeCommand(KXEDocument*, QDomElement &, QString, QString, QString);
		~KXEAttributeCommand();
		virtual void execute();
		virtual void unexecute();
		virtual QString name() const { return i18n("Insert attribute"); }

	protected:
		QString m_strNamespace;
		QString m_strQName;
		QString m_strValue;
		QDomElement m_domOwnerElement;
};

class KXECharDataCommand : public KXECommand
{
	public:
		KXECharDataCommand(KXEDocument*, QDomElement &, bool, CharDataKind, QString);
		~KXECharDataCommand();
		virtual void execute();
		virtual void unexecute();
		virtual QString name() const { return i18n("Insert char data"); }

	protected:

		bool m_bAtTop;
		QDomElement m_domParentElement;
		QDomCharacterData m_domCharData;
};

class KXEProcInstrCommand : public KXECommand
{
	public:
		KXEProcInstrCommand(KXEDocument*, QDomDocument *, bool, QString, QString);
		KXEProcInstrCommand(KXEDocument*, QDomElement &, bool, QString, QString);
		~KXEProcInstrCommand();
		virtual void execute();
		virtual void unexecute();
		virtual QString name() const { return i18n("Insert proc. instr."); }

	protected:
		QDomDocument * m_pDomDoc;
		QDomElement m_domParentElement;
		bool m_bAtTop;
		QDomProcessingInstruction m_domProcInstr;
};

#endif
