//
// C++ Interface: kxeshellmanager
//
// Description: 
//
//
// Author: Adam Charytoniuk <achary@poczta.onet.pl>, (C) 2004
//
// Copyright: See COPYING file that comes with this distribution
//
//
#ifndef KXESHELLMANAGER_H
#define KXESHELLMANAGER_H
/**
@file
*/

#include <qptrlist.h>

class KXMLEditorShell;

/**
@short Available shell list

Stores and dispatches informations about all KXMLEditorShell windows currently opened.
Only one instance of this class is created. Eeach shell adds itself into this manager.

@sa KXMLEditorShell

@author Adam Charytoniuk
*/
class KXEShellManager{
public:
	/** @short Constructor */
	KXEShellManager();

	/** @short Destructor */
	~KXEShellManager();

	/** @short Adds given part to the manager.

	All opened Shells will be informed about that event by KXMLEditorShell::slotShellAdded()
	method. In addition, newly added shell will be informed about presence of each of all existing
	shells with the same method.
		@param pShell newly added shell
	 */
	void addShell(KXMLEditorShell* pShell);

	/** @short Removes given part from manager.

	All opened Shells will be informed about that event by KXMLEditorShell::slotShellRemoved()
	method.
		@param pShell to be removed (closed)
	*/
	void removeShell(KXMLEditorShell* pShell);

	/** @short Returns list of currently opened shells. */
	QPtrList<KXMLEditorShell> *shells();
	
private:
	/** @short Internally stores list of available shells. */
	QPtrList<KXMLEditorShell> m_shells;
};

#endif
