/***************************************************************************
                          kxechardatadialog.h  -  description
                          -------------------
    begin                : Don Apr 25 2002
    copyright            : (C) 2002, 2003 by The KXMLEditor Team
    email                : lvanek@users.sourceforge.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef KXECHARDATADIALOG_H
#define KXECHARDATADIALOG_H

#include "kxechardatadialogbase.h"

enum CharDataKind
	{
		CharDataTextNode = 0,
		CharDataCDATASection,
		CharDataComment
	};

class KXECharDataDialog : public KXECharDataDialogBase
{
		Q_OBJECT

	public:
		KXECharDataDialog( QWidget * pParent = 0, const char * pszName = 0, bool fModal = true, WFlags fl = 0 );

//    const CharDataKind charDataKind() const { return m_eCharDataKind; }
    const bool atTop() const { return m_bAtTop; }
    const QString contents() const { return m_strContents; }

    void setContents(const QString strContents) { m_strContents = strContents; }
//    void setCharDataKind(const CharDataKind eCharDataKind) { m_eCharDataKind = eCharDataKind; }
      
	public:
		
		/**
		 * To be used for inserting the given XML character data as child
		 * of the given parent element.
		 *
		 * @return see @ref QDialog::exec
		 */
		int exec( bool );
		
		/**
		 * Clears the dialogs widgets.
		 */
		void clearDialog();

    // check contents
    static QString checkContents(const QString);
		
	protected:
		/**
		 * Don't use this function directly, it's for internal use only.
		 * Use one of the other @ref DlgXMLCharData::exec functions instead.
		 */
		int exec();

  protected slots:
		/**
		 * Called, when the data in the text edit @ref DlgXMLCharDataBase::m_pEditData
		 * is changed.
		 * Disables the OK button, if the given string is empty.
		 */
		void slotDataChanged();

    protected:
      //CharDataKind m_eCharDataKind;
      bool m_bAtTop;
      QString m_strContents;
};

#endif
