/***************************************************************************
                          kxe_viewelement.cpp  -  description
                             -------------------
    begin                : Mon Oct 15 2001
    copyright            : (C) 2001, 2002, 2003 by The KXMLEditor Team
    email                : lvanek@users.sourceforge.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "kxe_viewelement.h"
#include "kxe_viewattributes.h"
#include "kxesyntaxhighlighter.h"

#include "kxmleditorfactory.h"
#include "kxeconfiguration.h"
#include "kxetextviewsettings.h"

#include <kconfig.h>

#include <qmultilineedit.h>
#include <qdom.h>
#include <qcolor.h>

#include "qdom_add.h"

#define CONFIG_SPLITTER_SIZES "View Element splitter sizes"

KXE_ViewElement::KXE_ViewElement( QWidget * pParent, KConfig *pConfig, const char * pszName )
	: QSplitter( Qt::Vertical, pParent, pszName )
{
	setOpaqueResize(true);
	m_pConfig = pConfig;
	m_pViewAttributes = new KXE_ViewAttributes( this, "table of element attributes");
	connect( m_pViewAttributes, SIGNAL(sigContextMenuRequested(const QString&,const QPoint&)), this, SIGNAL(sigContextMenuRequested(const QString&,const QPoint&)) );

  connect( m_pViewAttributes, SIGNAL(sigAttributeNameChangedInplace(const QDomAttr&, const QString)), this, SIGNAL(sigAttributeNameChangedInplace(const QDomAttr&, const QString)) );
  connect( m_pViewAttributes, SIGNAL(sigAttributeValueChangedInplace(const QDomAttr&, const QString)), this, SIGNAL(sigAttributeValueChangedInplace(const QDomAttr&, const QString)) );

	m_pViewPlainXML = new QMultiLineEdit( this, "plain XML" );
	m_pViewPlainXML->setReadOnly(true);
  m_pViewPlainXML->setWordWrap( QTextEdit::NoWrap );
  m_pSyntaxHighlighter = new KXESyntaxHighlighter(m_pViewPlainXML);

  	// configuring spliiter sizes
	if (m_pConfig)
	{
		QValueList<int> list = m_pConfig->readIntListEntry(CONFIG_SPLITTER_SIZES);
		if (!list.isEmpty())
			setSizes(list);
        }

	// Apply current configuration
	slotTextViewSettingsChanged();
	// and make sure to be informed about its changes.
	connect( KXMLEditorFactory::configuration()->textview(), SIGNAL(sigChanged()), this, SLOT(slotTextViewSettingsChanged()) );
}

KXE_ViewElement::~KXE_ViewElement()
{
	// saving splitter sizes
	if (m_pConfig)
		m_pConfig->writeEntry( CONFIG_SPLITTER_SIZES, sizes() );

  delete m_pSyntaxHighlighter;
}

QDomAttr KXE_ViewElement::getSelectedAttribute() const
{
	return m_pViewAttributes->getSelectedAttribute();
}

void KXE_ViewElement::setReadWrite( bool fReadWrite )
{
	m_pViewAttributes->setReadWrite(fReadWrite);
}

void KXE_ViewElement::slotChange( const QDomElement & element )
{
	// change attribute view
	m_pViewAttributes->slotChange(element);

  int iIndent = KXMLEditorFactory::configuration()->textview()->indentSteps();

	// change plain XML view
	m_pViewPlainXML->setText( domTool_save(element, iIndent) );
}

//////////////////////////////////////////////////////////////
// configuration slots
//////////////////////////////////////////////////////////////

void KXE_ViewElement::slotTextViewSettingsChanged()
{
	m_pSyntaxHighlighter->setColorDefaultText( KXMLEditorFactory::configuration()->textview()->colorDfltText() );
	m_pSyntaxHighlighter->setColorElementNames( KXMLEditorFactory::configuration()->textview()->colorElemNames() );
	m_pSyntaxHighlighter->setColorAttributeNames( KXMLEditorFactory::configuration()->textview()->colorAttrNames() );
	m_pSyntaxHighlighter->setColorAttributeValues( KXMLEditorFactory::configuration()->textview()->colorAttrValues() );
	m_pSyntaxHighlighter->setColorXmlSyntaxChars( KXMLEditorFactory::configuration()->textview()->colorSyntaxChars() );
	m_pSyntaxHighlighter->setColorComments( KXMLEditorFactory::configuration()->textview()->colorComments() );
	m_pSyntaxHighlighter->setColorSyntaxError( KXMLEditorFactory::configuration()->textview()->colorErrors() );

	m_pSyntaxHighlighter->rehighlight();
}
