/***************************************************************************
 *   Copyright (C) 2006 by Tomasz Sałaciński   *
 *   distortion@vp.pl   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#define ERR "Error"

//QT Includes
#include <qfile.h>

//kX Generator Includes
#include "Xorg.h"



bool Xorg :: isKeyboard(QString Identifier)
{
for (int i = 1; i <= CountSections(InputDevice); i++)
 {
  if (GetValue(InputDevice, i, "Identifier", 1) == Identifier)
   {
    if (GetValue(InputDevice, i, "Driver", 1) == "kbd" || GetValue(InputDevice, i, "Driver", 1) == "keyboard")
     { return true; }
    else
     { return false; }
   }
 }
return false;
}

bool Xorg :: isKeyboard(int SectionNumber)
{

if (GetValue(InputDevice, SectionNumber, "Driver", 1) == "kbd" || GetValue(InputDevice, SectionNumber, "Driver", 1) == "keyboard")
  { return true; }
else
  { return false; }

}

bool Xorg :: isPointer (QString Identifier)
{


for (int i = 0; i <= CountSections(InputDevice); i++)
 {
  if (GetValue(InputDevice, i, "Identifier", 1) == Identifier)
   {

     QString v = GetValue(InputDevice, i, "Driver", 1);

    if (v == "acecad" ||
        v == "aiptek" ||
        v == "calcomp" ||
        v == "citron" ||
        v == "digitaledge" ||
        v == "dmc" ||
        v == "dynapro" ||
        v == "elo2300" ||
        v == "elographics" ||
        v == "evdev" ||
        v == "fpit" ||
        v == "hyperpen" ||
        v == "joystick" ||
        v == "js_x" ||
        v == "magellan" ||
        v == "magictouch" ||
        v == "microtouch" ||
        v == "mouse" ||
        v == "mutouch" ||
        v == "palmax" ||
        v == "penmount" ||
        v == "spaceorb" ||
        v == "summa" ||
        v == "synaptics" ||
        v == "ur98" ||
        v == "void" ||
        v == "wacom")
     { return true; }
    else
     { return false; }
   }
 }

return false;
}

bool Xorg :: isValuePresent(QString ValueName, QString Value)
{
   for (int a = 0; a <= CountSections(ServerLayout); a++)
    {
     if (GetValue(ServerLayout, a, ValueName, 1) == Value) { return true; }
    }

   for (int a = 0; a <= CountSections(InputDevice); a++)
    {
     if (GetValue(InputDevice, a, ValueName, 1) == Value) { return true; }
    }

   for (int a = 0; a <= CountSections(Device); a++)
    {
     if (GetValue(Device, a, ValueName, 1) == Value) { return true; }
    }

   for (int a = 0; a <= CountSections(Monitor); a++)
    {
     if (GetValue(Monitor, a, ValueName, 1) == Value) { return true; }
    }

   for (int a = 0; a <= CountSections(Screen); a++)
    {
     if (GetValue(Screen, a, ValueName, 1) == Value) { return true; }
    }


     if (GetValue(ServerFlags, 1, ValueName, 1) == Value) { return true; }
     if (GetValue(Files, 1, ValueName, 1) == Value) { return true; }
     if (GetValue(Modules, 1, ValueName, 1) == Value) { return true; }
     if (GetValue(Extensions, 1, ValueName, 1) == Value) { return true; }

return false;

}

bool Xorg :: GetBoolOption(Section SectionName, int SectionNumber, QString OptionName)
{
if (GetOption(SectionName, SectionNumber, OptionName).lower() == "true") { return true; }
if (GetOption(SectionName, SectionNumber, OptionName).lower() == "1") { return true; }
if (GetOption(SectionName, SectionNumber, OptionName).lower() == "on") { return true; }
if (GetOption(SectionName, SectionNumber, OptionName).lower() == "yes") { return true; }

if (GetOption(SectionName, SectionNumber, OptionName).lower() == "false") { return false; }
if (GetOption(SectionName, SectionNumber, OptionName).lower() == "0") { return false; }
if (GetOption(SectionName, SectionNumber, OptionName).lower() == "off") { return false; }
if (GetOption(SectionName, SectionNumber, OptionName).lower() == "no") { return false; }


return false;
}


QString Xorg :: GetProperty(Property Prop)
{
 if (Prop == PathToConfigFile) { return Properties[0]; }
 if (Prop == PathToVideoDrv) { return Properties[1]; }
 if (Prop == PathToInputDrv) { return Properties[2]; }
 if (Prop == PathToHw) { return Properties[3]; }

 return "Error";
}

QString Xorg :: GetSection(Section SectionName, int SectionNumber)
{
SectionNumber++;

if (SectionName == ServerLayout) 
     {
      return WholeFile.section("Section \"ServerLayout\"", SectionNumber, SectionNumber + 1).section("EndSection", 0, 0); 
     }

if (SectionName == ServerFlags) 
     {
      return WholeFile.section("Section \"ServerFlags\"", SectionNumber, SectionNumber + 1).section("EndSection", 0, 0); 
     }

if (SectionName == Files) 
     {
    return WholeFile.section("Section \"Files\"", SectionNumber, SectionNumber + 1).section("EndSection", 0, 0); 
     }

if (SectionName == Modules) 
     {
      return WholeFile.section("Section \"Module\"", SectionNumber, SectionNumber + 1).section("EndSection", 0, 0); 
     }

if (SectionName == Extensions) 
     {
      return WholeFile.section("Section \"Extensions\"", SectionNumber, SectionNumber + 1).section("EndSection", 0, 0); 
     }

if (SectionName == Extensions) 
     {
      return WholeFile.section("Section \"Extensions\"", SectionNumber, SectionNumber + 1).section("EndSection", 0, 0); 
     }

if (SectionName == InputDevice) 
     {
      return WholeFile.section("Section \"InputDevice\"", SectionNumber, SectionNumber + 1).section("EndSection", 0, 0); 
     }

if (SectionName == Device) 
     {
      return WholeFile.section("Section \"Device\"", SectionNumber, SectionNumber + 1).section("EndSection", 0, 0); 
     }

if (SectionName == Monitor) 
     {
      return WholeFile.section("Section \"Monitor\"", SectionNumber, SectionNumber + 1).section("EndSection", 0, 0); 
     }

if (SectionName == Screen) 
     {
      return WholeFile.section("Section \"Screen\"", SectionNumber, SectionNumber + 1).section("EndSection", 0, 0); 
     }

return "ERROR";
}

QString Xorg :: GetValue(Section SectionName, int SectionNumber, QString ValueName, int ValueNumber)
{

ValueName = ValueName.prepend("\n").append(" ");            //To make sure that commented # lines are omitted.

  if (SectionName == ServerLayout)
    {
      return ServerLayoutSection[SectionNumber].section(ValueName + "\"", ValueNumber, ValueNumber).section("\"", 0, 0);
    }

  if (SectionName == ServerFlags)
    {
      return ServerFlagsSection.section(ValueName + "\"", ValueNumber, ValueNumber).section("\"", 0, 0);
    }

  if (SectionName == Files)
    {
      return FilesSection.section(ValueName + "\"", ValueNumber, ValueNumber).section("\"", 0, 0);
    }

  if (SectionName == Modules)
    {
      return ModulesSection.section(ValueName + "\"", ValueNumber, ValueNumber).section("\"", 0, 0);
    }

  if (SectionName == Extensions)
    {
      return ExtensionsSection.section(ValueName + "\"", ValueNumber, ValueNumber).section("\"", 0, 0);
    }

  if (SectionName == InputDevice)
    {
      return InputDeviceSection[SectionNumber].section(ValueName + "\"", ValueNumber, ValueNumber).section("\"", 0, 0);
    }

  if (SectionName == Device)
    {
      return DeviceSection[SectionNumber].section(ValueName + "\"", ValueNumber, ValueNumber).section("\"", 0, 0);
    }

  if (SectionName == Monitor)
    {
      return MonitorSection[SectionNumber].section(ValueName + "\"", ValueNumber, ValueNumber).section("\"", 0, 0);
    }

  if (SectionName == Screen)
    {
      return ScreenSection[SectionNumber].section(ValueName + "\"", ValueNumber, ValueNumber).section("\"", 0, 0);
    }

return "ERROR";

}

QString Xorg :: GetLineBreakValue(Section SectionName, int SectionNumber, QString ValueName, int ValueNumber)
{
ValueName = ValueName.prepend("\n");            //To make sure that commented # lines are omitted.
  if (SectionName == ServerLayout)
    {
      return ServerLayoutSection[SectionNumber].section(ValueName + " ", ValueNumber, ValueNumber).section("\n", 0, 0);
    }

  if (SectionName == ServerFlags)
    {
      return ServerFlagsSection.section(ValueName + " ", ValueNumber, ValueNumber).section("\n", 0, 0);
    }

  if (SectionName == Files)
    {
      return FilesSection.section(ValueName + " ", ValueNumber, ValueNumber).section("\n", 0, 0);
    }

  if (SectionName == Modules)
    {
      return ModulesSection.section(ValueName + " ", ValueNumber, ValueNumber).section("\n", 0, 0);
    }

  if (SectionName == Extensions)
    {
      return ExtensionsSection.section(ValueName + " ", ValueNumber, ValueNumber).section("\n", 0, 0);
    }

  if (SectionName == InputDevice)
    {
      return InputDeviceSection[SectionNumber].section(ValueName + " ", ValueNumber, ValueNumber).section("\n", 0, 0);
    }

  if (SectionName == Device)
    {
      return DeviceSection[SectionNumber].section(ValueName + " ", ValueNumber, ValueNumber).section("\n", 0, 0);
    }

  if (SectionName == Monitor)
    {
      return MonitorSection[SectionNumber].section(ValueName + " ", ValueNumber, ValueNumber).section("\n", 0, 0);
    }

  if (SectionName == Screen)
    {
      return ScreenSection[SectionNumber].section(ValueName + " ", ValueNumber, ValueNumber).section("\n", 0, 0);
    }
return "ERROR";
}

QString Xorg :: GetOption(Section SectionName, int SectionNumber, QString ValueName)
{
return GetValue(SectionName, SectionNumber, "Option \"" + ValueName + "\"", 1);
}

QString Xorg :: LayoutTranslate(int ComboNumber)
{
if (ComboNumber == 1)       {   return "af"; }
if (ComboNumber == 2)       {   return "ar"; }
if (ComboNumber == 3)       {   return "bg"; }
if (ComboNumber == 4)       {   return "bo"; }
if (ComboNumber == 5)       {   return "br"; }
if (ComboNumber == 6)       {   return "ca"; }
if (ComboNumber == 7)       {   return "cs"; }
if (ComboNumber == 8)       {   return "cy"; }
if (ComboNumber == 9)       {   return "da"; }
if (ComboNumber == 10)      {   return "de"; }
if (ComboNumber == 11)      {   return "el"; }
if (ComboNumber == 12)      {   return "en_GB"; }
if (ComboNumber == 13)      {   return "en_US"; }
if (ComboNumber == 14)      {   return "eo"; }
if (ComboNumber == 15)      {   return "es"; }
if (ComboNumber == 16)      {   return "et"; }
if (ComboNumber == 17)      {   return "eu"; }
if (ComboNumber == 18)      {   return "fi"; }
if (ComboNumber == 19)      {   return "fr"; }
if (ComboNumber == 20)      {   return "ga"; }
if (ComboNumber == 21)      {   return "gl"; }
if (ComboNumber == 22)      {   return "gu"; }
if (ComboNumber == 23)      {   return "he"; }
if (ComboNumber == 24)      {   return "hi"; }
if (ComboNumber == 25)      {   return "hu"; }
if (ComboNumber == 26)      {   return "id"; }
if (ComboNumber == 27)      {   return "is"; }
if (ComboNumber == 28)      {   return "it"; }
if (ComboNumber == 29)      {   return "ja"; }
if (ComboNumber == 30)      {   return "km"; }
if (ComboNumber == 31)      {   return "ko"; }
if (ComboNumber == 32)      {   return "lt"; }
if (ComboNumber == 33)      {   return "lv"; }
if (ComboNumber == 34)      {   return "mi"; }
if (ComboNumber == 35)      {   return "mk"; }
if (ComboNumber == 36)      {   return "mr"; }
if (ComboNumber == 37)      {   return "nl"; }
if (ComboNumber == 38)      {   return "no"; }
if (ComboNumber == 39)      {   return "oc"; }
if (ComboNumber == 40)      {   return "pl"; }
if (ComboNumber == 41)      {   return "pt"; }
if (ComboNumber == 42)      {   return "ro"; }
if (ComboNumber == 43)      {   return "ru"; }
if (ComboNumber == 44)      {   return "sk"; }
if (ComboNumber == 45)      {   return "sl"; }
if (ComboNumber == 46)      {   return "sr"; }
if (ComboNumber == 47)      {   return "sv"; }
if (ComboNumber == 48)      {   return "ta"; }
if (ComboNumber == 49)      {   return "th"; }
if (ComboNumber == 50)      {   return "tr"; }
if (ComboNumber == 51)      {   return "uk"; }

return ERR;
}

QString Xorg :: ModelTranslate (int ModelNumber)
{
if (ModelNumber == 1) { return "pc105"; }
if (ModelNumber == 2) { return "pc104"; }
if (ModelNumber == 3) { return "logicordless"; }
if (ModelNumber == 4) { return "macintosh"; }
if (ModelNumber == 5) { return "pc98"; }
if (ModelNumber == 6) { return "pc101_sol8x86"; }
return ERR;
}

QString Xorg :: ProtocolTranslate (int ProtocolNumber)
{
if (ProtocolNumber == 0) { return "Standard"; }
if (ProtocolNumber == 1) { return "Xqueue"; }
return ERR;
}

QString Xorg :: DumpConfiguration()
{
QString ToReturn = Locale(0);








  for (int a = 1; a <= CountSections(ServerLayout); a++)
   {
    ToReturn = ToReturn.append("\n\n  Section \"ServerLayout\"").append(ServerLayoutSection[a]).append("  EndSection\n\n");
   }

    if (ServerFlagsSection != "")  { ToReturn = ToReturn.append("\n\n  Section \"ServerFlags\"\n" + ServerFlagsSection + "  EndSection\n\n"); }
    if (FilesSection != "")        { ToReturn = ToReturn.append("\n\n  Section \"Files\"\n" + FilesSection + "  EndSection\n\n"); }
    if (ModulesSection != "")      { ToReturn = ToReturn.append("\n\n  Section \"Module\"\n" + ModulesSection + "  EndSection\n\n"); }
    if (ExtensionsSection != "")   { ToReturn = ToReturn.append("\n\n  Section \"Extensions\"\n" + ExtensionsSection + "  EndSection\n\n"); }


  for (int a = 1; a <= CountSections(InputDevice); a++)
   {
    ToReturn = ToReturn.append("\n\n  Section \"InputDevice\"").append(InputDeviceSection[a]).append("  EndSection\n\n");
   }

  for (int a = 1; a <= CountSections(Device); a++)
   {
    ToReturn = ToReturn.append("\n\n  Section \"Device\"").append(DeviceSection[a]).append("  EndSection\n\n");
   }

  for (int a = 1; a <= CountSections(Monitor); a++)
   {
    ToReturn = ToReturn.append("\n\n  Section \"Monitor\"").append(MonitorSection[a]).append("  EndSection\n\n");
   }

  for (int a = 1; a <= CountSections(Screen); a++)
   {
    ToReturn = ToReturn.append("\n\n  Section \"Screen\"").append(ScreenSection[a]).append("  EndSection\n\n");
   }

QString Remove = "";
for (int x = 0; x < 100; x++)
{
Remove = Remove.append("\n");
ToReturn.replace(Remove, "\n");
}


ToReturn = ToReturn.remove("FontPath \"\"\n");
ToReturn = ToReturn.remove("ModulePath \"\"\n");
ToReturn = ToReturn.remove("RGBPath \"\"\n");

ToReturn = ToReturn.remove("Section \"Files\"\nEndSection\n");

//Making configuration file human-readable

ToReturn = ToReturn.replace("\nIdentifier",              "\n      Identifier    ");
ToReturn = ToReturn.replace("\nLoad",                    "\n      Load          ");
ToReturn = ToReturn.replace("\nDriver",                  "\n      Driver        ");
ToReturn = ToReturn.replace("\nOption",                  "\n      Option        ");
ToReturn = ToReturn.replace("\nDevice",                  "\n      Device        ");
ToReturn = ToReturn.replace("\nMonitor",                 "\n      Monitor       ");
ToReturn = ToReturn.replace("\nVendorName",              "\n      VendorName    ");
ToReturn = ToReturn.replace("\nBoardName",               "\n      BoardName     ");
ToReturn = ToReturn.replace("\nScreen",                  "\n      Screen        ");
ToReturn = ToReturn.replace("\nInputDevice",             "\n      InputDevice   ");
ToReturn = ToReturn.replace("\nModelName",               "\n      ModelName     ");
ToReturn = ToReturn.replace("\nDisplaySize",             "\n      DisplaySize   ");
ToReturn = ToReturn.replace("\nHorizSync",               "\n      HorizSync     ");
ToReturn = ToReturn.replace("\nVertRefresh",             "\n      VertRefresh   ");
ToReturn = ToReturn.replace("\nFontPath",                "\n      FontPath      ");
ToReturn = ToReturn.replace("\nRGBPath",                 "\n      RGBPath       ");
ToReturn = ToReturn.replace("\nModulePath",              "\n      ModulePath    ");
ToReturn = ToReturn.replace("\nModeLine",                "\n      ModeLine      ");
ToReturn = ToReturn.replace("\nModeline",                "\n      ModeLine      ");
ToReturn = ToReturn.replace("\nDefaultDepth",            "\n      DefaultDepth");
ToReturn = ToReturn.replace("\nSubSection \"Display\"",  "\n\n         SubSection \"Display\"");
ToReturn = ToReturn.replace("\nViewport",                "\n            Viewport       ");
ToReturn = ToReturn.replace("\nDepth",                   "\n            Depth          ");
ToReturn = ToReturn.replace("\nModes",                   "\n            Modes          ");
ToReturn = ToReturn.replace("\nEndSubSection",           "\n         EndSubSection");



ToReturn = ToReturn.replace("\"\n\n","\"\n");
return ToReturn;

}

QString Xorg :: DumpSection(Section SectionName, int SectionNumber)
{
if (SectionName == ServerLayout)   { return ServerLayoutSection[SectionNumber]; }
if (SectionName == ServerFlags)    { return ServerFlagsSection; }
if (SectionName == Files)          { return FilesSection; }
if (SectionName == Modules)        { return ModulesSection; }
if (SectionName == Extensions)     { return ExtensionsSection; }
if (SectionName == InputDevice)    { return InputDeviceSection[SectionNumber]; }
if (SectionName == Device)         { return DeviceSection[SectionNumber]; }
if (SectionName == Monitor)        { return MonitorSection[SectionNumber]; }
if (SectionName == Screen)         { return ScreenSection[SectionNumber]; }

return "NULL";
}



int Xorg :: CountSections (Section SectionName)
{
  int a = 1;
while (1)
  {
   if (DumpSection(SectionName, a) == "") { break; }
   a++;
  }
return a - 1;
}

int Xorg :: CountValues(Section SectionName, int SectionNumber, QString ValueName)
{

ValueName = ValueName.prepend("\n").append(" \"");            //To make sure that commented # lines are omitted.

  if (SectionName == ServerLayout)
    {
      return ServerLayoutSection[SectionNumber].contains(ValueName);
    }

  if (SectionName == ServerFlags)
    {
      return ServerFlagsSection.contains(ValueName);;
    }

  if (SectionName == Files)
    {
      return FilesSection.contains(ValueName);
    }

  if (SectionName == Modules)
    {
      return ModulesSection.contains(ValueName);;
    }

  if (SectionName == Extensions)
    {
      return ExtensionsSection.contains(ValueName);
    }

  if (SectionName == InputDevice)
    {
      return InputDeviceSection[SectionNumber].contains(ValueName);
    }

  if (SectionName == Device)
    {
      return DeviceSection[SectionNumber].contains(ValueName);
    }

  if (SectionName == Monitor)
    {
      return MonitorSection[SectionNumber].contains(ValueName);
    }

  if (SectionName == Screen)
    {
      return ScreenSection[SectionNumber].contains(ValueName);
    }
return -1;
}

int Xorg :: PointerTranslate(int PointerNumber)
{
int SectionCounter = 0;
int x = 1;
while (SectionCounter <= CountSections(InputDevice))
{
if (x > CountSections(InputDevice)) { return -1; }
if (!isKeyboard(x)) { SectionCounter++; }
if (SectionCounter == PointerNumber) { break; }
x++;
}
return x;

}

int Xorg :: KeyboardTranslate(int KeyboardNumber)
{
int SectionCounter = 0;
int x = 1;
while (SectionCounter <= CountSections(InputDevice))
{
if (x > CountSections(InputDevice)) { return -1; }
if (isKeyboard(x)) { SectionCounter++; }
if (SectionCounter == KeyboardNumber) { break; }
x++;
}
return x;

}

int Xorg :: LayoutTranslate(QString LayoutName)
{
if (LayoutName == "af")      {   return 1; }
if (LayoutName == "ar")      {   return 2; }
if (LayoutName == "bg")      {   return 3; }
if (LayoutName == "bo")      {   return 4; }
if (LayoutName == "br")      {   return 5; }
if (LayoutName == "ca")      {   return 6; }
if (LayoutName == "cs")      {   return 7; }
if (LayoutName == "cy")      {   return 8; }
if (LayoutName == "da")      {   return 9; }
if (LayoutName == "de")      {   return 10; }
if (LayoutName == "el")      {   return 11; }
if (LayoutName == "en_GB")   {   return 12; }
if (LayoutName == "en_US")   {   return 13; }
if (LayoutName == "eo")      {   return 14; }
if (LayoutName == "es")      {   return 15; }
if (LayoutName == "et")      {   return 16; }
if (LayoutName == "eu")      {   return 17; }
if (LayoutName == "fi")      {   return 18; }
if (LayoutName == "fr")      {   return 19; }
if (LayoutName == "ga")      {   return 20; }
if (LayoutName == "gl")      {   return 21; }
if (LayoutName == "gu")      {   return 22; }
if (LayoutName == "he")      {   return 23; }
if (LayoutName == "hi")      {   return 24; }
if (LayoutName == "hu")      {   return 25; }
if (LayoutName == "id")      {   return 26; }
if (LayoutName == "is")      {   return 27; }
if (LayoutName == "it")      {   return 28; }
if (LayoutName == "ja")      {   return 29; }
if (LayoutName == "km")      {   return 30; }
if (LayoutName == "ko")      {   return 31; }
if (LayoutName == "lt")      {   return 32; }
if (LayoutName == "lv")      {   return 33; }
if (LayoutName == "mi")      {   return 34; }
if (LayoutName == "mk")      {   return 35; }
if (LayoutName == "mr")      {   return 36; }
if (LayoutName == "nl")      {   return 37; }
if (LayoutName == "no")      {   return 38; }
if (LayoutName == "oc")      {   return 39; }
if (LayoutName == "pl")      {   return 40; }
if (LayoutName == "pt")      {   return 41; }
if (LayoutName == "ro")      {   return 42; }
if (LayoutName == "ru")      {   return 43; }
if (LayoutName == "sk")      {   return 44; }
if (LayoutName == "sl")      {   return 45; }
if (LayoutName == "sr")      {   return 46; }
if (LayoutName == "sv")      {   return 47; }
if (LayoutName == "ta")      {   return 48; }
if (LayoutName == "th")      {   return 49; }
if (LayoutName == "tr")      {   return 50; }
if (LayoutName == "uk")      {   return 51; }

return 0;
}

int Xorg :: ModelTranslate (QString ModelName)
{
if (ModelName == "pc105")          {   return 1; }
if (ModelName == "pc104")          {   return 2; }
if (ModelName == "logicordless")   {   return 3; }
if (ModelName == "macintosh")      {   return 4; }
if (ModelName == "pc98")           {   return 5; }
if (ModelName == "pc101_sol8x86")  {   return 6; }

return 0;
}

int Xorg :: ProtocolTranslate (QString ProtocolName)
{
if (ProtocolName == "Standard")    { return 0; }
if (ProtocolName == "Xqueue")      { return 1; }

return 0;
}




void Xorg :: AppendValue(Section SectionName, int SectionNumber, QString ValueName, QString ValueEntry)
{
if (SectionName == ServerLayout)
  {
   ServerLayoutSection[SectionNumber] = ServerLayoutSection[SectionNumber].append(ValueName + " \"" + ValueEntry + "\"\n");
  }

if (SectionName == ServerFlags)
  {
   ServerFlagsSection = ServerFlagsSection.append(ValueName + " \"" + ValueEntry + "\"\n");
  }

if (SectionName == Files)
  {
   FilesSection = FilesSection.append(ValueName + " \"" + ValueEntry + "\"\n");
  }

if (SectionName == Modules)
  {
   ModulesSection = ModulesSection.append(ValueName + " \"" + ValueEntry + "\"\n");
  }

if (SectionName == Extensions)
  {
   ExtensionsSection = ExtensionsSection.append(ValueName + " \"" + ValueEntry + "\"\n");
  }

if (SectionName == InputDevice)
  {
   InputDeviceSection[SectionNumber] = InputDeviceSection[SectionNumber].append(ValueName + " \"" + ValueEntry + "\"\n");
  }

if (SectionName == Device)
  {
   DeviceSection[SectionNumber] = DeviceSection[SectionNumber].append(ValueName + " \"" + ValueEntry + "\"\n");
  }

if (SectionName == Monitor)
  {
   MonitorSection[SectionNumber] = MonitorSection[SectionNumber].append(ValueName + " \"" + ValueEntry + "\"\n");
  }

if (SectionName == Screen)
  {
   ScreenSection[SectionNumber] = ScreenSection[SectionNumber].append(ValueName + " \"" + ValueEntry + "\"\n");
  }
}

void Xorg :: AppendLineBreakValue(Section SectionName, int SectionNumber, QString ValueName, QString ValueEntry)
{
if (SectionName == ServerLayout)
  {
   ServerLayoutSection[SectionNumber] = ServerLayoutSection[SectionNumber].append(ValueName + " " + ValueEntry + "\n");
  }

if (SectionName == ServerFlags)
  {
   ServerFlagsSection = ServerFlagsSection.append(ValueName + " " + ValueEntry + "\n");
  }

if (SectionName == Files)
  {
   FilesSection = FilesSection.append(ValueName + " " + ValueEntry + "\n");
  }

if (SectionName == Modules)
  {
   ModulesSection = ModulesSection.append(ValueName + " " + ValueEntry + "\n");
  }

if (SectionName == Extensions)
  {
   ExtensionsSection = ExtensionsSection.append(ValueName + " " + ValueEntry + "\n");
  }

if (SectionName == InputDevice)
  {
   InputDeviceSection[SectionNumber] = InputDeviceSection[SectionNumber].append(ValueName + " " + ValueEntry + "\n");
  }

if (SectionName == Device)
  {
   DeviceSection[SectionNumber] = DeviceSection[SectionNumber].append(ValueName + " " + ValueEntry + "\n");
  }

if (SectionName == Monitor)
  {
   MonitorSection[SectionNumber] = MonitorSection[SectionNumber].append(ValueName + " " + ValueEntry + "\n");
  }

if (SectionName == Screen)
  {
   ScreenSection[SectionNumber] = ScreenSection[SectionNumber].append(ValueName + " " + ValueEntry + "\n");
  }
}

void Xorg :: RemoveValue(Section SectionName, int SectionNumber, QString ValueName, QString ValueEntry)
{

if (SectionName == ServerLayout)
  {
   ServerLayoutSection[SectionNumber].remove(ValueName + " \"" + ValueEntry + "\"" + 
   ServerLayoutSection[SectionNumber].section(ValueName + " \"" + ValueEntry + "\"", 1, 1).section("\n", 0, 0) + "\n");
  }

if (SectionName == ServerFlags)
  {
   ServerFlagsSection.remove(ValueName + " \"" + ValueEntry + "\"" + 
   ServerFlagsSection.section(ValueName + " \"" + ValueEntry + "\"", 1, 1).section("\n", 0, 0) + "\n");
  }

if (SectionName == Files)
  {
   FilesSection.remove(ValueName + " \"" + ValueEntry + "\"" + 
   FilesSection.section(ValueName + " \"" + ValueEntry + "\"", 1, 1).section("\n", 0, 0) + "\n");
  }

if (SectionName == Modules)
  {
   ModulesSection.remove(ValueName + " \"" + ValueEntry + "\"" + 
   ModulesSection.section(ValueName + " \"" + ValueEntry + "\"", 1, 1).section("\n", 0, 0) + "\n");
  }

if (SectionName == Extensions)
  {
   ExtensionsSection.remove(ValueName + " \"" + ValueEntry + "\"" + 
   ExtensionsSection.section(ValueName + " \"" + ValueEntry + "\"", 1, 1).section("\n", 0, 0) + "\n");
  }

if (SectionName == InputDevice)
  {
   InputDeviceSection[SectionNumber].remove(ValueName + " \"" + ValueEntry + "\"" + 
   InputDeviceSection[SectionNumber].section(ValueName + " \"" + ValueEntry + "\"", 1, 1).section("\n", 0, 0) + "\n");
  }

if (SectionName == Device)
  {
   DeviceSection[SectionNumber].remove(ValueName + " \"" + ValueEntry + "\"" + 
   DeviceSection[SectionNumber].section(ValueName + " \"" + ValueEntry + "\"", 1, 1).section("\n", 0, 0) + "\n");
  }

if (SectionName == Monitor)
  {
   MonitorSection[SectionNumber].remove(ValueName + " \"" + ValueEntry + "\"" + 
   MonitorSection[SectionNumber].section(ValueName + " \"" + ValueEntry + "\"", 1, 1).section("\n", 0, 0) + "\n");
  }

if (SectionName == Screen)
  {
   ScreenSection[SectionNumber].remove(ValueName + " \"" + ValueEntry + "\"" + 
   ScreenSection[SectionNumber].section(ValueName + " \"" + ValueEntry + "\"", 1, 1).section("\n", 0, 0) + "\n");
  }

}

void Xorg :: RemoveValue(Section SectionName, int SectionNumber, QString ValueName)
{
if (SectionName == ServerLayout)
  {
   ServerLayoutSection[SectionNumber].remove(ValueName +
   ServerLayoutSection[SectionNumber].section(ValueName, 1, 1).section("\n", 0, 0));
  }

if (SectionName == ServerFlags)
  {
   ServerFlagsSection.remove(ValueName +
   ServerFlagsSection.section(ValueName, 1, 1).section("\n", 0, 0));
  }

if (SectionName == Files)
  {
   FilesSection.remove(ValueName +
   FilesSection.section(ValueName, 1, 1).section("\n", 0, 0));
  }

if (SectionName == Modules)
  {
   ModulesSection.remove(ValueName +
   ModulesSection.section(ValueName, 1, 1).section("\n", 0, 0));
  }

if (SectionName == Extensions)
  {
   ExtensionsSection.remove(ValueName +
   ExtensionsSection.section(ValueName, 1, 1).section("\n", 0, 0));
  }

if (SectionName == InputDevice)
  {
   InputDeviceSection[SectionNumber].remove(ValueName +
   InputDeviceSection[SectionNumber].section(ValueName, 1, 1).section("\n", 0, 0));
  }

if (SectionName == Device)
  {
   DeviceSection[SectionNumber].remove(ValueName +
   DeviceSection[SectionNumber].section(ValueName, 1, 1).section("\n", 0, 0));
  }

if (SectionName == Monitor)
  {
   MonitorSection[SectionNumber].remove(ValueName +
   MonitorSection[SectionNumber].section(ValueName, 1, 1).section("\n", 0, 0));
  }

if (SectionName == Screen)
  {
   ScreenSection[SectionNumber].remove(ValueName +
   ScreenSection[SectionNumber].section(ValueName, 1, 1).section("\n", 0, 0));
  }

}

void Xorg :: LoadConfig (QString XorgFile, QString PathToVideoDrivers, QString PathToInputDrivers, QString PathToHwConf)  ///@todo Fix 
{

//Saving properties
    Properties[0] = XorgFile;
    Properties[1] = PathToVideoDrivers;
    Properties[2] = PathToInputDrivers;
    Properties[3] = PathToHwConf;



WholeFile = "";

QFile *ConfigFile = new QFile(XorgFile);

ConfigFile->open(IO_ReadOnly);



    QString Buffer;
  while (1)
    {
     if (ConfigFile->atEnd()) { break; }
     ConfigFile->readLine(Buffer, 4096);
     Buffer = Buffer.simplifyWhiteSpace();
     WholeFile = WholeFile.append(Buffer + "\n");
    }

for (int a = 1; a <= WholeFile.contains("#"); a++)
{
QString toRemove = WholeFile.section("#", a, a).section("\n", 0, 0);
WholeFile.remove(toRemove);
}

WholeFile.remove("#");
int a = 0;
while (a <= WholeFile.contains("Section \"ServerLayout\"") - 1)
  {
    ServerLayoutSection[a + 1] = GetSection(ServerLayout, a);

    //My dirty hack:)

    QString ScreenName;
    ScreenName = ServerLayoutSection[a + 1].section("Screen", 1, 255).section("\"", 1, 1);

    RemoveValue(ServerLayout, a + 1, "Screen");
    WriteValue(ServerLayout, a + 1, "Screen", ScreenName);
    a++;
  }

a = 0;
while (a <= WholeFile.contains("Section \"ServerFlags\""))
  {
    ServerFlagsSection = GetSection(ServerFlags, 0);
    a++;
  }

a = 0;
while (a <= WholeFile.contains("Section \"Files\""))
  {
    FilesSection = GetSection(Files, 0);
    a++;
  }

a = 0;
while (a <= WholeFile.contains("Section \"Module\""))
  {
    ModulesSection = GetSection(Modules, 0);
    a++;
  }

a = 0;
while (a <= WholeFile.contains("Section \"Extensions\""))
  {
    ExtensionsSection = GetSection(Extensions, 0);
    a++;
  }

a = 0;
while (a <= WholeFile.contains("Section \"InputDevice\""))
  {
    InputDeviceSection[a + 1] = GetSection(InputDevice, a);
    a++;
  }

a = 0;
while (a <= WholeFile.contains("Section \"Device\""))
  {
    DeviceSection[a + 1] = GetSection(Device, a);
    a++;
  }

a = 0;
while (a <= WholeFile.contains("Section \"Monitor\""))
  {
    MonitorSection[a + 1] = GetSection(Monitor, a);
    a++;
  }

a = 0;
while (a <= WholeFile.contains("Section \"Screen\""))
  {
    ScreenSection[a + 1] = GetSection(Screen, a);
    a++;
  }








}

void Xorg :: WriteValue (Section SectionName, int SectionNumber, QString ValueName, QString ValueEntry)
{


  if (SectionName == ServerLayout)
   {
    QString Value = ServerLayoutSection[SectionNumber].section(ValueName, 1, 1).section("\n", 0, 0).prepend(ValueName);
    QString NewValue = ValueName + " \"" + ValueEntry + "\"";
    ServerLayoutSection[SectionNumber] = ServerLayoutSection[SectionNumber].replace(Value, NewValue);
    if (ServerLayoutSection[SectionNumber].contains(ValueName + " \"") == 0) { AppendValue (SectionName, SectionNumber, ValueName, ValueEntry); }
   }

  if (SectionName == InputDevice)
   {
    QString Value = InputDeviceSection[SectionNumber].section(ValueName, 1, 1).section("\n", 0, 0).prepend(ValueName);
    QString NewValue = ValueName + " \"" + ValueEntry + "\"";
    InputDeviceSection[SectionNumber] = InputDeviceSection[SectionNumber].replace(Value, NewValue);
    if (InputDeviceSection[SectionNumber].contains(ValueName + " \"") == 0) { AppendValue (SectionName, SectionNumber, ValueName, ValueEntry); }
   }

  if (SectionName == ServerFlags)
   {
    QString Value = ServerFlagsSection.section(ValueName, 1, 1).section("\n", 0, 0).prepend(ValueName);
    QString NewValue = ValueName + " \"" + ValueEntry + "\"";
    ServerFlagsSection = ServerFlagsSection.replace(Value, NewValue);
    if (ServerFlagsSection.contains(ValueName + " \"") == 0) { AppendValue (SectionName, SectionNumber, ValueName, ValueEntry); }
   }



  if (SectionName == Files)
   {
    QString Value = FilesSection.section(ValueName, 1, 1).section("\n", 0, 0).prepend(ValueName);
    QString NewValue = ValueName + " \"" + ValueEntry + "\"";
    FilesSection = FilesSection.replace(Value, NewValue);
    if (FilesSection.contains(ValueName + " \"") == 0) { AppendValue (SectionName, SectionNumber, ValueName, ValueEntry); }
   }

  if (SectionName == Modules)
   {
    QString Value = ModulesSection.section(ValueName, 1, 1).section("\n", 0, 0).prepend(ValueName);
    QString NewValue = ValueName + " \"" + ValueEntry + "\"";
    ModulesSection = ModulesSection.replace(Value, NewValue);
    if (ModulesSection.contains(ValueName + " \"") == 0) { AppendValue (SectionName, SectionNumber, ValueName, ValueEntry); }
   }

  if (SectionName == Extensions)
   {
    QString Value = ExtensionsSection.section(ValueName, 1, 1).section("\n", 0, 0).prepend(ValueName);
    QString NewValue = ValueName + " \"" + ValueEntry + "\"";
    ExtensionsSection = ExtensionsSection.replace(Value, NewValue);
    if (ExtensionsSection.contains(ValueName + " \"") == 0) { AppendValue (SectionName, SectionNumber, ValueName, ValueEntry); }
   }

  if (SectionName == Device)
   {
    QString Value = DeviceSection[SectionNumber].section(ValueName, 1, 1).section("\n", 0, 0).prepend(ValueName);
    QString NewValue = ValueName + " \"" + ValueEntry + "\"";
    DeviceSection[SectionNumber] = DeviceSection[SectionNumber].replace(Value, NewValue);
    if (DeviceSection[SectionNumber].contains(ValueName + " \"") == 0) { AppendValue (SectionName, SectionNumber, ValueName, ValueEntry); }
   }

  if (SectionName == Monitor)
   {
    QString Value = MonitorSection[SectionNumber].section(ValueName, 1, 1).section("\n", 0, 0).prepend(ValueName);
    QString NewValue = ValueName + " \"" + ValueEntry + "\"";
    MonitorSection[SectionNumber] = MonitorSection[SectionNumber].replace(Value, NewValue);
    if (MonitorSection[SectionNumber].contains(ValueName + " \"") == 0) { AppendValue (SectionName, SectionNumber, ValueName, ValueEntry); }
   }

  if (SectionName == Screen)
   {
    QString Value = ScreenSection[SectionNumber].section(ValueName, 1, 1).section("\n", 0, 0).prepend(ValueName);
    QString NewValue = ValueName + " \"" + ValueEntry + "\"";
    ScreenSection[SectionNumber] = ScreenSection[SectionNumber].replace(Value, NewValue);
    if (ScreenSection[SectionNumber].contains(ValueName + " \"") == 0) { AppendValue (SectionName, SectionNumber, ValueName, ValueEntry); }
   }

}

void Xorg :: WriteOption (Section SectionName, int SectionNumber, QString ValueName, QString ValueEntry)
{
WriteValue(SectionName, SectionNumber, "Option \"" + ValueName + "\"", ValueEntry);
}

void Xorg :: RemoveOption(Section SectionName, int SectionNumber, QString ValueName)
{
RemoveValue (SectionName, SectionNumber, "Option \"" + ValueName + "\"");
}

void Xorg :: RemoveSection(Section SectionName, int SectionNumber)
{
  if (SectionName == ServerLayout)
   {
    for (int a = SectionNumber; a <= CountSections(ServerLayout); a++)
     {
      ServerLayoutSection[a] = ServerLayoutSection[a + 1];
     }
   }



  if (SectionName == InputDevice)
   {
    for (int a = SectionNumber; a <= CountSections(InputDevice); a++)
     {
      InputDeviceSection[a] = InputDeviceSection[a + 1];
     }
   }


  if (SectionName == Device)
   {
    for (int a = SectionNumber; a <= CountSections(Device); a++)
     {
      DeviceSection[a] = DeviceSection[a + 1];
     }
   }

  if (SectionName == Monitor)
   {
    for (int a = SectionNumber; a <= CountSections(Monitor); a++)
     {
      MonitorSection[a] = MonitorSection[a + 1];
     }
   }

  if (SectionName == Screen)
   {
    for (int a = SectionNumber; a <= CountSections(Screen); a++)
     {
      ScreenSection[a] = ScreenSection[a + 1];
     }
   }



}

void Xorg :: AppendLine(Section SectionName, int SectionNumber, QString Value)
{


  if (SectionName == ServerLayout)
   {
    ServerLayoutSection[SectionNumber] = ServerLayoutSection[SectionNumber].append(Value);
   }

  if (SectionName == InputDevice)
   {
    InputDeviceSection[SectionNumber] = InputDeviceSection[SectionNumber].append(Value);
   }

  if (SectionName == Files)
   {
    FilesSection = FilesSection.append(Value);
   }

  if (SectionName == Modules)
   {
    ModulesSection = ModulesSection.append(Value);
   }

  if (SectionName == Extensions)
   {
    ExtensionsSection = ExtensionsSection.append(Value);
   }

  if (SectionName == Device)
   {
    DeviceSection[SectionNumber] = DeviceSection[SectionNumber].append(Value);
   }

  if (SectionName == Monitor)
   {
    MonitorSection[SectionNumber] = MonitorSection[SectionNumber].append(Value);
   }

  if (SectionName == Screen)
   {
    ScreenSection[SectionNumber] = ScreenSection[SectionNumber].append(Value);
   }

}

void Xorg :: WriteLineBreakValue(Section SectionName, int SectionNumber, QString ValueName, QString ValueEntry)
{

  if (SectionName == ServerLayout)
   {
    QString Value = ServerLayoutSection[SectionNumber].section(ValueName, 1, 1).section("\n", 0, 0).prepend(ValueName);
    QString NewValue = ValueName + " " + ValueEntry;
    ServerLayoutSection[SectionNumber] = ServerLayoutSection[SectionNumber].replace(Value, NewValue);
    if (ServerLayoutSection[SectionNumber].contains(ValueName) == 0) { AppendLineBreakValue (SectionName, SectionNumber, ValueName, ValueEntry); }
   }

  if (SectionName == InputDevice)
   {
    QString Value = InputDeviceSection[SectionNumber].section(ValueName, 1, 1).section("\n", 0, 0).prepend(ValueName);
    QString NewValue = ValueName + " " + ValueEntry;
    InputDeviceSection[SectionNumber] = InputDeviceSection[SectionNumber].replace(Value, NewValue);
    if (InputDeviceSection[SectionNumber].contains(ValueName) == 0) { AppendLineBreakValue (SectionName, SectionNumber, ValueName, ValueEntry); }
   }

  if (SectionName == Files)
   {
    QString Value = FilesSection.section(ValueName, 1, 1).section("\n", 0, 0).prepend(ValueName);
    QString NewValue = ValueName + " " + ValueEntry;
    FilesSection = FilesSection.replace(Value, NewValue);
    if (FilesSection.contains(ValueName) == 0) { AppendLineBreakValue (SectionName, SectionNumber, ValueName, ValueEntry); }
   }

  if (SectionName == Modules)
   {
    QString Value = ModulesSection.section(ValueName, 1, 1).section("\n", 0, 0).prepend(ValueName);
    QString NewValue = ValueName + " " + ValueEntry;
    ModulesSection = ModulesSection.replace(Value, NewValue);
    if (ModulesSection.contains(ValueName) == 0) { AppendLineBreakValue (SectionName, SectionNumber, ValueName, ValueEntry); }
   }

  if (SectionName == Extensions)
   {
    QString Value = ExtensionsSection.section(ValueName, 1, 1).section("\n", 0, 0).prepend(ValueName);
    QString NewValue = ValueName + " " + ValueEntry;
    ExtensionsSection = ExtensionsSection.replace(Value, NewValue);
    if (ExtensionsSection.contains(ValueName) == 0) { AppendLineBreakValue (SectionName, SectionNumber, ValueName, ValueEntry); }
   }

  if (SectionName == Device)
   {
    QString Value = DeviceSection[SectionNumber].section(ValueName, 1, 1).section("\n", 0, 0).prepend(ValueName);
    QString NewValue = ValueName + " " + ValueEntry;
    DeviceSection[SectionNumber] = DeviceSection[SectionNumber].replace(Value, NewValue);
    if (DeviceSection[SectionNumber].contains(ValueName) == 0) { AppendLineBreakValue (SectionName, SectionNumber, ValueName, ValueEntry); }
   }

  if (SectionName == Monitor)
   {
    QString Value = MonitorSection[SectionNumber].section(ValueName, 1, 1).section("\n", 0, 0).prepend(ValueName);
    QString NewValue = ValueName + " " + ValueEntry;
    MonitorSection[SectionNumber] = MonitorSection[SectionNumber].replace(Value, NewValue);
    if (MonitorSection[SectionNumber].contains(ValueName) == 0) { AppendLineBreakValue (SectionName, SectionNumber, ValueName, ValueEntry); }
   }

  if (SectionName == Screen)
   {
    QString Value = ScreenSection[SectionNumber].section(ValueName, 1, 1).section("\n", 0, 0).prepend(ValueName);
    QString NewValue = ValueName + " " + ValueEntry;
    ScreenSection[SectionNumber] = ScreenSection[SectionNumber].replace(Value, NewValue);
    if (ScreenSection[SectionNumber].contains(ValueName) == 0) { AppendLineBreakValue (SectionName, SectionNumber, ValueName, ValueEntry); }
   }
}

void Xorg :: AddSection(Section SectionName, QString Identifier)
{
WriteLineBreakValue(SectionName, CountSections(SectionName) + 1, Identifier, "");
}

void Xorg :: ReplaceServerLayoutValue(QString OldName, QString NewName)
{
   for (int a = 0; a <= CountSections(ServerLayout); a++)
     {
      ServerLayoutSection[a].replace("\"" + OldName + "\"", "\"" + NewName + "\"");
     }
}

void Xorg :: ReplaceScreenValue(QString Value, QString OldName, QString NewName)
{
   for (int a = 1; a <= CountSections(Screen); a++)
     {
      ScreenSection[a].replace(Value + " \"" + OldName + "\"", Value + " \"" + NewName + "\"");
     }
}

void Xorg :: RemoveServerLayoutValue(QString Value, QString OldName)
{
   for (int a = 1; a <= CountSections(ServerLayout); a++)
     {
      ServerLayoutSection[a].replace(Value + " \"" + OldName + "\"", "");
     }


}

void Xorg :: ClearOptions(Section SectionName, int SectionNumber)
{
  for (int a = 0; a < 255; a++)
   {
    RemoveValue(SectionName, SectionNumber, "Option");
   }
}
