/***************************************************************************
 *   Copyright (C) 2006 by Tomasz Sałaciński   *
 *   distortion@vp.pl   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/


//QT Includes
#include <qlabel.h>
#include <qgroupbox.h>
#include <qfile.h>

//kX Generator Includes
#include "ScreenModesEditor.h"

ScreenModesEditor :: ScreenModesEditor(QWidget *Parent, Xorg *Xorg, int SectionNumber)
    : KDialog( Parent, "Screen Mode Editor Widget" )

{
SectNum = SectionNumber;
QFile *f = new QFile("/tmp/Modeline.sh");
f->open(IO_WriteOnly);
f->flush();
f->close();
KProcess *chmod = new KProcess;
*chmod << "chmod" << "+x" << "Modeline.sh";
chmod->setWorkingDirectory("/tmp");
chmod->start();


X = Xorg;



GTFScript = "";

  Icons = new KIconLoader();
  setPlainCaption(Locale(0));
  setMinimumSize(600, 500);
  setMaximumSize(600, 500);

//Drawing pixmap
    QLabel *Pixmap = new QLabel(this);
     Pixmap->setGeometry(462, 10, 128, 128);
     Pixmap->setPixmap(Icons->loadIcon("tv", KIcon::Desktop, KIcon::SizeEnormous));

//Logo Label


   QLabel *LogoLabel = new QLabel(this);
    LogoLabel->setText(Locale(1));
    LogoLabel->setFont(QFont("sans", 19, QFont::Normal, FALSE));
    LogoLabel->setGeometry(10, 10, 400, 35);
//Horizontal line
   QFrame *Line = new QFrame(this);
    Line->setGeometry(QRect(10, 45, 442, 5));
    Line->setFrameShape( QFrame::HLine );
    Line->setFrameShadow( QFrame::Sunken );


   QFrame *LineBottom = new QFrame(this);
    LineBottom->setGeometry(QRect(10, 450, 580, 5));
    LineBottom->setFrameShape( QFrame::HLine );
    LineBottom->setFrameShadow( QFrame::Sunken );


//Informational Label
   QLabel *InformationalLabel = new QLabel(this);
    InformationalLabel->setGeometry(10, 55, 442, 100);
    InformationalLabel->setAlignment(QLabel::AlignTop | QLabel::WordBreak);
    InformationalLabel->setText(Locale(2));


   QLabel *SettingsLabel = new QLabel(this);
    SettingsLabel->setGeometry(10, 130, 442, 25);
    SettingsLabel->setText(Locale(7) + X->GetValue(Xorg::Monitor, SectionNumber, "VendorName", 1) + " " +
                                       X->GetValue(Xorg::Monitor, SectionNumber, "ModelName", 1) + " (<b>" +
                                       X->GetValue(Xorg::Monitor, SectionNumber, "Identifier", 1) + "</b>)");





//Making modes list box
   ModesListBox = new KListBox (this);
   ModesListBox->setGeometry(10, 170, 300, 270);



//Buttons

   OKButton = new KPushButton(this);
    OKButton->setGeometry(360, 460, 110, 29);
    OKButton->setText(Locale(3));
    OKButton->setIconSet(Icons->loadIcon("ok", KIcon::Desktop, KIcon::SizeSmall));

   CancelButton = new KPushButton(this);
    CancelButton->setGeometry(480, 460, 110, 29);
    CancelButton->setText(Locale(5));
    CancelButton->setIconSet(Icons->loadIcon("cancel", KIcon::Desktop, KIcon::SizeSmall));

   KPushButton *AddMode = new KPushButton(this);
    AddMode->setGeometry(320, 411, 120, 29);
    AddMode->setText(Locale(6));
    AddMode->setIconSet(Icons->loadIcon("add", KIcon::Desktop, KIcon::SizeSmall));

   KPushButton *RemoveMode = new KPushButton(this);
    RemoveMode->setGeometry(470, 411, 120, 29);
    RemoveMode->setText(Locale(8));
    RemoveMode->setIconSet(Icons->loadIcon("remove", KIcon::Desktop, KIcon::SizeSmall));

///Display size groupbox
   DisplaySizeGroup = new QGroupBox(this);
    DisplaySizeGroup->setGeometry(320, 170, 270, 100);
    DisplaySizeGroup->setTitle(Locale(9));
    DisplaySizeGroup->setCheckable(TRUE);

   DisplayX = new KIntSpinBox(DisplaySizeGroup);
    DisplayX->setGeometry(50, 25, 70, 25);
    DisplayX->setMaxValue(500000);

   QLabel *XLabel = new QLabel(DisplaySizeGroup);
    XLabel->setGeometry(10, 25, 40, 25);
    XLabel->setText("X:");

   QLabel *MMX = new QLabel(DisplaySizeGroup);
    MMX->setGeometry(130, 25, 40, 25);
    MMX->setText("mm");

   DisplayY = new KIntSpinBox(DisplaySizeGroup);
    DisplayY->setGeometry(50, 60, 70, 25);
    DisplayY->setMaxValue(500000);

   QLabel *YLabel = new QLabel(DisplaySizeGroup);
    YLabel->setGeometry(10, 60, 40, 25);
    YLabel->setText("Y:");

   QLabel *MMY = new QLabel(DisplaySizeGroup);
    MMY->setGeometry(130, 60, 40, 25);
    MMY->setText("mm");

   DisplaySizeGroup->setChecked(FALSE);


///Refresh Rates groupbox
   RefreshRatesGroup = new QGroupBox(this);
    RefreshRatesGroup->setGeometry(320, 290, 270, 110);
    RefreshRatesGroup->setCheckable(TRUE);
    RefreshRatesGroup->setTitle(Locale(10));
    RefreshRatesGroup->setChecked(FALSE);

   QLabel *HSyncLabel = new QLabel(RefreshRatesGroup);
    HSyncLabel->setGeometry(10, 25, 130, 25);
    HSyncLabel->setText(Locale(11));

   HSyncFrom = new KIntSpinBox(RefreshRatesGroup);
    HSyncFrom->setGeometry(140, 25, 50, 25);
    HSyncFrom->setMaxValue(300);

   QLabel *Multi1 = new QLabel(RefreshRatesGroup);
    Multi1->setGeometry(195, 25, 10, 25);
    Multi1->setText("x");

   HSyncTo = new KIntSpinBox(RefreshRatesGroup);
    HSyncTo->setGeometry(205, 25, 50, 25);
    HSyncTo->setMaxValue(300);




   QLabel *VertRefLabel = new QLabel(RefreshRatesGroup);
    VertRefLabel->setGeometry(10, 70, 130, 25);
    VertRefLabel->setText(Locale(12));

   VertRefFrom = new KIntSpinBox(RefreshRatesGroup);
    VertRefFrom->setGeometry(140, 70, 50, 25);
    VertRefFrom->setMaxValue(300);

   QLabel *Multi2 = new QLabel(RefreshRatesGroup);
    Multi2->setGeometry(195, 70, 10, 25);
    Multi2->setText("x");

   VertRefTo = new KIntSpinBox(RefreshRatesGroup);
    VertRefTo->setGeometry(205, 70, 50, 25);
    VertRefTo->setMaxValue(300);



//Filling List Box
if (X->CountValues(Xorg::Monitor, SectionNumber, "Modeline") > 0)
{
for (int a = 1; a <= X->CountValues(Xorg::Monitor, SectionNumber, "Modeline"); a++)
{
QString FormattedMode = X->GetValue(Xorg::Monitor, SectionNumber, "Modeline", a);

if (FormattedMode.contains("_") > 0)
{
FormattedMode.replace("_", " (");
FormattedMode = FormattedMode.left(FormattedMode.length() - 3);
FormattedMode.append(" Hz)");
}


ModesListBox->insertItem(FormattedMode);
}
}


if (X->CountValues(Xorg::Monitor, SectionNumber, "ModeLine") > 0)
{
for (int a = 1; a <= X->CountValues(Xorg::Monitor, SectionNumber, "ModeLine"); a++)
{
QString FormattedMode = X->GetValue(Xorg::Monitor, SectionNumber, "ModeLine", a);

if (FormattedMode.contains("_") > 0)
{
FormattedMode.replace("_", " (");
FormattedMode = FormattedMode.left(FormattedMode.length() - 3);
FormattedMode.append(" Hz)");
}


ModesListBox->insertItem(FormattedMode);
}
}








for (int x = 1; x <= X->CountValues(Xorg::Monitor, SectionNumber, "Mode"); x++)
{
QString FormattedMode = X->GetValue(Xorg::Monitor, SectionNumber, "Mode", x);
if (FormattedMode.contains("_") > 0)
{
FormattedMode.replace("_", " (");
FormattedMode = FormattedMode.left(FormattedMode.length() - 3);
FormattedMode.append(" Hz)");
}
ModesListBox->insertItem(FormattedMode);
}


QString DisplaySize = X->GetLineBreakValue(Xorg::Monitor, SectionNumber, "DisplaySize", 1);

if (DisplaySize != "")
  {
   DisplaySizeGroup->setChecked(TRUE);
   bool OK;
   DisplayX->setValue(DisplaySize.section(" ", 0, 0).toInt(&OK, 10));
   DisplayY->setValue(DisplaySize.section(" ", 1, 1).toInt(&OK, 10));
  }



QString HorizSync = X->GetLineBreakValue(Xorg::Monitor, SectionNumber, "HorizSync", 1);
HorizSync.remove(" ");
if (HorizSync != "")
  {
   RefreshRatesGroup->setChecked(TRUE);
   bool OK;
   HSyncFrom->setValue(HorizSync.section("-", 0, 0).section(".", 0, 0).toInt(&OK, 10));
   HSyncTo->setValue(HorizSync.section("-", 1, 1).section(".", 0, 0).toInt(&OK, 10));
  }

QString VertRefresh = X->GetLineBreakValue(Xorg::Monitor, SectionNumber, "VertRefresh", 1);
VertRefresh.remove(" ");
if (VertRefresh != "")
  {
   RefreshRatesGroup->setChecked(TRUE);
   bool OK;
   VertRefFrom->setValue(VertRefresh.section("-", 0, 0).section(".", 0, 0).toInt(&OK, 10));
   VertRefTo->setValue(VertRefresh.section("-", 1, 1).section(".", 0, 0).toInt(&OK, 10));
  }







ModesListBox->setSelected(0, TRUE);


connect (AddMode, SIGNAL(clicked()), this, SLOT(AddMode()));
connect (RemoveMode, SIGNAL(clicked()), this, SLOT(RemoveMode()));
connect (CancelButton, SIGNAL(clicked()), this, SLOT(reject()));
connect (OKButton, SIGNAL(clicked()), this, SLOT(StartGTF()));




}



void ScreenModesEditor :: RemoveMode()
{
unsigned int CurrentItem = ModesListBox->currentItem();
ModesListBox->removeItem(ModesListBox->currentItem());
if (CurrentItem < ModesListBox->count()) 
{ ModesListBox->setSelected(CurrentItem, TRUE); }
else
{ ModesListBox->setSelected(CurrentItem - 1, TRUE); }

}

void ScreenModesEditor :: AddMode()
{
ModeDialog = new KDialog();
ModeDialog->setPlainCaption(Locale(13));

ModeDialog->setMinimumSize(400, 150);
ModeDialog->setMaximumSize(400, 150);

//Horizontal line
   QFrame *AddLine = new QFrame(ModeDialog);
    AddLine->setGeometry(QRect(10, 105, 380, 5));
    AddLine->setFrameShape( QFrame::HLine );
    AddLine->setFrameShadow( QFrame::Sunken );

  AddOK = new KPushButton(ModeDialog);
   AddOK->setGeometry(140, 115, 120, 29);
   AddOK->setText(Locale(3));
   AddOK->setIconSet(Icons->loadIcon("ok", KIcon::Desktop, KIcon::SizeSmall));

  AddCancel = new KPushButton(ModeDialog);
   AddCancel->setGeometry(270, 115, 120, 29);
   AddCancel->setText(Locale(5));
   AddCancel->setIconSet(Icons->loadIcon("cancel", KIcon::Desktop, KIcon::SizeSmall));

  QLabel *ModeLabel = new QLabel(ModeDialog);
   ModeLabel->setGeometry(10, 20, 220, 25);
   ModeLabel->setText(Locale(15));

  NewModeCombo = new KComboBox(ModeDialog);
   NewModeCombo->setGeometry(10, 45, 220, 25);

  QLabel *RefreshLabel = new QLabel(ModeDialog);
   RefreshLabel->setGeometry(240, 20, 150, 25);
   RefreshLabel->setText(Locale(16));

  NewRefreshCombo = new KComboBox(ModeDialog);
   NewRefreshCombo->setGeometry(240, 45, 150, 25);



NewModeCombo->insertItem("320x200");
NewModeCombo->insertItem("320x240");
NewModeCombo->insertItem("400x300");
NewModeCombo->insertItem("512x384");
NewModeCombo->insertItem("640x400");
NewModeCombo->insertItem("640x480");
NewModeCombo->insertItem("800x600");
NewModeCombo->insertItem("1024x768");
NewModeCombo->insertItem("1152x864");
NewModeCombo->insertItem("1280x1024");
NewModeCombo->insertItem("1600x1200");

NewRefreshCombo->insertItem("60 Hz");
NewRefreshCombo->insertItem("70 Hz");
NewRefreshCombo->insertItem("72 Hz");
NewRefreshCombo->insertItem("75 Hz");
NewRefreshCombo->insertItem("85 Hz");
NewRefreshCombo->insertItem("90 Hz");
NewRefreshCombo->insertItem("100 Hz");
NewRefreshCombo->insertItem("110 Hz");
NewRefreshCombo->insertItem("120 Hz");
NewRefreshCombo->insertItem("150 Hz");


     connect (AddOK, SIGNAL(clicked()), this, SLOT(AddedMode()));
     connect (AddCancel, SIGNAL(clicked()), ModeDialog, SLOT(reject()));
     connect (NewRefreshCombo, SIGNAL(activated(int)), this, SLOT(Mode()));
     connect (NewModeCombo, SIGNAL(activated(int)), this, SLOT(Mode()));

Mode();

ModeDialog->exec();







}

void ScreenModesEditor :: AddedMode()
{
ModeDialog->close();
ModesListBox->insertItem(FormattedMode);
ModesListBox->setSelected(ModesListBox->count() - 1, TRUE);

}

void ScreenModesEditor :: Mode()
{

FormattedMode = NewModeCombo->text(NewModeCombo->currentItem()) + " (" +
                NewRefreshCombo->text(NewRefreshCombo->currentItem()) + ")";


if (ModesListBox->findItem(FormattedMode, Qt::ExactMatch)) { AddOK->setEnabled(FALSE); return; }
if (!ModesListBox->findItem(FormattedMode, Qt::ExactMatch)) { AddOK->setEnabled(TRUE); }


}

void ScreenModesEditor :: StartGTF()
{
GTF = new KProcess;

QString ModeX;
QString ModeY;
QString Refresh;
QString buff;
for (unsigned int a = 0; a < ModesListBox->count(); a++)
{
ModeX = ModesListBox->text(a).section("x", 0, 0);
ModeY = ModesListBox->text(a).section("x", 1, 1).section(" (", 0, 0);
 if (ModesListBox->text(a).contains(" Hz)") > 0) 
  { Refresh = ModesListBox->text(a).section(" (", 1, 1).section(" Hz)", 0, 0); }
 else
  { Refresh = "60"; }
buff = buff.append("gtf " + ModeX + " " + ModeY + " " + Refresh + " -x | grep Modeline;\n");

}
buff = buff.append("rm /tmp/Modeline.sh");
QFile *f = new QFile("/tmp/Modeline.sh");
f->open(IO_WriteOnly);
f->writeBlock(buff, buff.length());
f->flush();
f->close();


GTF->setWorkingDirectory("/tmp");
*GTF << "./Modeline.sh";

connect (GTF, SIGNAL(processExited (KProcess *) ), this, SLOT(ApplyModeLines()));
connect (GTF, SIGNAL(receivedStdout(KProcess *, char *, int) ), this, SLOT(GTFReadLines(KProcess *, char *, int)));

GTF->start(KProcess::NotifyOnExit, KProcess::Stdout);
}

void ScreenModesEditor :: GTFReadLines(KProcess * proc, char * buffer, int buflen)
{
  QString string = QString::fromUtf8( buffer, buflen);

  if (!string.isEmpty())
  {
    ModeLines = ModeLines.append(string.simplifyWhiteSpace() + "\n");

  }

}

void ScreenModesEditor :: ApplyModeLines()
{

int ToEnd = X->CountValues(Xorg::Monitor, SectNum, "Modeline");
for (int a = 0; a <= ToEnd; a++)
  {
   X->RemoveValue(Xorg::Monitor, SectNum, "Modeline");
  }





ToEnd = X->CountValues(Xorg::Monitor, SectNum, "ModeLine");
for (int a = 0; a <= ToEnd; a++)
  {
   X->RemoveValue(Xorg::Monitor, SectNum, "ModeLine");
  }



ToEnd = X->CountValues(Xorg::Monitor, SectNum, "Mode");
for (int a = 0; a <= ToEnd; a++)
  {
   X->RemoveValue(Xorg::Monitor, SectNum, "Mode");
  }

X->AppendLine(Xorg::Monitor, SectNum, ModeLines.replace("Modeline", "ModeLine"));

QString num;
QString buf;
if (RefreshRatesGroup->isChecked())
  {

     buf = "";
     num = "";

   num = num.setNum(HSyncFrom->value(), 10);
   buf = num + ".0 - ";
   num = num.setNum(HSyncTo->value(), 10);
   buf = buf.append(num + ".0\n");
   X->WriteLineBreakValue(Xorg::Monitor, SectNum, "HorizSync", buf);

     buf = "";
     num = "";

   num = num.setNum(VertRefFrom->value(), 10);
   buf = num + ".0 - ";
   num = num.setNum(VertRefTo->value(), 10);
   buf = buf.append(num + ".0\n");
   X->WriteLineBreakValue(Xorg::Monitor, SectNum, "VertRefresh", buf);
  }
else
  {
   X->RemoveValue(Xorg::Monitor, SectNum, "HorizSync");
   X->RemoveValue(Xorg::Monitor, SectNum, "VertRefresh");
  }



if (DisplaySizeGroup->isChecked())
  {

     buf = "";
     num = "";

   num = num.setNum(DisplayX->value(), 10);
   buf = num + " ";
   num = num.setNum(DisplayY->value(), 10);
   buf = buf.append(num);
   X->WriteLineBreakValue(Xorg::Monitor, SectNum, "DisplaySize", buf);
  }
else
  {
   X->RemoveValue(Xorg::Monitor, SectNum, "DisplaySize");
  }





close();
}

