/***************************************************************************
 *   Copyright (C) 2006 by Tomasz Sałaciński   *
 *   distortion@vp.pl   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

//KDE Includes
#include <kiconloader.h>
#include <kpushbutton.h>
#include <kmessagebox.h>


//QT Includes
#include <qgroupbox.h>
#include <qfile.h>

//kX Generator Includes
#include "MouseWidget.h"
#include "GlobalFunctions.h"
#include "ChangeEntriesDialog.h"
#include "PropertiesDialog.h"




MouseWidget :: MouseWidget(QWidget *Parent, Xorg *Xorg)
    : QWidget( Parent, "Mouse Widget" )
{

X = Xorg;

//Setting  geometry
setGeometry(0, 0, 560, 351);

//Creating pixmap
    KIconLoader *Icons = new KIconLoader();
    QLabel *Pixmap = new QLabel(this);
    Pixmap->setGeometry(422, 10, 128, 128);
    Pixmap->setPixmap(Icons->loadIcon("mouse", KIcon::Desktop, KIcon::SizeEnormous));

//Information Label
   QLabel *InformationLabel = new QLabel(this);
    InformationLabel->setText(Locale(0));
    InformationLabel->setFont(QFont("sans", 19, QFont::Normal, FALSE));
    InformationLabel->setGeometry(10, 10, 400, 25);
//Horizontal Line
   QFrame *Line = new QFrame(this);
    Line->setGeometry(QRect(10, 45, 400, 5));
    Line->setFrameShape( QFrame::HLine );
    Line->setFrameShadow( QFrame::Sunken );
//Layouts Combo Box
   PointerCombo = new KComboBox(this);
    PointerCombo->setGeometry(10, 55, 400, 25);
//Change Name Button
   KPushButton *ChangeNameButton = new KPushButton(this);
    ChangeNameButton->setText(Locale(1));
    ChangeNameButton->setGeometry(270, 90, 140, 25);
    ChangeNameButton->setIconSet(Icons->loadIcon("edit", KIcon::Toolbar, KIcon::SizeSmall));
//Advanced settings button
   KPushButton *AdvancedSettingsButton = new KPushButton(this);
    AdvancedSettingsButton->setText(Locale(2));
    AdvancedSettingsButton->setGeometry(10, 313, 140, 25);
    AdvancedSettingsButton->setIconSet(Icons->loadIcon("configure", KIcon::Toolbar, KIcon::SizeSmall));


//Driver label
   QLabel *DriverLabel = new QLabel(this);
    DriverLabel->setText(Locale(3));
    DriverLabel->setGeometry(10, 130, 260, 25);
//Driver combo
   DriverCombo = new KComboBox(this);
    DriverCombo->setGeometry(10, 155, 260, 25);
//Device label
   DeviceLabel = new QLabel(this);
    DeviceLabel->setText(Locale(4));
    DeviceLabel->setGeometry(10, 190, 260, 25);
//Device URL
   URL = new KURLRequester(this);
    URL->setGeometry(10, 215, 260, 25);
    URL->setURL("/dev/input/mice");
//No device entry
   NoDevice = new QCheckBox(this);
    NoDevice->setGeometry(10, 245, 260, 25);
    NoDevice->setText(Locale(6));

//Group Box
   QGroupBox *Group = new QGroupBox(this);
    Group->setGeometry(280, 140, 280, 198);
    Group->setTitle(Locale(5));
//Driver info
   DriverInfoLabel = new QLabel(Group);
    DriverInfoLabel->setGeometry(10, 20, 260, 168);
    DriverInfoLabel->setAlignment(QLabel::WordBreak | QLabel::AlignTop);



//Checking available input drivers

QString PathToInputDrivers = X->GetProperty(Xorg::PathToInputDrv);

if (QFile::exists(PathToInputDrivers + "acecad_drv.so")) { DriverCombo->insertItem("acecad"); }
if (QFile::exists(PathToInputDrivers + "aiptek_drv.so")) { DriverCombo->insertItem("aiptek"); }
if (QFile::exists(PathToInputDrivers + "calcomp_drv.so")) { DriverCombo->insertItem("calcomp"); }
if (QFile::exists(PathToInputDrivers + "citron_drv.so")) { DriverCombo->insertItem("citron"); }
if (QFile::exists(PathToInputDrivers + "digitaledge_drv.so")) { DriverCombo->insertItem("digitaledge"); }
if (QFile::exists(PathToInputDrivers + "dmc_drv.so")) { DriverCombo->insertItem("dmc"); }
if (QFile::exists(PathToInputDrivers + "dynapro_drv.so")) { DriverCombo->insertItem("dynapro"); }
if (QFile::exists(PathToInputDrivers + "elo2300_drv.so")) { DriverCombo->insertItem("elo2300"); }
if (QFile::exists(PathToInputDrivers + "elographics_drv.so")) { DriverCombo->insertItem("elographics"); }
if (QFile::exists(PathToInputDrivers + "evdev_drv.so")) { DriverCombo->insertItem("evdev"); }
if (QFile::exists(PathToInputDrivers + "fpit_drv.so")) { DriverCombo->insertItem("fpit"); }
if (QFile::exists(PathToInputDrivers + "hyperpen_drv.so")) { DriverCombo->insertItem("hyperpen"); }
if (QFile::exists(PathToInputDrivers + "joystick_drv.so")) { DriverCombo->insertItem("joystick"); }
if (QFile::exists(PathToInputDrivers + "js_x_drv.so")) { DriverCombo->insertItem("js_x"); }
if (QFile::exists(PathToInputDrivers + "magellan_drv.so")) { DriverCombo->insertItem("magellan"); }
if (QFile::exists(PathToInputDrivers + "magictouch_drv.so")) { DriverCombo->insertItem("magictouch"); }
if (QFile::exists(PathToInputDrivers + "microtouch_drv.so")) { DriverCombo->insertItem("microtouch"); }
if (QFile::exists(PathToInputDrivers + "mouse_drv.so")) { DriverCombo->insertItem("mouse"); }
if (QFile::exists(PathToInputDrivers + "mutouch_drv.so")) { DriverCombo->insertItem("mutouch"); }
if (QFile::exists(PathToInputDrivers + "palmax_drv.so")) { DriverCombo->insertItem("palmax"); }
if (QFile::exists(PathToInputDrivers + "penmount_drv.so")) { DriverCombo->insertItem("penmount"); }
if (QFile::exists(PathToInputDrivers + "spaceorb_drv.so")) { DriverCombo->insertItem("spaceorb"); }
if (QFile::exists(PathToInputDrivers + "summa_drv.so")) { DriverCombo->insertItem("summa"); }
if (QFile::exists(PathToInputDrivers + "synaptics_drv.o")) { DriverCombo->insertItem("synaptics"); }
if (QFile::exists(PathToInputDrivers + "ur98_drv.so")) { DriverCombo->insertItem("ur98"); }
if (QFile::exists(PathToInputDrivers + "void_drv.so")) { DriverCombo->insertItem("void"); }
if (QFile::exists(PathToInputDrivers + "wacom_drv.so")) { DriverCombo->insertItem("wacom"); }








//Connecting



connect (DriverCombo, SIGNAL(activated(int)), this, SLOT(ShowDriverDescription()));
connect (DriverCombo, SIGNAL(activated(int)), this, SLOT(SaveDriver()));
connect (NoDevice, SIGNAL(stateChanged(int)), this, SLOT(NoDeviceCheckBoxStateChanged()));
connect (PointerCombo, SIGNAL(activated(int)), this, SLOT(Init()));
connect (ChangeNameButton, SIGNAL(clicked()), this, SLOT(ChangeEntries()));
connect (AdvancedSettingsButton, SIGNAL(clicked()), this, SLOT(AdvancedSettings()));
connect (URL, SIGNAL(textChanged(const QString&)), this, SLOT(SaveDeviceURL()));
   RefreshPointerCombo();
   Init();

}

void MouseWidget :: ShowDriverDescription()
{
GlobalFunctions Global;
DriverInfoLabel->setText(Global.GetInputDescription(DriverCombo->text(DriverCombo->currentItem())));
}

void MouseWidget :: NoDeviceCheckBoxStateChanged()
{
if (!NoDevice->isChecked()) 
 {
  URL->setEnabled(TRUE);
  DeviceLabel->setEnabled(TRUE);
  if (URL->url() != "") { X->WriteOption(Xorg::InputDevice, X->PointerTranslate(PointerCombo->currentItem() + 1), "Device", URL->url()); }
 }


if (NoDevice->isChecked())
 {
  URL->setEnabled(FALSE); 
  DeviceLabel->setEnabled(FALSE);
  X->RemoveOption(Xorg::InputDevice, X->PointerTranslate(PointerCombo->currentItem() + 1), "Device");
}
}

void MouseWidget :: RefreshPointerCombo()
{
   PointerCombo->clear();
   for (int a = 1; a <= X->CountSections(Xorg::InputDevice); a++)
    {
     if (!X->isKeyboard(a)) { PointerCombo->insertItem(X->GetValue(Xorg::InputDevice, a, "Identifier", 1)); }
    }
}

void MouseWidget :: Init()
{
QString CurrentDriver = X->GetValue(Xorg::InputDevice, X->PointerTranslate(PointerCombo->currentItem() + 1), "Driver", 1);

  for (int a = 0; a < DriverCombo->count(); a++)
   {
    if (DriverCombo->text(a) == CurrentDriver) 
     {
      QString Device =  X->GetOption(Xorg::InputDevice, X->PointerTranslate(PointerCombo->currentItem() + 1), "Device");
       if (Device == "")
        { NoDevice->setChecked(TRUE); }
        else
        { NoDevice->setChecked(FALSE); URL->setURL(Device); }
      DriverCombo->setCurrentItem(a);
      ShowDriverDescription(); 
      return; 
     }
   }

KMessageBox::error (this, Locale(7).arg(CurrentDriver), Locale(8));





}

void MouseWidget :: SaveDriver()
{
X->ClearOptions(Xorg::InputDevice, X->PointerTranslate(PointerCombo->currentItem() + 1));
X->WriteValue(Xorg::InputDevice, X->PointerTranslate(PointerCombo->currentItem() + 1), "Driver", DriverCombo->text(DriverCombo->currentItem()));
}

void MouseWidget :: SaveDeviceURL()
{
X->WriteOption(Xorg::InputDevice, X->PointerTranslate(PointerCombo->currentItem() + 1), "Device", URL->url());
}

void MouseWidget :: ChangeEntries()
{
ChangeEntriesDialog *Change = new ChangeEntriesDialog(this, X, ChangeEntriesDialog::Pointer);
Change->exec();
RefreshPointerCombo();
Init();
}

void MouseWidget :: AdvancedSettings()
{
PropertiesDialog *Input = new PropertiesDialog();

QString Driver = DriverCombo->text(DriverCombo->currentItem());

if (Driver == "mouse") { Input->SetOptions_MOUSE(this, X, X->PointerTranslate(PointerCombo->currentItem() + 1)); return; }
if (Driver == "wacom") { Input->SetOptions_WACOM(this, X, X->PointerTranslate(PointerCombo->currentItem() + 1)); return; }
//if (Driver == "synaptics") { Input->SetOptions_SYNAPTICS(this, X, X->PointerTranslate(PointerCombo->currentItem() + 1)); return; }

KMessageBox::error(this, Locale(9).arg(Driver), Locale(8));
return;

}
