/***************************************************************************
 *   Copyright (C) 2006 by Tomasz Sałaciński   *
 *   distortion@vp.pl   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

//KDE Includes
#include <kiconloader.h>
#include <kpushbutton.h>

//QT Includes
#include <qlabel.h>
#include <qfile.h>

//kX Generator Includes
#include "KeyboardWidget.h"
#include "ChangeEntriesDialog.h"

KeyboardWidget :: KeyboardWidget(QWidget *Parent, Xorg *Xorg)
    : QWidget( Parent, "Mouse Widget" )
{

X = Xorg;
//Setting  geometry
setGeometry(0, 0, 560, 351);

//Creating pixmap
    KIconLoader *Icons = new KIconLoader();
    QLabel *Pixmap = new QLabel(this);
    Pixmap->setGeometry(422, 10, 128, 128);
    Pixmap->setPixmap(Icons->loadIcon("keyboard", KIcon::Desktop, KIcon::SizeEnormous));

//Information Label
   QLabel *InformationLabel = new QLabel(this);
    InformationLabel->setText(Locale(0));
    InformationLabel->setFont(QFont("sans", 19, QFont::Normal, FALSE));
    InformationLabel->setGeometry(10, 10, 400, 30);
//Horizontal Line
   QFrame *Line = new QFrame(this);
    Line->setGeometry(QRect(10, 45, 400, 5));
    Line->setFrameShape( QFrame::HLine );
    Line->setFrameShadow( QFrame::Sunken );
//Layouts Combo Box
   KeyboardCombo = new KComboBox(this);
    KeyboardCombo->setGeometry(10, 55, 400, 25);
//Change Name Button
   KPushButton *ChangeNameButton = new KPushButton(this);
    ChangeNameButton->setText(Locale(1));
    ChangeNameButton->setGeometry(270, 90, 140, 25);
    ChangeNameButton->setIconSet(Icons->loadIcon("edit", KIcon::Toolbar, KIcon::SizeSmall));
//Driver label
   QLabel *DriverLabel = new QLabel(this);
    DriverLabel->setText(Locale(2));
    DriverLabel->setGeometry(10, 130, 260, 25);
//Driver combo
   DriverCombo = new KComboBox(this);
    DriverCombo->setGeometry(10, 155, 260, 25);
//Layout label
   QLabel *LayoutLabel = new QLabel(this);
    LayoutLabel->setText(Locale(3));
    LayoutLabel->setGeometry(10, 185, 260, 25);
//Layout Combo
   LayoutCombo = new KComboBox(this);
    LayoutCombo->setGeometry(10, 210, 260, 25);
//Model Label
   QLabel *ModelLabel = new QLabel(this);
   ModelLabel->setGeometry(300, 185, 260, 25);
   ModelLabel->setText(Locale(4));
//Model Combo
   ModelCombo = new KComboBox(this);
   ModelCombo->setGeometry(300, 210, 260, 25);

//Device label
   DeviceLabel = new QLabel(this);
   DeviceLabel->setGeometry(300, 245, 260, 25);
   DeviceLabel->setText(Locale(5));
//Device URL Requester
   URL = new KURLRequester(this);
   URL->setGeometry(300, 270, 260, 25);
   URL->setURL("/dev/keyboard");
//No Device Checkbox
   NoDevice = new QCheckBox(this);
   NoDevice->setGeometry(300, 295, 260, 25);
   NoDevice->setText(Locale(10));

//Protocol Label
   QLabel *ProtocolLabel = new QLabel(this);
   ProtocolLabel->setGeometry(300, 130, 290, 25);
   ProtocolLabel->setText(Locale(6));
//Protocol Combo
   ProtocolCombo = new KComboBox(this);
   ProtocolCombo->setGeometry(300, 155, 260, 25);
//Auto Repeat group box
   AutoRepeatGroup = new QGroupBox(this);
   AutoRepeatGroup->setGeometry(10, 250, 260, 80);
   AutoRepeatGroup->setTitle(Locale(7));
   AutoRepeatGroup->setCheckable(TRUE);
   AutoRepeatGroup->setChecked(FALSE);
//Delay Rate Checkbox
   QLabel *DelayRateLabel = new QLabel(AutoRepeatGroup);
   DelayRateLabel->setGeometry(10, 20, 200, 25);
   DelayRateLabel->setText(Locale(8));
//Delay spinbox
   DelaySpin = new KIntSpinBox(AutoRepeatGroup);
   DelaySpin->setGeometry(190, 20, 60, 25);
   DelaySpin->setMaxValue(10000);
//Repeat Rate Checkbox
   QLabel *RepeatRateLabel = new QLabel(AutoRepeatGroup);
   RepeatRateLabel->setGeometry(10, 45, 200, 25);
   RepeatRateLabel->setText(Locale(9));
//Repeat spinbox
   RepeatSpin = new KIntSpinBox(AutoRepeatGroup);
   RepeatSpin->setGeometry(190, 45, 60, 25);
   RepeatSpin->setMaxValue(10000);



//Filling driver combo
   QString PathToInputDrivers = X->GetProperty(Xorg::PathToInputDrv);
   if (QFile::exists(PathToInputDrivers + "keyboard_drv.so")) { DriverCombo->insertItem("keyboard"); }
   if (QFile::exists(PathToInputDrivers + "kbd_drv.so")) { DriverCombo->insertItem("kbd"); }



//Putting keyboard layouts
   for (int a = 999; a <= 1050; a++)
    {
     LayoutCombo->insertItem(Locale(a));
    }

//Filling model combo
   for (int a = 2000; a <= 2006; a++)
    {
     ModelCombo->insertItem(Locale(a));
    }

//Filling protocol combo
   for (int a = 2010; a <= 2011; a++)
    {
     ProtocolCombo->insertItem(Locale(a));
    }
URLLine = URL->lineEdit();

connect (NoDevice, SIGNAL(stateChanged(int)), this, SLOT(NoDeviceCheckBoxStateChanged()));
connect (KeyboardCombo, SIGNAL(activated(int)), this, SLOT(Init()));
connect (LayoutCombo, SIGNAL(activated(int)), this, SLOT(SaveLayout()));
connect (DriverCombo, SIGNAL(activated(int)), this, SLOT(SaveDriver()));
connect (ProtocolCombo, SIGNAL(activated(int)), this, SLOT(SaveProtocol()));
connect (ModelCombo, SIGNAL(activated(int)), this, SLOT(SaveModel()));
connect (URLLine, SIGNAL(textChanged(const QString&)), this, SLOT(SaveDeviceURL()));
connect (AutoRepeatGroup, SIGNAL(toggled(bool)), this, SLOT(AutoRepeatGroupToggled()));
connect (DelaySpin, SIGNAL(valueChanged(int)), this, SLOT(AutoRepeatSave()));
connect (RepeatSpin, SIGNAL(valueChanged(int)), this, SLOT(AutoRepeatSave()));
connect (ChangeNameButton, SIGNAL(clicked()), this, SLOT(ChangeEntries()));


RefreshKeyboardCombo();
Init();
}

void KeyboardWidget :: RefreshKeyboardCombo()
{
   KeyboardCombo->clear();
   for (int a = 0; a <= X->CountSections(Xorg::InputDevice); a++)
    {
     if (X->isKeyboard(a)) { KeyboardCombo->insertItem(X->GetValue(Xorg::InputDevice, a, "Identifier", 1)); }
    }
}

void KeyboardWidget :: Init()
{

QString CurrentDriver = X->GetValue(Xorg::InputDevice, X->KeyboardTranslate(KeyboardCombo->currentItem() + 1), "Driver", 1);

   for (int a = 0; a < DriverCombo->count(); a++)
    {
     if (DriverCombo->text(a) == CurrentDriver) { DriverCombo->setCurrentItem(a); break; }
    }



LayoutCombo->setCurrentItem(X->LayoutTranslate(X->GetOption(Xorg::InputDevice, X->KeyboardTranslate(KeyboardCombo->currentItem() + 1), "XkbLayout")));


ModelCombo->setCurrentItem(X->ModelTranslate(X->GetOption(Xorg::InputDevice, X->KeyboardTranslate(KeyboardCombo->currentItem() + 1), "XkbModel")));


ProtocolCombo->setCurrentItem(X->ProtocolTranslate(X->GetOption(Xorg::InputDevice, X->KeyboardTranslate(KeyboardCombo->currentItem() + 1), "Protocol")));


QString Device =  X->GetOption(Xorg::InputDevice, X->KeyboardTranslate(KeyboardCombo->currentItem() + 1), "Device");
       if (Device == "")
        { NoDevice->setChecked(TRUE); }
        else
        { NoDevice->setChecked(FALSE); URL->setURL(Device); }

QString AutoRepeat = X->GetOption(Xorg::InputDevice, X->KeyboardTranslate(KeyboardCombo->currentItem() + 1), "AutoRepeat");
if (AutoRepeat != "")
 {
  int Delay = 0, Repeat = 0;
  bool OK;
  Delay = AutoRepeat.section(" ", 0, 0).toInt(&OK, 10);
  Repeat = AutoRepeat.section(" ", 1, 1).toInt(&OK, 10);
  AutoRepeatGroup->setChecked(TRUE);
  DelaySpin->setValue(Delay);
  RepeatSpin->setValue(Repeat);
 }
else
 {
  DelaySpin->setValue(0);
  RepeatSpin->setValue(0);
  AutoRepeatGroup->setChecked(FALSE);

 }


}

void KeyboardWidget :: NoDeviceCheckBoxStateChanged()
{
if (!NoDevice->isChecked()) 
 {
  URL->setEnabled(TRUE);
  DeviceLabel->setEnabled(TRUE); 
  URLLine->setText("/dev/keyboard");
  X->WriteOption(Xorg::InputDevice, X->KeyboardTranslate(KeyboardCombo->currentItem() + 1), "Device", URLLine->text());
 }


if (NoDevice->isChecked())
 {
  URL->setEnabled(FALSE); 
  DeviceLabel->setEnabled(FALSE);
  URLLine->setText(QString::null);
  X->RemoveOption(Xorg::InputDevice, X->KeyboardTranslate(KeyboardCombo->currentItem() + 1), "Device");
}


}

void KeyboardWidget :: SaveDeviceURL()
{
X->WriteOption(Xorg::InputDevice, X->KeyboardTranslate(KeyboardCombo->currentItem() + 1), "Device", URLLine->text());
}

void KeyboardWidget :: SaveLayout()
{
X->WriteOption(Xorg::InputDevice, X->KeyboardTranslate(KeyboardCombo->currentItem() + 1), "XkbLayout", X->LayoutTranslate(LayoutCombo->currentItem()));

}

void KeyboardWidget :: SaveDriver()
{
X->WriteValue(Xorg::InputDevice, X->KeyboardTranslate(KeyboardCombo->currentItem() + 1), "Driver", DriverCombo->text(DriverCombo->currentItem()));
}

void KeyboardWidget :: SaveProtocol()
{
X->WriteOption(Xorg::InputDevice, X->KeyboardTranslate(KeyboardCombo->currentItem() + 1), "Protocol", X->ProtocolTranslate(ProtocolCombo->currentItem()));
}

void KeyboardWidget :: SaveModel()
{
X->WriteOption(Xorg::InputDevice, X->KeyboardTranslate(KeyboardCombo->currentItem() + 1), "XkbModel", X->ModelTranslate(ModelCombo->currentItem()));
}

void KeyboardWidget :: AutoRepeatGroupToggled()
{
if (AutoRepeatGroup->isChecked())
  {
   DelaySpin->setValue(500);
   RepeatSpin->setValue(30);
  }
else
  {
   DelaySpin->setValue(0);
   RepeatSpin->setValue(0);
   X->RemoveOption(Xorg::InputDevice, X->KeyboardTranslate(KeyboardCombo->currentItem() + 1), "AutoRepeat");
  }


}

void KeyboardWidget :: AutoRepeatSave()
{
QString Num = "";
QString ToSave = "";

Num = Num.setNum(DelaySpin->value(), 10);
ToSave = ToSave.append(Num);
ToSave = ToSave.append(" ");
Num = Num.setNum(RepeatSpin->value(), 10);
ToSave = ToSave.append(Num);
X->WriteOption(Xorg::InputDevice, X->KeyboardTranslate(KeyboardCombo->currentItem() + 1), "AutoRepeat", ToSave);
}

void KeyboardWidget :: ChangeEntries()
{
ChangeEntriesDialog *Change = new ChangeEntriesDialog(this, X, ChangeEntriesDialog::Keyboard);
Change->exec();
RefreshKeyboardCombo();
Init();
}
