/***************************************************************************
 *   Copyright (C) 2004 by Stefano                                         *
 *   stefano@xiaprojects.com                                               *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef XEPLUGIN_GEPILLOW_H
#define XEPLUGIN_GEPILLOW_H

#include <qwidget.h>

#include <qpixmap.h>
#include <qimage.h>

#include <kwin.h>


class XSConfigurations;
class XGDocker;
class KRootPixmap;
class KWinModule;


/**
@author Stefano
*/
class XEPlugin_GEPillow : public QWidget
{
Q_OBJECT
public:
    XEPlugin_GEPillow(QWidget *parent = 0, const char *name = 0);

    ~XEPlugin_GEPillow();
    void paintEvent( QPaintEvent *e);
    void setUnShadowed();
protected:
	class			QTimer *_timerHide;
	QPixmap			paintBuffer;
	KWin::WindowInfo	*info( WId win );
	XSConfigurations 	*ActiveConfiguration;
	XGDocker		*xGDocker;
	QPixmap			pixmapBackground;
	KRootPixmap		*KDesktopBackground;
	int			NegativeX;
	QRect rect;
	int l;
	int t;
	int w;
	int h;
	double _alpha;
	int lastX;
	QImage _blendedText;
public slots:
    void show();
    void xSetupParameter(const QString, const QString);
    void xSetup();
    void xRefresh();
    void xStart();
    void xStop();
    void externalDrawPillow(QObject *,int,int);
    void xGetInfo(QStringList &);
    void backgroundUpdated(const QPixmap &);
    void xEventWidgetMoved(int,int,int , int , int,int);
    void hide();
    void hideMe();
};

#endif
