###
### $Rev: 41 $
### $Release: 0.5.1 $
### copyright(c) 2005 kuwata-lab all rights reserved.
###

require 'yaml'

module YamlHelper

   ##
   ## expand tab character to spaces
   ##
   ## ex.
   ##   untabified_str = YamlHelper.untabify(tabbed_str)
   ##
   ## input:: String or IO
   ##
   def self.untabify(input)
      s = ''
      input.each_line do |line|
         s << line.gsub(/([^\t]{8})|([^\t]*)\t/n) { [$+].pack("A8") }
      end
      return s
   end


   ##
   ## create a hash table from list of hash with primary key.
   ##
   ## ex.
   ##   hashlist = [
   ##     { "name"=>"Foo", "gender"=>"M", "age"=>20, },
   ##     { "name"=>"Bar", "gender"=>"F", "age"=>25, },
   ##     { "name"=>"Baz", "gender"=>"M", "age"=>30, },
   ##   ]
   ##   hashtable = YamlHelper.create_hashtable(hashlist, "name")
   ##   p hashtable
   ##       # => { "Foo" => { "name"=>"Foo", "gender"=>"M", "age"=>20, },
   ##              "Bar" => { "name"=>"Bar", "gender"=>"F", "age"=>25, },
   ##              "Baz" => { "name"=>"Baz", "gender"=>"M", "age"=>30, }, }
   ##
   def self.create_hashtable(hashlist, primarykey, flag_duplicate_check=true)
      hashtable = {}
      hashlist.each do |hash|
         key = hash[primarykey]
         unless key
            riase "primary key '#{key}' not found."
         end
         if flag_duplicate_check && hashtable.key?(key)
            raise "primary key '#{key}' duplicated (value '#{hashtable[key]}')"
         end
         hashtable[key] = hash
      end if hashlist
      return hashtable
   end


   ##
   ## get nested value directly.
   ##
   ## ex.
   ##   val = YamlHelper.get_value(obj, ['aaa', 0, 'xxx'])
   ##
   ## This is equal to the following:
   ##   begin
   ##     val = obj['aaa'][0]['xxx']
   ##   rescue NameError
   ##     val = nil
   ##   end
   ##
   def self.get_value(obj, path)
      val = obj
      path.each do |key|
         return nil unless val.is_a?(Hash) || val.is_a?(Array)
         val = val[key]
      end if path
      return val
   end

end

