###
### $Rev: 42 $
### $Release: 0.5.1 $
### copyright(c) 2005 kuwata-lab all rights reserved.
###

require 'date'


module Kwalify
   module Boolean
   end
end
class TrueClass
   include Kwalify::Boolean
end
class FalseClass
   include Kwalify::Boolean
end
#module Boolean; end
#class TrueClass
#   include Boolean
#end
#class FalseClass
#   include Boolean
#end


module Kwalify
   module Text
   end
end
class String
   include Kwalify::Text
end
class Numeric
   include Kwalify::Text
end
#module Text; end
#class String
#   include Text
#end
#class Numeric
#   include Text
#end


module Kwalify
   module Scalar
   end
end
class String
   include Kwalify::Scalar
end
class Numeric
   include Kwalify::Scalar
end
class Date
   include Kwalify::Scalar
end
class Time
   include Kwalify::Scalar
end
class TrueClass
   include Kwalify::Scalar
end
class FalseClass
   include Kwalify::Scalar
end
class NilClass
   include Kwalify::Scalar
end
module Kwalify
   module Text
      include Kwalify::Scalar
   end
end


module Kwalify


   module Types


      DEFAULT_TYPE = "str"           ## use "str" as default of @type

      @@type_table = {
         "seq"       => Array,
         "map"       => Hash,
         "str"       => String,
         #"string"    => String,
         "text"      => Text,
         "int"       => Integer,
         #"integer"   => Integer,
         "float"     => Float,
         "number"    => Numeric,
         #"numeric"   => Numeric,
         "date"      => Date,
         "time"      => Time,
         "timestamp" => Time,
         "bool"      => Boolean,
         #"boolean"   => Boolean,
         #"object"    => Object,
         "any"       => Object,
         "scalar"    => Scalar,
      }

      def self.type_table
         return @@type_table
      end

      def self.type_class(type)
         klass = @@type_table[type]
         #assert_error('type=#{type.inspect}') unless klass
         return klass
      end
      
      def self.get_type_class(type)
         return type_class(type)
      end



      #--
      #def collection_class?(klass)
      #   return klass.is_a?(Array) || klass.is_a?(Hash)
      #end
      #
      #def scalar_class?(klass)
      #   return !klass.is_a?(Array) && !klass.is_a?(Hash) && klass != Object
      #end

      def collection?(val)
         return val.is_a?(Array) || val.is_a?(Hash)
      end

      def scalar?(val)
         return !val.is_a?(Array) && !val.is_a?(Hash) && val.class != Object
      end

      def collection_type?(type)
         return type == 'seq' || type == 'map'
      end

      def scalar_type?(type)
         return type != 'seq' && type != 'map' && type == 'any'
      end

      module_function 'collection?', 'scalar?', 'collection_type?', 'scalar_type?'
   end

   extend Types

end
