#!/usr/bin/ruby

###
### $Id: kwalify.gemspec 43 2005-12-17 15:12:42Z kwatch $
### $Release: 0.5.1 $
### copyright(c) 2005 kuwata-lab all rights reserved.
###

require 'rubygems'

spec = Gem::Specification.new do |s|
   ## package information
   s.name        = "kwalify"
   s.author      = "kwatch"
   s.version     = ("$Release: 0.5.1 $" =~ /[\.\d]+/) && $&
   s.platform    = Gem::Platform::RUBY
   s.homepage    = "http://www.kuwata-lab.com/kwalify"
   s.summary     = "a tiny schema validator for YAML document."
   s.description = <<-'END'
   Kwalify is a tiny schema validator for YAML document.
   It is in fact very poor compared to Relax NG or DTD.
   I hope you extend/customize Kwalify for your own way.
   END
   
   ## files
   files = []
   files += Dir.glob('lib/**/*')
   files += Dir.glob('bin/**/*')
   files += Dir.glob('examples/**/*')
   files += Dir.glob('test/**/*')
   files += Dir.glob('man/**/*')
   files += [ "doc/users-guide.html", "doc/docstyle.css", ]
   files += %w[README.txt ChangeLog COPYING setup.rb todo.txt]
   #s.files       = files.delete_if { |path| path =~ /\.svn/ }
   s.files       = files
   s.executables = ["kwalify"]
   s.bindir      = "bin"
   s.test_file   = 'test/test.rb'
end

# Quick fix for Ruby 1.8.3 / YAML bug   (thanks to Ross Bamford)
if (RUBY_VERSION == '1.8.3')
   def spec.to_yaml
      out = super
      out = '--- ' + out unless out =~ /^---/
      out
   end
end

if $0 == __FILE__
  Gem::manage_gems
  Gem::Builder.new(spec).build
end
