#ifndef _KVI_SCRIPT_OBJECTCLASSDEFINITION_H_INCLUDED_
#define _KVI_SCRIPT_OBJECTCLASSDEFINITION_H_INCLUDED_

// =============================================================================
//
//   This file is part of the KVIrc IRC client distribution
//   Copyright (C) 1999-2000 Szymon Stefanek (stefanek@tin.it)
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc, 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//
// =============================================================================

#include <qasciidict.h>
#include <qptrlist.h>

#include "kvi_string.h"

// Forwards...
class KviWindow;
class KviScriptObject;

// Event handler structure... each object has a list of these structs
typedef struct
{
	KviStr szName;
	KviStr szBuffer;
} KviScriptEventStruct;

// An object function callback
typedef int (KviScriptObject::*scriptObjectFunction)(QPtrList<KviStr> *, KviStr &);

// Function data struct: the class definition has a list of these structs
typedef struct KviScriptObjectFunctionStruct
{
	scriptObjectFunction fncHandler;
	int                  flags;
	KviStr               szBuffer;
};

/**
 * A definition of a class (class descriptor)
 */
class KviScriptObjectClassDefinition
{
public:
	KviScriptObjectClassDefinition(const char *name, KviScriptObjectClassDefinition *inheritedClass, bool bBuiltin);
	~KviScriptObjectClassDefinition();
protected:
	QAsciiDict<KviScriptObjectFunctionStruct> *m_pFunctionDict;   // Class functions
	KviStr                                     m_szClassName;     // Class name
	KviScriptObjectClassDefinition            *m_pInheritedClass; // The nearest inherited class
	QPtrList<KviScriptObjectClassDefinition>  *m_pChildClasses;   // Child classes list
	QPtrList<KviScriptEventStruct>            *m_pEventList;      // List of default event handlers
	bool                                       m_bBuiltin;        // Is this a built-in class?
public:
	// Global class data
	QAsciiDict<KviScriptObjectFunctionStruct> *functionDict();
	QPtrList<KviScriptEventStruct>            *eventList();
	KviScriptObjectClassDefinition            *inheritedClass();
	QPtrList<KviScriptObjectClassDefinition>  *childClasses();

	const char *getClass();
	bool       isBuiltin();
	// Lookup utils
	KviScriptObjectClassDefinition            *lookupChildClassDefinition(const char *szClass);
	KviScriptObjectClassDefinition            *lookupParentClassDefinition(const char *szClass);
	KviScriptObjectFunctionStruct             *lookupFunction(const char *szFncName);
	// Management
	void addChildClassDefinition(KviScriptObjectClassDefinition *d);
	void addDefaultEvent(KviScriptEventStruct *);
	void addFunction(const char *fncName, const char *buffer, bool bBuiltin = false);
	void addBuiltinFunction(const char *fncName, scriptObjectFunction fncHandler);
	void dump(KviWindow *, const char *margin = 0);
};

// Flags for the functions
#define KVI_SCRIPTOBJECTFUNCTION_FLAG_INHERITED 1
#define KVI_SCRIPTOBJECTFUNCTION_FLAG_BUILTIN   2
#define KVI_SCRIPTOBJECTFUNCTION_FLAG_OVERRIDE  4

#endif // _KVI_SCRIPT_OBJECTCLASSDEFINITION_H_INCLUDED_
