// =============================================================================
//
//      --- kvi_options_interface.cpp ---
//
//   This file is part of the KVIrc IRC client distribution
//   Copyright (C) 1999-2000 Szymon Stefanek (stefanek@tin.it)
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//
// =============================================================================

#define _KVI_DEBUG_CHECK_RANGE_
#define _KVI_DEBUG_CLASS_NAME_ "KviOptionsInterface"

#include <qlayout.h>

#include "kvi_app.h"
#include "kvi_boolselector.h"
#include "kvi_locale.h"
#include "kvi_options.h"
#include "kvi_options_interface.h"
#include "kvi_stringselector.h"

/*
	@quickhelp: KviOptionsInterface
	@widget: Miscellaneous interface options
*/
KviOptionsInterface::KviOptionsInterface(QWidget *parent)
	: KviOptionsWidget(parent, KVI_GENERAL_OPTIONS_WIDGET_ID_INTERFACEMISC)
{
	QGridLayout *g = new QGridLayout(
		this, 13, 1, KVI_GENERAL_OPTIONS_GRIDLAYOUT_BORDER, KVI_GENERAL_OPTIONS_GRIDLAYOUT_SPACE
	);

	KviStringSelector *s = new KviStringSelector(this,
		_i18n_("Main window title:"), &(g_pOptions->m_szCaptionMessage), 180
	);
	g->addWidget(s, 0, 0);

	QFrame *f = new QFrame(this);
	f->setFrameStyle(QFrame::HLine | QFrame::Sunken);
	g->addWidget(f, 1, 0);

	KviBoolSelector *b = new KviBoolSelector(this,
		_i18n_("Save hacked frame geometry"), &(g_pOptions->m_bUseHackedFrameGeometry)
	);
	g->addWidget(b, 2, 0);
	b = new KviBoolSelector(this,
		_i18n_("'Hide/Show' hack for brain-damaged windowmanager"), &(g_pOptions->m_bDialogShowHackForBrainDamagedWM)
	);
	g->addWidget(b, 3, 0);

	KviBoolSelector *b1 = new KviBoolSelector(this,
		_i18n_("Windows remember properties"), &(g_pOptions->m_bWindowsRememberProperties)
	);
	g->addWidget(b1, 4, 0);
	b = new KviBoolSelector(this,
		_i18n_("Windows remember dock state"),
		&(g_pOptions->m_bWindowsRememberDockState), g_pOptions->m_bWindowsRememberProperties
	);
	g->addWidget(b, 5, 0);
	connect(b1, SIGNAL(toggled(bool)), b, SLOT(setEnabled(bool)));
	b = new KviBoolSelector(this,
		_i18n_("Windows remember maximize state"),
		&(g_pOptions->m_bWindowsRememberMaximizeState), g_pOptions->m_bWindowsRememberProperties
	);
	g->addWidget(b, 6, 0);
	connect(b1, SIGNAL(toggled(bool)), b, SLOT(setEnabled(bool)));

	f = new QFrame(this);
	f->setFrameStyle(QFrame::HLine | QFrame::Sunken);
	g->addWidget(f, 7, 0);

	b = new KviBoolSelector(this, _i18n_("Verbose output mode"), &(g_pOptions->m_bBeVerbose));
	g->addWidget(b, 8, 0);
	b = new KviBoolSelector(this, _i18n_("Automatically disable broken events"), &(g_pOptions->m_bAutoDisableBrokenEvents));
	g->addWidget(b, 9, 0);
	b1 = new KviBoolSelector(this,
		_i18n_("Pedantic parser (halt commands even on non-fatal errors)"), &(g_pOptions->m_bPedanticParser)
	);
	g->addWidget(b1, 10, 0);
	b = new KviBoolSelector(this,
		_i18n_("Avoid parser warnings"), &(g_pOptions->m_bAvoidParserWarnings)
	);
	g->addWidget(b, 11, 0);
	b = new KviBoolSelector(this, _i18n_("Send unknown commands to server"), &(g_pOptions->m_bSendUnknownCommandsToServer));
	g->addWidget(b, 12, 0);

	// Trick
	f = new QFrame(this);
	g->addWidget(f, 13, 0);
	g->setRowStretch(13, 1);
}

KviOptionsInterface::~KviOptionsInterface()
{
	// Nothing here
}

void KviOptionsInterface::commitChanges()
{
	KviBoolSelector::commitAll(this);
	KviStringSelector::commitAll(this);
	g_pApp->updateAllFrameCaptions();
}

#include "m_kvi_options_interface.moc"
