#ifndef _KVI_MAINTOOLBAR_H_INCLUDED_
#define _KVI_MAINTOOLBAR_H_INCLUDED_

// =============================================================================
//
//   This file is part of the KVIrc IRC client distribution
//   Copyright (C) 1999-2000 Szymon Stefanek (stefanek@tin.it)
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc, 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//
// =============================================================================

#include "kvi_toolbar.h"

class KviFrame;

class KviMainToolBar : public KviToolBar
{
	Q_OBJECT
public:
	KviMainToolBar(KviFrame *parent);
	~KviMainToolBar();

	void setConnectButtonState(int);
	void setDirButtonState(bool);
	void setHelpButtonState(bool);
private:
	int m_connectAbortButton;
	int m_connectButton;
	int m_dirBrowserButton;
	int m_disconnectButton;
	int m_generalOptionsButton;
	int m_helpBrowserButton;
	int m_regUsersButton;
	int m_scriptCenterButton;
	int m_serverOptionsButton;
	int m_userOptionsButton;
	int m_whatIsThisButton;
};

#define KVI_CONNECT_DISCONNECTED 0
#define KVI_CONNECT_CONNECTING   1
#define KVI_CONNECT_CONNECTED    2

static const QString tb_configUser("user_config.png");
static const QString tb_configServer("server_config.png");
static const QString tb_configGeneral("general_config.png");
static const QString tb_regUsers("users.png");
static const QString tb_scriptCenter("scriptcenter.png");
static const QString tb_dirBrowser("dirbrowser.png");
static const QString tb_helpBrowser("helpbrowser.png");
static const QString tb_whatIsThis("contexthelp.png");

#endif // _KVI_MAINTOOLBAR_H_INCLUDED_
