// =============================================================================
//
//      --- kvi_dcc_sendfiledialog.cpp ---
//
//   This file is part of the KVIrc IRC client distribution
//   Copyright (C) 1999-2000 Szymon Stefanek (stefanek@tin.it)
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc, 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//
// =============================================================================

#define _KVI_DEBUG_CHECK_RANGE_
#define _KVI_DEBUG_CLASS_NAME_ "KviDccSendFileDialog"

#include "kvi_application.h"
#include "kvi_dcc_manager.h"
#include "kvi_dcc_sendfiledialog.h"
#include "kvi_dcc_send_event.h"
#include "kvi_frame.h"
#include "kvi_locale.h"

// TODO: Multiple files will not work here
KviDccSendFileDialog::KviDccSendFileDialog(KviFrame *parent, KviDccSendRequestData *data, bool bOutgoingDcc)
	: KviFileDialog(QString::null, QString::null, parent, 0, false)
{
	m_pData = data;
	if( bOutgoingDcc ) {
		setMode(KviFileDialog::ExistingOnly);
		KviStr tmp(KviStr::Format, _i18n_("Select File to Send to %s"), data->nick.ptr());
		setCaption(tmp.ptr());
	} else {
		data->filePath.ensureLastCharIs('/');
		data->filePath.append(data->fileName);
		setMode(KviFileDialog::File);
		setCaption(_i18n_("Save DCC Incoming File"));
		setSelection(_CHAR_2_QSTRING(data->filePath.ptr()));
	}
}

KviDccSendFileDialog::~KviDccSendFileDialog()
{
	if( m_pData ) {
		delete m_pData;
		m_pData = 0;
	}
}

void KviDccSendFileDialog::done(int result)
{
	KviFileDialog::done(result);
	if( !m_pData ) return; // Sometimes we're inside done() twice... why??

	if( result == Accepted ) {
		m_pData->filePath = selectedFile();
		if( m_pData->filePath.hasData() ) {
			KviDccSendEvent *ev = new KviDccSendEvent(m_pData);
			KviApplication::postEvent(m_pData->parent, ev);
			m_pData = 0;
		}
	}
}

#include "m_kvi_dcc_sendfiledialog.moc"
