using System;
using Gtk;
using GtkExtra;

namespace Kurush
{

public class TrialBalanceFrame : ReportFrame
{
    public TrialBalanceFrame (FrameManager owner) : base (owner)
    {
        Title = "Trial Balance";
        MenuVisible = false;

        Refresh ();
    }

    public override void Refresh ()
    {
        Owner.DataBase.CalcDatedBalances (endingDate);

        Report report = new Report (Kurush.PrConfig, 5, 10.0);
        report.ShowColumnTitles = true;
        report.Columns[0].Title = "Account";
        report.Columns[1].Title = "Debit";
        report.Columns[1].Width = 3;
        report.Columns[1].Align = Report.Alignment.Right;
        report.Columns[2].Title = "Credit";
        report.Columns[2].Width = 3;
        report.Columns[2].Align = Report.Alignment.Right;
        report.Columns[3].Title = "Debit Balance";
        report.Columns[3].Width = 3;
        report.Columns[3].Align = Report.Alignment.Right;
        report.Columns[4].Title = "Credit Balance";
        report.Columns[4].Width = 3;
        report.Columns[4].Align = Report.Alignment.Right;
        report.HeaderUser = Owner.DataBase.Title;
        report.HeaderTitle = "Trial Balance";
        report.HeaderDate = Format.Value (endingDate);

        decimal debit = 0;
        decimal credit = 0;
        decimal debitBalance = 0;
        decimal creditBalance = 0;

        report.Open ();

        foreach (Data.Group group in Owner.DataBase.Groups)
        {
            debit += group.DatedDebit;
            credit += group.DatedCredit;
            debitBalance += group.DatedDebitBalance;
            creditBalance += group.DatedCreditBalance;

            report.Add (group.Name.ToUpper(),
                        Format.Value (group.DatedDebit),
                        Format.Value (group.DatedCredit),
                        Format.Value (group.DatedDebitBalance),
                        Format.Value (group.DatedCreditBalance));

            report.AddSpace (1);

            foreach (Data.Account account in group.Children)
            {
                report.Add (account.Name,
                            Format.Value (account.DatedDebit),
                            Format.Value (account.DatedCredit),
                            Format.Value (account.DatedDebitBalance),
                            Format.Value (account.DatedCreditBalance));
            }

            report.AddSpace (1);
        }

        report.Add ("TOTAL",
                    Format.Value (debit),
                    Format.Value (credit),
                    Format.Value (debitBalance),
                    Format.Value (creditBalance));

        report.Close ();

        printPreview.Job = report;
    }

}

}
