using System;
using Gtk;
using GtkExtra;

namespace Kurush
{

public class IncomeStatementFrame : ReportFrame
{
    public IncomeStatementFrame (FrameManager owner) : base (owner)
    {
        Title = "Income Statement";
        MenuVisible = false;
        showBeginningDate = true;

        Refresh ();
    }

    public override void Refresh ()
    {
        Owner.DataBase.CalcDatedBalances (beginningDate, endingDate);

        Report report = new Report (Kurush.PrConfig, 3, 10.0);
        report.Columns[1].Width = 3;
        report.Columns[1].Align = Report.Alignment.Right;
        report.Columns[2].Width = 3;
        report.Columns[2].Align = Report.Alignment.Right;
        report.HeaderUser = Owner.DataBase.Title;
        report.HeaderTitle = "Income Statement";
        report.HeaderDate = Format.Value (beginningDate) + " ~ " +
                            Format.Value (endingDate);

        report.Open ();

        Data.Group group = Owner.DataBase.Groups[(int) Data.AccountType.Income];
        decimal income =  group.DatedBalance;
        report.Add ("INCOME", "", Format.Value (income));
        report.AddSpace (1);
        foreach (Data.Account account in group.Children)
        {
            report.Add (account.Name, Format.Value (account.DatedGroupBalance));
        }
        report.AddSpace (1);

        group = Owner.DataBase.Groups[(int) Data.AccountType.Expense];
        decimal expense =  group.DatedBalance;
        report.Add ("EXPENSE", "", Format.Value (expense));
        report.AddSpace (1);
        foreach (Data.Account account in group.Children)
        {
            report.Add (account.Name, Format.Value (account.DatedGroupBalance));
        }
        report.AddSpace (1);
        report.Add ("PROFIT (LOSS)", "", Format.Value (income - expense));

        report.Close ();

        printPreview.Job = report;
    }


}

}
