/***************************************************************************
 *   Copyright (C) 2004 by Raul Fernandes                                  *
 *   rgfbr@yahoo.com.br                                                    *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#ifndef KTRANSLATOR_PLUGIN_H
#define KTRANSLATOR_PLUGIN_H

#include <qobject.h>

class QWidget;

/**
 * @short Dictionary Plugin Abstract Class
 * @author Raul Fernandes <rgfbr@yahoo.com.br>
 * @version 0.1
 * This is the base class to make dictionary plugins for KTranslator. The dictionary plugins are the
 * code that do the real search of word in dictionaries.
 * When KTranslator wants to translate a word, it calls the search function of each plugin passing the
 * word as argument. The plugin should return the result in this way:
 *
 * <dicName>Dictionary Name</dicName>
 * <headword>Headword</headword>
 * <inflection>Inflections</inflection>
 * <pos>Part of Speech</pos>
 * <definition>Definition of word<link>Link to other words</link></definition>
 * <pos>Part of Speech</pos>
 * <definition>Definition of word<link>Link to other words</link></definition>
 * ...
 * <pos>Part of Speech</pos>
 * <definition>Definition of word<link>Link to other words</link></definition>
 *
 * There are no obrigatory tag, but you should at least return <dicName>, <headword> and one <definition>.
 */


namespace KTranslator {

    class DictionaryPlugin : public QObject
    {

    public:
        DictionaryPlugin(QObject *parent, const char* name=0);
        virtual ~DictionaryPlugin();

        virtual QString search( const QString & )=0;

        bool enabled() { return m_enabled; };
        void setEnabled( bool enable ) { m_enabled = enable; };
        virtual QWidget *confPage()=0;
        virtual void applyConf( QWidget * )=0;
    private:
        bool m_enabled;
    };
};


#endif /* KTRANSLATOR_PLUGIN_H */
