/****************************************************************************
** ui.h extension file, included from the uic-generated form implementation.
**
** If you want to add, delete, or rename functions or slots, use
** Qt Designer to update this file, preserving your code.
**
** You should not define a constructor or destructor in this file.
** Instead, write your code in functions called init() and destroy().
** These will automatically be called by the form's constructor and
** destructor.
*****************************************************************************/


QString DictionaryDialog::dicName()
{
  return nameEdit->text();
}


QString DictionaryDialog::dicPlugin()
{
  int pluginId = pluginCombo->currentItem();
  if( pluginId == 0 ) return "ktranslator_freedict";
  else if( pluginId == 1 ) return "ktranslator_plaintext";
  else if( pluginId == 2 ) return "ktranslator_babylon";
  else if( pluginId == 3 ) return "ktranslator_ktranslator";
  else return "ktranslator_dictd";
}


QString DictionaryDialog::dicFile()
{
  return fileRequester->url();
}


void DictionaryDialog::setDicName( const QString &name )
{
  nameEdit->setText( name );
}


void DictionaryDialog::setDicFile( const QString &file )
{
  fileRequester->setURL( file );
}


void DictionaryDialog::setDicPlugin( const QString &plugin )
{
  int pluginId ;
  if( plugin == "ktranslator_freedict" ) pluginId = 0;
  else if( plugin == "ktranslator_plaintext" ) pluginId = 1;
  else if( plugin == "ktranslator_babylon" ) pluginId = 2;
  else if( plugin == "ktranslator_ktranslator" ) pluginId = 3;
  else pluginId = 3;// "ktranslator_dictd"
  pluginCombo->setCurrentItem( pluginId );
}
