/***************************************************************************
 *   Copyright (C) 2005 by Silpa & Kamesh                                  *
 *   us@avasarala                                                          *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/


#ifndef _KTEMPERATUREWIDGET_H_
#define _KTEMPERATUREWIDGET_H_

#include "ktemperaturewidgetbase.h"
#include <knuminput.h> 
#include <ksystemtray.h>
#include <qfile.h>
#include <qtimer.h>

class KTemperatureWidget : public KTemperatureWidgetBase
{
    Q_OBJECT

public:
    KTemperatureWidget(QWidget* parent = 0, const char* name = 0, WFlags fl = 0 );
    ~KTemperatureWidget();
    void setTrayReference(KSystemTray* systemTrayObject);
    int checkAcpiThermalModule(void);
    /*$PUBLIC_FUNCTIONS$*/

public slots:
    /*$PUBLIC_SLOTS$*/
    virtual void setButton_clicked();
    virtual void cancelButton_clicked();
    void checkTemperature();
    virtual void monitorInterfaceSelect_urlSelected(const QString& selectedInterface);
    void update(void);
    void pause(void);
    void restart(void);
    void about(void);
    void accelaratorHandler(int itemId);
    


protected:
    /*$PROTECTED_FUNCTIONS$*/

protected slots:
    /*$PROTECTED_SLOTS$*/

private:
    int pollIntreval;
    int maxSysTemperature;
    KSystemTray* trayObject;
    float rednessStep;
    QTimer * pollTimer;
    char monitorInterface[512];
    char configFile[512];
};
#define ID_PAUSE	6
#define ID_RESTART	7
#define ID_UPDATE	8
#define ID_ABOUT	9
#endif

