/* This file is part of the KDE project
   Copyright (C) 2004 Nadeem Hasan <nhasan@kde.org>

   This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; see the file COPYING.  If not, write to
   the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.
*/


#ifndef SYNDOCK_H
#define SYNDOCK_H

#include <qpixmap.h>

#include <ksystemtray.h>
#include <kglobalaccel.h>
#include <kaction.h>

#include "syndaemon.h"

class SynDock : public KSystemTray
{
Q_OBJECT

public:
    SynDock( QWidget *parent = NULL , const char *name = NULL );
    ~SynDock();

protected slots:
    /// enables/disables touch pad temporarily depending on m_enableDisableAction
    void toggleEnableDisable();

    /// disables touch pad or tapping when typing begins
    void disableDueToTyping();

    /// restores touch pad mode after typing
    void enableAfterTyping();

    /// opens ksynaptics kcm
    void slotConfigure();

protected:
    typedef enum
    {
        DT_NONE = 0,
        DT_FULL = 1,
        DT_TAPPING = 2
    } DisableType;

    /// Returns if the pad is currently disabled according to the gui
    bool padDisabled() const;

    /// Returns the currently selected smart mode type according to the gui
    SynDock::DisableType smartModeType() const;

    /// tray icons
    QPixmap m_dockPixmapEnabled, m_dockPixmapDisabled;

    // context-menu actions
    KRadioAction *m_disableCompleteAction, *m_disableTappingAction;
    KToggleAction *m_enableDisableAction;

    /// syndaemon thread
    SynDaemon *mSynDaemon;
};

#endif // SYNDOCK_H
