/* This file is part of the KDE project
   Copyright (C) 2004 Nadeem Hasan <nhasan@kde.org>

   This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; see the file COPYING.  If not, write to
   the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.
*/


#ifndef SYNDOCK_H
#define SYNDOCK_H

#include <qpixmap.h>
#include <qstring.h>
#include <qevent.h>

#include <kprocess.h>
#include <ksystemtray.h>
#include <kglobalaccel.h>
#include <kpassivepopup.h>
#include <kaction.h>

class SynDock : public KSystemTray
{
  Q_OBJECT

  public:
    SynDock( QWidget *parent, const char *name );
    ~SynDock();


  protected slots:
    void toggleEnableDisable();
	void toggleDisableType();
	
    void showPopup(const QString & caption, QPixmap & icon);
    
  protected:
    typedef enum 
	{ 
		DT_NONE = 0,
		DT_FULL, 
		DT_TAPPING 
	} DisableType;
	
    QPixmap m_dockPixmapEnabled, m_dockPixmapDisabled;

	// different texts for the KActions
	QString g_enableDisableText_Enabled;
	QString g_enableDisableText_Disabled;
	QString g_disableTypeText_Full;
	QString g_disableTypeText_Tapping;

	// the processes
    KProcess *m_syndaemonProc;
    KProcess *m_synclientProc;

	// our actions
	KAction *m_disableTypeAction;
	KAction *m_enableDisableAction;

	// the global accelerator key
    KGlobalAccel *m_toggle_pad;
    KPassivePopup *m_popup;

	// type of disability
	DisableType m_disableType;

	bool m_disabled;
};

#endif // SYNDOCK_H

