/***************************************************************************
 *   Copyright (C) 2004 Nadeem Hasan <nhasan@kde.org>                      *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#include <qbuttongroup.h>
#include <qcheckbox.h>
#include <qlabel.h>
#include <qslider.h>
#include <qradiobutton.h>

#include <kmessagebox.h>
#include <kcombobox.h>
#include <kdebug.h>
#include <klocale.h>
#include <kprocess.h>

#include "myframe.h"
#include "synconfig.h"
#include "synconfigwidget.h"

SynConfigWidget::SynConfigWidget( QWidget *parent, const char *name )
  : SynConfigWidgetBase( parent, name ),
    m_borderWizard( 0 )
{
  KLocale::setMainCatalogue( "ksynaptics" );

  connect( cmbTapFinger, SIGNAL( activated( int ) ), this, SLOT( tapFingerChanged( int ) ) );
}

void SynConfigWidget::useTappingChanged( bool b )
{
  lblTapTime->setEnabled( b );
  lblShort1->setEnabled( b );
  slTapTime->setEnabled( b );
  lblLong1->setEnabled( b );

  emit changed();
}

void SynConfigWidget::useSmartModeChanged( bool b )
{
  lblDelay->setEnabled( b );
  lblShort2->setEnabled( b );
  slSmartModeDelay->setEnabled( b );
  lblLong2->setEnabled( b );

  emit changed();
}

void SynConfigWidget::useDockingChanged( bool b )
{
  grpSmartMode->setEnabled( b );

  emit changed();
}

void SynConfigWidget::tapFingerChanged( int index )
{
  kdDebug() << "tapFingerChanged" << endl;
  bgTapButton->setButton( finger[index] );

  emit changed();
}

void SynConfigWidget::tapButtonChanged( int id )
{
  finger[cmbTapFinger->currentItem()] = id;

  emit changed();
}

void SynConfigWidget::horizScrollChanged( bool b )
{
  lblSlow1->setEnabled( b );
  slHorizScrollDelta->setEnabled( b );
  lblFast1->setEnabled( b ); 

  emit changed();
}

void SynConfigWidget::vertScrollChanged( bool b )
{
  lblSlow2->setEnabled( b );
  slVertScrollDelta->setEnabled( b );
  lblFast2->setEnabled( b );

  emit changed();
}

void SynConfigWidget::circScrollChanged( bool b )
{
  lblSlow3->setEnabled( b );
  slCircularDelta->setEnabled( b );
  lblFast3->setEnabled( b );
  lblUse->setEnabled( b );
  cmbCircTrigger->setEnabled( b );
  cornerEdgeFrame->setEnabled( b );

  emit changed();
}

void SynConfigWidget::alpsOptionClicked( )
{
    // DONE switch defaults for ALPS/non-ALPS!
    int really = 
        KMessageBox::questionYesNo( 
            this, 
            i18n("This will override the currently set edge borders! Change really?"),
            i18n("Switching Edge Border Defaults"), i18n("Change"), i18n("Do Not Change")
	);

    if ( really == KMessageBox::No )
    {
        // undo the changes!
        cbTreatAsALPS->toggle();
	return;
    }
    
    if ( cbTreatAsALPS->isChecked() )
    {
      QRect edges = QRect( QPoint( 120, 120 ), QPoint( 830, 650 ) );
      SynConfig::setEdges( edges );
      kdDebug() << "use ALPS edges" << endl;
    } 
    else
    {
      QRect edges = QRect( QPoint( 1700, 1700 ), QPoint( 5300, 4200 ) );
      SynConfig::setEdges( edges );
      kdDebug() << "use Synaptics edges" << endl;
    }
    
    emit changed();

    KMessageBox::information(
        this,
	i18n("The new settings have been loaded. Press apply to activate!"),
	i18n("Switching Edge Border Defaults")
    );
}

void SynConfigWidget::widgetModified()
{
  emit changed();
}

void SynConfigWidget::invokeBorderWizard()
{
  if (m_borderWizard)  {
    // we must've canceled before, restart from beginning
    m_borderWizard->showPage( m_borderWizard->page( 0 ) ); 
    kdDebug() << "reuse old wizard..." << endl;
  }
  else {
    m_borderWizard = new AdjBorderWizard();
    connect(m_borderWizard, SIGNAL( changed() ), SLOT( widgetModified() ) );
  }

  m_borderWizard->show();
  kdDebug() << "invoke wizard..." << endl;
}

void SynConfigWidget::load()
{
  // Docking
  generalDockingCB->setChecked( SynConfig::enableDocking() );
  grpSmartMode->setEnabled( SynConfig::enableDocking() );

  // General Tab
  int tpState = SynConfig::enableTouchPad();

  if ( tpState == SynConfig::EnumEnableTouchPad::NoTaps ) tpState = SynConfig::EnumEnableTouchPad::Enabled;
  kdDebug() << tpState << endl;
	  
  bgTouchPadSwitch->setButton( tpState );
  slSensitivity->setValue( SynConfig::sensitivity() );
  cbSmartMode->setChecked( SynConfig::enableSmartMode() );
  slSmartModeDelay->setValue( SynConfig::smartModeDelay() );

  useSmartModeChanged( cbSmartMode->isChecked() );
  cbTreatAsALPS->setChecked( SynConfig::treatAsALPS() );
  
  // Tapping Tab
  cbEnableTapping->setChecked( SynConfig::enableTapping() );
  slTapTime->setValue( SynConfig::tapTime() );
  finger[0] = SynConfig::tapRightTop();
  finger[1] = SynConfig::tapRightBottom();
  finger[2] = SynConfig::tapLeftTop();
  finger[3] = SynConfig::tapLeftBottom();
  finger[4] = SynConfig::tapOneFinger();
  finger[5] = SynConfig::tapTwoFingers();
  finger[6] = SynConfig::tapThreeFingers();

  tapFingerChanged( 0 );
  useTappingChanged( cbEnableTapping->isChecked() );
  cbFastTaps->setChecked( SynConfig::fastTaps() );

  // Scrolling Tab
  cbHorizScrolling->setChecked( SynConfig::enableHorizontalScrolling() );
  slHorizScrollDelta->setValue( SynConfig::horizontalScrollDelta()*-1 );
  cbVertScrolling->setChecked( SynConfig::enableVerticalScrolling() );
  slVertScrollDelta->setValue( SynConfig::verticalScrollDelta()*-1 );
  cbCircScrolling->setChecked( SynConfig::enableCircularScrolling() );
  slCircularDelta->setValue( SynConfig::circularScrollDelta()*-1 );
  cmbCircTrigger->setCurrentItem( SynConfig::circularScrollTrigger() );
  cbEdgeMotion->setChecked( SynConfig::enableEdgeMotion() );
  cbCoasting->setChecked( SynConfig::enableCoasting() );

  horizScrollChanged( cbHorizScrolling->isChecked() );
  vertScrollChanged( cbVertScrolling->isChecked() );
  circScrollChanged( cbCircScrolling->isChecked() );
}

void SynConfigWidget::save()
{
  kdDebug() << "here?" << endl;
  // Docking
  enableDocking( generalDockingCB->isChecked() );
  SynConfig::setEnableDocking( generalDockingCB->isChecked() );

	
  // General Tab
  SynConfig::setEnableTouchPad( bgTouchPadSwitch->selectedId() );
  SynConfig::setSensitivity( slSensitivity->value() );
  SynConfig::setEnableSmartMode( cbSmartMode->isChecked() );
  SynConfig::setSmartModeDelay( slSmartModeDelay->value() );
  SynConfig::setTreatAsALPS( cbTreatAsALPS->isChecked() );

  // Tapping Tab
  SynConfig::setEnableTapping( cbEnableTapping->isChecked() );
  SynConfig::setTapTime( slTapTime->value() );
  SynConfig::setTapRightTop( finger[0] );
  SynConfig::setTapRightBottom( finger[1] );
  SynConfig::setTapLeftTop( finger[2] );
  SynConfig::setTapLeftBottom( finger[3] );
  SynConfig::setTapOneFinger( finger[4] );
  SynConfig::setTapTwoFingers( finger[5] );
  SynConfig::setTapThreeFingers( finger[6] );
  SynConfig::setFastTaps( cbFastTaps->isChecked() );
  SynConfig::setEnableCoasting( cbCoasting->isChecked() );

  // Scrolling Tab
  SynConfig::setEnableHorizontalScrolling( cbHorizScrolling->isChecked() );
  SynConfig::setHorizontalScrollDelta( slHorizScrollDelta->value()*-1 );
  SynConfig::setEnableVerticalScrolling( cbVertScrolling->isChecked() );
  SynConfig::setVerticalScrollDelta( slVertScrollDelta->value()*-1 );
  SynConfig::setEnableCircularScrolling( cbCircScrolling->isChecked() );
  SynConfig::setCircularScrollDelta( slCircularDelta->value()*-1 );
  SynConfig::setCircularScrollTrigger( cmbCircTrigger->currentItem() );
  SynConfig::setEnableEdgeMotion( cbEdgeMotion->isChecked() );

  SynConfig::writeConfig();
}


void SynConfigWidget::enableDocking( bool yesNo )
{
  kdDebug() << "switch docking " << QString( yesNo? "on":"off" ) << endl;

  // set autostart link or remove it!
  if (yesNo)
  {
	m_sdstart.clearArguments();
    m_sdstart << "syndock";
    m_sdstart.start();
  }
  else
  {
	m_sdkill.clearArguments();
    m_sdkill << "killall" << "syndock";
    m_sdkill.start();
  }
  
  kdDebug() << "..done!" << endl;
}

#include "synconfigwidget.moc"

