/***************************************************************************
                          ksubtileview.cpp  -  description
                             -------------------
    begin                : di feb  4 15:33:11 CET 2003
    copyright            : (C) 2003 by Tom Deblauwe
    email                : tom.deblauwe@pandora.be
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

// include files for Qt
// #include <qprinter.h>
#include <qpainter.h>
#include <qtabwidget.h>
#include <qlabel.h>
#include <qregexp.h>
#include <qdatetime.h>
#include <qdatetimeedit.h>
#include <qspinbox.h>
#include <qcheckbox.h>
#include <qpixmap.h>
#include <qradiobutton.h>
#include <qcombobox.h>
// #include <qrect.h>

// application specific includes
#include "ksubtileview.h"
#include "ksubtiledoc.h"
#include "ksubtile.h"
#include "ksubtiledlg.h"
#include "ksqueezedtextlabel.h"
#include "kmessagebox.h"
#include "klocale.h"
#include "csubtitles.h"
#include "kiconloader.h"
#include <kpushbutton.h>
#include <klineedit.h>
#include <kdockwidget.h>
#include <kconfig.h>
#include <klistview.h>


// #include <X11/Xutil.h>

#include "subtitlenavigator.h"
#include "selectfromlistdialog.h"
#include "pref.h"
#include "subtitlelistviewitem.h"

KSubtileView::KSubtileView(QWidget *parent, const char *name) : KSubtileDlg(parent, name)
{

    connect(pm_editor_navigator_bar, SIGNAL(maxZoomedOut(bool)), this, SLOT(slotEditorMaxZoomedOut(bool)));
    connect(pm_editor_navigator_bar, SIGNAL(maxZoomedIn(bool)), this, SLOT(slotEditorMaxZoomedIn(bool)));
    connect(pm_editor_navigator_bar, SIGNAL(rightEndReached(bool)), this, SLOT(slotEditorRightEndReached(bool)));
    connect(pm_editor_navigator_bar, SIGNAL(leftEndReached(bool)), this, SLOT(slotEditorLeftEndReached(bool)));
    connect(pm_editor_navigator_bar, SIGNAL(zoomStartTimeChanged(long)), this, SLOT(slotEditorZoomStartTimeChanged(long)));
    connect(pm_editor_navigator_bar, SIGNAL(zoomEndTimeChanged(long)), this, SLOT(slotEditorZoomEndTimeChanged(long)));
    connect(pm_editor_navigator_bar, SIGNAL(noSubs(bool)), this, SLOT(slotEditorCheckIfNoSubs(bool)));

    //load icons onto buttons

    KIconLoader* loader = KGlobal::iconLoader();

    //stretch
    pb_stretch_curpos_startTime->setPixmap(loader->loadIcon("history", KIcon::Small));

    //move
    pb_move_curpos_startTime->setPixmap(loader->loadIcon("history", KIcon::Small));

    //editor
    pb_editor_curpos_startTime->setPixmap(loader->loadIcon("history", KIcon::Small));
    pb_editor_curpos_length->setPixmap(loader->loadIcon("history", KIcon::Small));

    pb_stretch_play_startTime->setPixmap(loader->loadIcon("player_play", KIcon::Small));
    pb_move_play_startTime->setPixmap(loader->loadIcon("player_play", KIcon::Small));
    pb_editor_play_startTime->setPixmap(loader->loadIcon("player_play", KIcon::Small));
    pb_editor_navigator_barZoomIn->setPixmap(loader->loadIcon("viewmag+", KIcon::Toolbar));
    pb_editor_navigator_barZoomOut->setPixmap(loader->loadIcon("viewmag-", KIcon::Toolbar));

    //fill in combobox in ccp tab

    com_ccp_afterBefore->insertItem( i18n("after") );
    com_ccp_afterBefore->insertItem( i18n("before") );

    //add columns in ccp tab

    lv_ccp_subtitlesList->addColumn( i18n("Nr") );
    lv_ccp_subtitlesList->addColumn( i18n("Start Time") );
    lv_ccp_subtitlesList->addColumn( i18n("Length") );
    lv_ccp_subtitlesList->addColumn( i18n("Text") );

    //make the items in the columns align to top

    lv_ccp_subtitlesList->setColumnAlignment(0, Qt::AlignTop);
    lv_ccp_subtitlesList->setColumnAlignment(1, Qt::AlignTop);
    lv_ccp_subtitlesList->setColumnAlignment(2, Qt::AlignTop);
    lv_ccp_subtitlesList->setColumnAlignment(3, Qt::AlignTop);

}

KSubtileView::~KSubtileView()
{
}

KSubtileDoc *KSubtileView::getDocument() const
{
    return theApp->getDocument();
}

void KSubtileView::tw_editor_selected( const QString & /*label*/)
{
    //a tab page is selected

    //The Info Tab page
    //  printf("current page:%i\n", tw_editor->indexOf(tw_editor->currentPage()) );
    switch(tw_editor->indexOf(tw_editor->currentPage()))
    {
    case 0: //info
        initInfo();
        break;
    case 1: //stretch
        initStretch();
        break;
    case 2: //move
        initMove();
        break;
    case 3: //ccp
        initCCP();
        break;
    case 4: //editor
        initEditor();
        break;
    default:
        break;
    }

    //  printf( "test: %s\n", (label).latin1() );
}

//////// NAVIGATOR

void KSubtileView::pb_editor_navigator_barZoomIn_clicked()
{
    pm_editor_navigator_bar->slotZoomIn();
}

void KSubtileView::pb_editor_navigator_barZoomOut_clicked()
{
    pm_editor_navigator_bar->slotZoomOut();
}

void KSubtileView::pb_editor_navigator_barScrollLeft_clicked()
{
    pm_editor_navigator_bar->slotGoLeft(1000);
}

void KSubtileView::pb_editor_navigator_barScrollRight_clicked()
{
    pm_editor_navigator_bar->slotGoRight(1000);
}

void KSubtileView::pb_editor_navigator_barScrollLeftFast_clicked()
{
    pm_editor_navigator_bar->slotGoLeft(5000);
}

void KSubtileView::pb_editor_navigator_barScrollRightFast_clicked()
{
    pm_editor_navigator_bar->slotGoRight(5000);
}

void KSubtileView::cb_editor_navigator_barZoomCurrent_clicked()
{
    //we indicate that we want to zoom in and out with the current selected subtitle centered
    pm_editor_navigator_bar->setSelectedSubtitleCentered(cb_editor_navigator_barZoomCurrent->isChecked());
}

void KSubtileView::pb_editor_navigator_selectFromList_clicked()
{
    //call the window to select subtitles

    SelectFromListDialog* selectDialog = new SelectFromListDialog(0,0,true);

    //load the subtitles in the dialog

    selectDialog->loadSubtitles(getDocument()->subtitles, pm_editor_navigator_bar->getSelectedSubtitle());

    //open the dialog modal

    int answer = selectDialog->exec();

    if(answer == QDialog::Accepted)
    {
        //selected a new subtitle, so select it in the navigator
        pm_editor_navigator_bar->selectSubtitle(selectDialog->getSubtitle());
    }

    //clean up

    delete selectDialog;
}

void KSubtileView::slotEditorMaxZoomedOut(bool isMax)
{
    pb_editor_navigator_barZoomOut->setEnabled(!isMax);
}

void KSubtileView::slotEditorMaxZoomedIn(bool isMax)
{
    pb_editor_navigator_barZoomIn->setEnabled(!isMax);
}

void KSubtileView::slotEditorRightEndReached(bool isReached)
{
    pb_editor_navigator_barScrollRight->setEnabled(!isReached);
    pb_editor_navigator_barScrollRightFast->setEnabled(!isReached);
}

void KSubtileView::slotEditorLeftEndReached(bool isReached)
{
    pb_editor_navigator_barScrollLeft->setEnabled(!isReached);
    pb_editor_navigator_barScrollLeftFast->setEnabled(!isReached);
}

void KSubtileView::slotEditorZoomStartTimeChanged(long newTime)
{
    l_editor_navigator_startTime->setText(CSubtitles::getQTimeFromMSecs(newTime).toString( QString ( "hh:mm:ss,zzz" ) ));
}

void KSubtileView::slotEditorZoomEndTimeChanged(long newTime)
{

    l_editor_navigator_endTime->setText(CSubtitles::getQTimeFromMSecs(newTime).toString( QString ( "hh:mm:ss,zzz" ) ));

}

void KSubtileView::slotEditorCheckIfNoSubs(bool areThereNoSubs)
{
    if(areThereNoSubs)
    {
        //there are no subs :-)
        pb_editor_navigator_selectFromList->setEnabled(false);
    }
    else
    {
        pb_editor_navigator_selectFromList->setEnabled(true);
    }
}

//removes all connections to the navigator

void KSubtileView::removeConnectionsToNavigator()
{
    disconnect(pm_editor_navigator_bar, SIGNAL(subClicked(CSubtitle*)), this, SLOT(slotStretchSubClicked(CSubtitle*)));
    disconnect(pm_editor_navigator_bar, SIGNAL(subClicked(CSubtitle*)), this, SLOT(slotMoveSubClicked(CSubtitle*)));
    disconnect(pm_editor_navigator_bar, SIGNAL(subClicked(CSubtitle*)), this, SLOT(slotCCPSubClicked(CSubtitle*)));
    disconnect(pm_editor_navigator_bar, SIGNAL(subClicked(CSubtitle*)), this, SLOT(slotEditorSubClicked(CSubtitle*)));
}



//////////////// INFO

void KSubtileView::initInfo()
{
    //disconnect all signals to the navigator

    removeConnectionsToNavigator();

    //display totallength
    l_totalLength->setText((CSubtitles::getQTimeFromMSecs(getDocument()->subtitles->getTotalOccupiedTime())).toString( QString("hh:mm:ss,zzz") ) );
    //display nr of subs
    l_nrOfSubtitles->setText( QString::number(getDocument()->subtitles->getNrOfSubtitles() ) );
    //display current opened filename
    // 	KSubtileApp *theApp=(KSubtileApp *) parentWidget();
    QStringList captionList = QStringList::split( QRegExp( " - KSubtile" ), theApp->caption(), false);
    l_fileName->setText( captionList[0] );

}

/////////////ACCESS TO PLAYER

KSubtilePlayer* KSubtileView::getPlayer()
{

    KDockWidget* playerDock = theApp->manager()->getDockWidgetFromName("player");
    return (KSubtilePlayer* ) playerDock->getWidget();
}


///////////////STRETCH

void KSubtileView::initStretch()
{

    // reset values
    stretch_reset();

    //check amount of subtitles
    if(getDocument()->subtitles->getNrOfSubtitles() == 0)
    {
        stretch_enable(false);
        return;
    }
    else
    {
        stretch_enable(true);
    }

    //disconnect all from navigator

    removeConnectionsToNavigator();

    //connect subClicked from the navigator

    connect(pm_editor_navigator_bar, SIGNAL(subClicked(CSubtitle *)), this, SLOT(slotStretchSubClicked(CSubtitle *)));

    //use the already selected subtitle

    slotStretchSubClicked(pm_editor_navigator_bar->getSelectedSubtitle());

    //disable apply button

    pb_stretch_apply->setEnabled(false);
}


void KSubtileView::pb_stretch_curpos_startTime_clicked()
{
    //time icon clicked in stretch tab next to starttime
    if(te_stretch_startTime->isEnabled())
    {
        QTime curTime = CSubtitles::getQTimeFromMSecs(getPlayer()->getPlayerCurrentPos());
        b_enable_stretch_valuechanged = false;
        te_stretch_startTime->setTime( curTime );
        b_enable_stretch_valuechanged = true;
        sb_stretch_startTime->setValue( curTime.msec() );
    }
}


void KSubtileView::pb_stretch_apply_clicked()
{
    //apply the stretching

    //     KSubtileApp *theApp=(KSubtileApp *) parentWidget();
    theApp->slotStatusMsg( i18n("Applying stretch...") );

    long newStartTime = CSubtitles::getMSecs( te_stretch_startTime->time() ) + sb_stretch_startTime->value();
    getDocument()->subtitles->stretchTime( newStartTime, sub_stretch_sub );
    pm_editor_navigator_bar->drawSubs(getDocument()->subtitles, true, sub_stretch_sub);

    //fill in new times of stretchsub in select part of the stretchtab

    tl_stretch_sub->setText( sub_stretch_sub->getStartTime_QTime().toString( QString ( "hh:mm:ss,zzz" )).latin1() + QString("  >>  ") + sub_stretch_sub->getEndTime_QTime().toString(QString ( "hh:mm:ss,zzz" ) ).latin1() );

    getDocument()->setModified(true);
    pb_stretch_apply->setEnabled(false);
    theApp->slotStatusMsg( i18n("Stretch completed") );
}

void KSubtileView::te_stretch_startTime_valueChanged( const QTime & newTime)
{
    if(b_enable_stretch_valuechanged)
    {
        //     KSubtileApp *theApp=(KSubtileApp *) parentWidget();

        long newTimeMSecs = CSubtitles::getMSecs( newTime ) + sb_stretch_startTime->value();
        if(newTimeMSecs > stretch_limitSub_left && newTimeMSecs < stretch_limitSub_right)
        {
            //ok new value is possible

            theApp->slotStatusMsg( i18n("Ready") );
            pb_stretch_apply->setEnabled(true);
        }
        else
        {
            //we check if the user exceeds a "timeborder" on the left or on the right and
            //stop at the left or right timelimit
            if(newTimeMSecs <= stretch_limitSub_left)
            {
                theApp->slotStatusMsg( i18n("You're squeezing to much to the left") );
                QTime oldStartTime = CSubtitles::getQTimeFromMSecs(stretch_limitSub_left + 1);
                b_enable_stretch_valuechanged = false;
                te_stretch_startTime->setTime(oldStartTime );
                b_enable_stretch_valuechanged = true;
                sb_stretch_startTime->setValue( oldStartTime.msec() );

            }
            else
            {
                theApp->slotStatusMsg( i18n("You're squeezing to much to the right"));
                QTime oldStartTime = CSubtitles::getQTimeFromMSecs(stretch_limitSub_right - 1);
                b_enable_stretch_valuechanged = false;
                te_stretch_startTime->setTime(oldStartTime );
                b_enable_stretch_valuechanged = true;
                sb_stretch_startTime->setValue( oldStartTime.msec() );
            }

        }
    }
}

void KSubtileView::sb_stretch_startTime_valueChanged( int newValue )
{
    if(b_enable_stretch_valuechanged)
    {
        //     KSubtileApp *theApp=(KSubtileApp *) parentWidget();

        long newTimeMSecs = CSubtitles::getMSecs( te_stretch_startTime->time() ) + newValue;
        if(newTimeMSecs > stretch_limitSub_left && newTimeMSecs < stretch_limitSub_right)
        {
            //ok new value is possible

            theApp->slotStatusMsg( i18n("Ready") );
            pb_stretch_apply->setEnabled(true);
        }
        else
        {
            //we check if the user exceeds a "timeborder" on the left or on the right and
            //stop at the left or right timelimit
            if(newTimeMSecs <= stretch_limitSub_left)
            {
                theApp->slotStatusMsg( i18n("You're squeezing to much to the left") );
                QTime oldStartTime = CSubtitles::getQTimeFromMSecs(stretch_limitSub_left + 1);
                b_enable_stretch_valuechanged = false;
                te_stretch_startTime->setTime(oldStartTime );
                b_enable_stretch_valuechanged = true;
                sb_stretch_startTime->setValue( oldStartTime.msec() );

            }
            else
            {
                theApp->slotStatusMsg( i18n("You're squeezing to much to the right"));
                QTime oldStartTime = CSubtitles::getQTimeFromMSecs(stretch_limitSub_right - 1);
                b_enable_stretch_valuechanged = false;
                te_stretch_startTime->setTime(oldStartTime );
                b_enable_stretch_valuechanged = true;
                sb_stretch_startTime->setValue( oldStartTime.msec() );
            }

        }
    }
}

// we selected a sub which is the basis for stretching

void KSubtileView::slotStretchSubClicked(CSubtitle * stretchSub)
{

    //get amount of subs that are before 'sub'
    long subsbefore = 0;
    QPtrListIterator<CSubtitle> it( *getDocument()->subtitles );
    CSubtitle *sub;
    while ( (sub = it.current() ) != 0 )
    {
        ++it;
        if(*sub == *stretchSub)
        {
            break;
        }
        subsbefore++;
    }
    //calculate amount after
    long subsafter = getDocument()->subtitles->getNrOfSubtitles() - subsbefore - 1;

    // -1 is to not calculate the stretchSub in
    //now we can determine how much the sub can be stretched so we still can put all the subtitles in between the start or end and the stretched subtitle
    if(subsbefore != 0)
    {
        stretch_limitSub_left = subsbefore - 1 + getDocument()->subtitles->getFirstSubtitle()->getStartTime();
    }
    else
    {
        stretch_limitSub_left = subsbefore - 1;
    }

    if(subsafter != 0)
    {
        stretch_limitSub_right = getDocument()->subtitles->getLastSubtitle()->getStartTime() - subsafter;
    }
    else
    {
        stretch_limitSub_right = 86400000 - subsafter;
    }

    //remember the sub

    sub_stretch_sub = stretchSub;

    // fill in the selected sub

    tl_stretch_sub->setText( stretchSub->getStartTime_QTime().toString( QString( "hh:mm:ss,zzz" ) ).latin1() + QString("  >>  ") + stretchSub->getEndTime_QTime().toString( QString ( "hh:mm:ss,zzz" ) ).latin1());
    tl_stretch_sub_line1->setText( stretchSub->getLine1() );
    tl_stretch_sub_line2->setText( stretchSub->getLine2() );
    //fill in the time edit
    b_enable_stretch_valuechanged = false;
    te_stretch_startTime->setTime( stretchSub->getStartTime_QTime() );
    sb_stretch_startTime->setValue( stretchSub->getStartTime_QTime().msec() );
    b_enable_stretch_valuechanged = true;

    pb_stretch_apply->setEnabled( false );
}

void KSubtileView::stretch_enable(bool enabled)
{
    te_stretch_startTime->setEnabled(enabled);
    sb_stretch_startTime->setEnabled(enabled);

    tl_stretch_sub->setEnabled(enabled);
    tl_stretch_sub_line1->setEnabled(enabled);
    tl_stretch_sub_line2->setEnabled(enabled);
}

void KSubtileView::stretch_reset()
{
    tl_stretch_sub->setText( "00:00:00,000  >>  00:00:00,000" );
    tl_stretch_sub_line1->setText( "" );
    tl_stretch_sub_line2->setText( "" );

    b_enable_stretch_valuechanged = false;
    te_stretch_startTime->setTime( QTime(0,0,0,0) );
    sb_stretch_startTime->setValue( 0 );
    b_enable_move_valuechanged = true;

}

///////// MOVE

void KSubtileView::initMove()
{

    // reset values

    move_reset();

    //check amount of subtitles

    if(getDocument()->subtitles->getNrOfSubtitles() == 0)
    {
        move_enable(false);
        return;
    }
    else
    {
        move_enable(true);
    }

    //disconnect all from navigator

    removeConnectionsToNavigator();

    //connect subClicked from the navigator

    connect(pm_editor_navigator_bar, SIGNAL(subClicked(CSubtitle *)), this, SLOT(slotMoveSubClicked(CSubtitle *)));

    // select already the selected subtitle as first one and the last subtitle is always the last one

    move_setFirstSub(pm_editor_navigator_bar->getSelectedSubtitle());
    move_setLastSub(getDocument()->subtitles->getLastSubtitle());

}

//sets first subtitle when selected in the navigator, we reset all changes made to the starttime of the first sub

void KSubtileView::move_setFirstSub(CSubtitle * firstSub)
{
    sub_move_firstSub = firstSub;
    tl_move_firstSub->setText( firstSub->getStartTime_QTime().toString( QString ( "hh:mm:ss,zzz" ) ).latin1() + QString("  >>  ") + firstSub->getEndTime_QTime().toString( QString ( "hh:mm:ss,zzz" ) ).latin1() );
    tl_move_firstSub_line1->setText( firstSub->getLine1() );
    tl_move_firstSub_line2->setText( firstSub->getLine2() );

    //put the starttime of this first sub in the time edit box

    b_enable_move_valuechanged = false;
    te_move_startTime->setTime( firstSub->getStartTime_QTime() );
    sb_move_startTime->setValue( firstSub->getStartTime_QTime().msec() );
    b_enable_move_valuechanged = true;

    if(sub_move_lastSub != 0)
    {
        //reset value of starttime of last sub

        tl_move_endTime->setText(sub_move_lastSub->getStartTime_QTime().toString( QString( "hh:mm:ss,zzz" )).latin1() );
    }

    // set the left limit: the timeedit can't have a value lower than this value

    move_limitFirstSub_left = getDocument()->subtitles->getEndTimeBefore(firstSub);

    //we need to update also the right limit because we use the starttime of the first sub in our calculation

    if(sub_move_lastSub != 0)
    {
        move_limitFirstSub_right = getDocument()->subtitles->getStartTimeAfter(sub_move_lastSub) - sub_move_lastSub->getEndTime() + firstSub->getStartTime();
    }
}

//sets last subtitle when selected in the navigator, we reset all changes made to the starttime of the first sub
//note: this is always called after move_setFirstSub and only if we have minimum one subtitle

void KSubtileView::move_setLastSub(CSubtitle * lastSub)
{
    sub_move_lastSub = lastSub;
    tl_move_lastSub->setText( lastSub->getStartTime_QTime().toString( QString("hh:mm:ss,zzz" ) ).latin1() + QString("  >>  ") + lastSub->getEndTime_QTime().toString( QString ( "hh:mm:ss,zzz" ) ).latin1() );
    tl_move_lastSub_line1->setText( lastSub->getLine1() );
    tl_move_lastSub_line2->setText( lastSub->getLine2() );

    //put the starttime of this first sub in the time edit box

    b_enable_move_valuechanged = false;
    te_move_startTime->setTime( sub_move_firstSub->getStartTime_QTime() );
    sb_move_startTime->setValue( sub_move_firstSub->getStartTime_QTime().msec());
    b_enable_move_valuechanged = true;

    //reset value of starttime of last sub

    tl_move_endTime->setText( lastSub->getStartTime_QTime().toString( QString ("hh:mm:ss,zzz" ) ).latin1() );

    // set the right limit: the timeedit can't have a value greater than this value

    move_limitFirstSub_right = getDocument()->subtitles->getStartTimeAfter(lastSub) - lastSub->getEndTime() + sub_move_firstSub->getStartTime();
}

void KSubtileView::slotMoveSubClicked(CSubtitle * sub)
{
    //check which (first or last) sub we must change

    if(rb_move_select_firstSub->isChecked())
    {
        //first selected

        if(sub_move_lastSub->getStartTime() >= sub->getStartTime())
        {
            //we selected a sub before the last sub, so it's OK, we select it

            move_setFirstSub(sub);
        }
        else
        {
            //we reselect the current sub

            pm_editor_navigator_bar->drawSubs(getDocument()->subtitles, false, sub_move_firstSub);

            //show the sub in the center

            //             pm_editor_navigator_bar->slotShowSub(sub_move_firstSub);
        }
    }
    else
    {
        //last selected

        if(sub_move_firstSub->getStartTime() <= sub->getStartTime())
        {
            //we selected a sub after the first sub, so it's OK, we select it

            move_setLastSub(sub);
        }
        else
        {
            //we reselect the current sub

            pm_editor_navigator_bar->drawSubs(getDocument()->subtitles, false, sub_move_lastSub);

            //show the sub in the center

            //             pm_editor_navigator_bar->slotShowSub(sub_move_lastSub);
        }
    }
}

void KSubtileView::pb_move_apply_clicked()
{
    //     KSubtileApp *theApp=(KSubtileApp *) parentWidget();
    theApp->slotStatusMsg( i18n("Applying move...") );

    long newStartTime = CSubtitles::getMSecs( te_move_startTime->time() ) + sb_move_startTime->value();
    getDocument()->subtitles->moveSubtitles(newStartTime, sub_move_firstSub, sub_move_lastSub);
    pm_editor_navigator_bar->drawSubs(getDocument()->subtitles, true, sub_move_firstSub);

    //fill in new times of first and last sub in select part of the movetab

    tl_move_firstSub->setText( sub_move_firstSub->getStartTime_QTime().toString( QString ( "hh:mm:ss,zzz" )).latin1() + QString("  >>  ") + sub_move_firstSub->getEndTime_QTime().toString(QString ( "hh:mm:ss,zzz" ) ).latin1() );
    tl_move_lastSub->setText( sub_move_lastSub->getStartTime_QTime().toString( QString ( "hh:mm:ss,zzz" )).latin1() + QString("  >>  ") + sub_move_lastSub->getEndTime_QTime().toString(QString ( "hh:mm:ss,zzz" ) ).latin1() );

    getDocument()->setModified(true);
    pb_move_apply->setEnabled(false);
    theApp->slotStatusMsg( i18n("Move completed") );
}

void KSubtileView::sb_move_startTime_valueChanged( int newValue )
{

    if(b_enable_move_valuechanged)
    {
        //     KSubtileApp *theApp=(KSubtileApp *) parentWidget();

        long newTimeMSecs = CSubtitles::getMSecs( te_move_startTime->time() ) + newValue;
        if(newTimeMSecs > move_limitFirstSub_left && newTimeMSecs < move_limitFirstSub_right)
        {
            //ok new value is possible, update endtime

            tl_move_endTime->setText((CSubtitles::getQTimeFromMSecs((newTimeMSecs - sub_move_firstSub->getStartTime()) + sub_move_lastSub->getStartTime())).toString( QString( "hh:mm:ss,zzz" ) ));
            theApp->slotStatusMsg( i18n("Ready") );
            pb_move_apply->setEnabled(true);
        }
        else
        {

            //we check if the user exceeds a "timeborder" on the left or on the right and
            //stop at the left or right timelimit
            if(newTimeMSecs <= move_limitFirstSub_left)
            {
                theApp->slotStatusMsg( i18n("Can't move subtitles range further left"));
                QTime oldStartTime = CSubtitles::getQTimeFromMSecs(move_limitFirstSub_left + 1);
                b_enable_move_valuechanged = false;
                te_move_startTime->setTime(oldStartTime );
                b_enable_move_valuechanged = true;
                sb_move_startTime->setValue( oldStartTime.msec() );
            }
            else
            {
                theApp->slotStatusMsg( i18n("Can't move subtitles range further right") );
                QTime oldStartTime = CSubtitles::getQTimeFromMSecs(move_limitFirstSub_right - 1);
                b_enable_move_valuechanged = false;
                te_move_startTime->setTime(oldStartTime );
                b_enable_move_valuechanged = true;
                sb_move_startTime->setValue( oldStartTime.msec() );
            }


        }
    }


}

void KSubtileView::te_move_startTime_valueChanged( const QTime & newTime)
{
    if(b_enable_move_valuechanged)
    {
        //     KSubtileApp *theApp=(KSubtileApp *) parentWidget();

        long newTimeMSecs = CSubtitles::getMSecs( newTime ) + sb_move_startTime->value();
        if(newTimeMSecs > move_limitFirstSub_left && newTimeMSecs < move_limitFirstSub_right)
        {
            //ok new value is possible, update endtime

            tl_move_endTime->setText((CSubtitles::getQTimeFromMSecs((newTimeMSecs - sub_move_firstSub->getStartTime()) + sub_move_lastSub->getStartTime())).toString( QString( "hh:mm:ss,zzz" ) ));
            theApp->slotStatusMsg( i18n("Ready") );
            pb_move_apply->setEnabled(true);
        }
        else
        {
            //we check if the user exceeds a "timeborder" on the left or on the right and
            //stop at the left or right timelimit
            if(newTimeMSecs <= move_limitFirstSub_left)
            {
                theApp->slotStatusMsg( i18n("Can't move subtitles range further left"));
                QTime oldStartTime = CSubtitles::getQTimeFromMSecs(move_limitFirstSub_left + 1);
                b_enable_move_valuechanged = false;
                te_move_startTime->setTime(oldStartTime );
                b_enable_move_valuechanged = true;
                sb_move_startTime->setValue( oldStartTime.msec() );

            }
            else
            {
                theApp->slotStatusMsg( i18n("Can't move subtitles range further right") );
                QTime oldStartTime = CSubtitles::getQTimeFromMSecs(move_limitFirstSub_right - 1);
                b_enable_move_valuechanged = false;
                te_move_startTime->setTime(oldStartTime );
                b_enable_move_valuechanged = true;
                sb_move_startTime->setValue( oldStartTime.msec() );
            }

        }
    }
}

void KSubtileView::pb_move_curpos_startTime_clicked()
{

    if(te_move_startTime->isEnabled())
    {
        QTime curTime = CSubtitles::getQTimeFromMSecs(getPlayer()->getPlayerCurrentPos());
        b_enable_move_valuechanged = false;
        te_move_startTime->setTime( curTime );
        b_enable_move_valuechanged = true;
        sb_move_startTime->setValue( curTime.msec() );
    }
}


void KSubtileView::rb_move_select_firstSub_clicked()
{
    //show current sub on navigator

    pm_editor_navigator_bar->drawSubs(getDocument()->subtitles, false, sub_move_firstSub);

    //show the sub in the center

    //     pm_editor_navigator_bar->slotShowSub(sub_move_firstSub);

}

void KSubtileView::rb_move_select_lastSub_clicked()
{
    //show current sub on navigator

    pm_editor_navigator_bar->drawSubs(getDocument()->subtitles, false, sub_move_lastSub);

    //show the sub in the center

    //     pm_editor_navigator_bar->slotShowSub(sub_move_lastSub);

}

//enable or disable controls in the move tab

void KSubtileView::move_enable(bool enabled)
{
    rb_move_select_firstSub->setEnabled(enabled);
    rb_move_select_lastSub->setEnabled(enabled);

    tl_move_firstSub->setEnabled(enabled);
    tl_move_lastSub->setEnabled(enabled);

    tl_move_firstSub_line1->setEnabled(enabled);
    tl_move_firstSub_line2->setEnabled(enabled);

    tl_move_lastSub_line1->setEnabled(enabled);
    tl_move_lastSub_line2->setEnabled(enabled);

    te_move_startTime->setEnabled(enabled);
    sb_move_startTime->setEnabled(enabled);

}

// reset all values in the move tab

void KSubtileView::move_reset()
{
    rb_move_select_firstSub->setChecked(true);

    tl_move_firstSub->setText( "00:00:00,000  >>  00:00:00,000" );
    tl_move_lastSub->setText( "00:00:00,000  >>  00:00:00,000" );

    tl_move_firstSub_line1->setText( "" );
    tl_move_firstSub_line2->setText( "" );

    tl_move_lastSub_line1->setText( "" );
    tl_move_lastSub_line2->setText( "" );

    b_enable_move_valuechanged = false;
    te_move_startTime->setTime( QTime(0,0,0,0) );
    sb_move_startTime->setValue( 0 );
    b_enable_move_valuechanged = true;

    tl_move_endTime->setText( "00:00:00,000" );

    sub_move_firstSub = 0;
    sub_move_lastSub = 0;
}

/////////// CCP

void KSubtileView::initCCP()
{

    ccp_reset();

    //check if copySubtitles is already initialized
    if(theApp->copySubtitles == 0)
    {
        theApp->copySubtitles = new CSubtitles();
    }
    
    if(getDocument()->subtitles->getNrOfSubtitles() == 0)
    {
        ccp_enable(false);
	//there may be subs in copySubtitles
	ccp_enableApply();
	//select the paste tab
	tw_ccp->setCurrentPage( 1 );
        return;
    }
    else
    {
        ccp_enable(true);
    }

    //disconnect all from navigator

    removeConnectionsToNavigator();

    //connect subClicked from the navigator

    connect(pm_editor_navigator_bar, SIGNAL(subClicked(CSubtitle *)), this, SLOT(slotCCPSubClicked(CSubtitle *)));

    //use the already selected subtitle

    slotCCPSubClicked(pm_editor_navigator_bar->getSelectedSubtitle());

    //en/disable apply button

    ccp_enableApply();
    
    //fill in list with subs
    ccp_fillInList();
    
    //make sure cut/copy page is selected
    tw_ccp->setCurrentPage( 0 );
}

void KSubtileView::ccp_fillInList()
{
    //clear list

    lv_ccp_subtitlesList->clear();

    //add all items

    QPtrListIterator<CSubtitle> it = getDocument()->subtitles->getIterator();
    CSubtitle* sub;
    long counter = 0;
    while ( (sub = it.current() ) != 0 )
    {
        ++it;
        counter++;
        new SubtitleListViewItem(lv_ccp_subtitlesList, QString::number(counter), CSubtitles::getQTimeFromMSecs(sub->getStartTime()).toString( QString("hh:mm:ss,zzz") ), CSubtitles::getQTimeFromMSecs(sub->getEndTime() - sub->getStartTime()).toString( QString("hh:mm:ss,zzz") ), sub->getLine1() + "\n" + sub->getLine2());
    }

    //sort on starttime

    lv_ccp_subtitlesList->setSorting(1, true);
    lv_ccp_subtitlesList->setShowSortIndicator(true);

    //disable cut and copy buttons(no selection)
    
    pb_ccp_cut->setEnabled(false);
    pb_ccp_copy->setEnabled(false);    
}

void KSubtileView::ccp_enableApply()
{
    if(theApp->copySubtitles->getNrOfSubtitles() == 0)
    {
        pb_ccp_apply->setEnabled(false);
    }
    else
    {
	pb_ccp_apply->setEnabled(true);
    }
}

void KSubtileView::pb_ccp_selectAll_clicked()
{
    lv_ccp_subtitlesList->selectAll(true);
}

// we selected a sub which is the basis for the offset

void KSubtileView::slotCCPSubClicked(CSubtitle * ccpSub)
{

    if(ccpSub != 0)
    {
	//remember the sub

	sub_ccp_sub = ccpSub;

	// fill in the selected sub

	tl_ccp_sub->setText( ccpSub->getStartTime_QTime().toString( QString( "hh:mm:ss,zzz" ) ).latin1() + QString("  >>  ") + ccpSub->getEndTime_QTime().toString( QString ( "hh:mm:ss,zzz" ) ).latin1());
	tl_ccp_sub_line1->setText( ccpSub->getLine1() );
	tl_ccp_sub_line2->setText( ccpSub->getLine2() );

	//fill in the offset

	ccp_fillInOffset();
    }

}

void KSubtileView::ccp_fillInOffset(void)
{
   
    //check if we have space before or after the subtitle
    long spaceLeft = 0;
    
    kapp->config()->setGroup("Editor Options");
    long pasteOffset = kapp->config()->readLongNumEntry("Default Paste Offset", ksubtilePreferences::pref_DefaultPasteOffset );
   
    if(com_ccp_afterBefore->currentText() == "after")
    {
        //after
        spaceLeft = getDocument()->subtitles->getStartTimeAfter(sub_ccp_sub) - sub_ccp_sub->getEndTime() - 1;
        if(spaceLeft == 0)
        {
            //there is no space left to the right of the current sub -> disable certain controls
            ccp_copyCut_enable(false);
            theApp->slotStatusMsg( i18n("There is no space on the right of the selected subtitle!") );
        }
        else
        {
            ccp_copyCut_enable(true);
            ccp_limitOffset_max = spaceLeft;
	    long offset = spaceLeft;
	    
            if(offset > pasteOffset)
            {
                offset = pasteOffset;
            }
	    b_enable_ccp_valuechanged = false;
	    te_ccp_offset->setTime( CSubtitles::getQTimeFromMSecs(offset) );
            sb_ccp_offset->setValue( CSubtitles::getQTimeFromMSecs(offset).msec() );
    	    b_enable_ccp_valuechanged = true;
	    theApp->slotStatusMsg( i18n("Ready") );
        }
    }
    else
    {
        //before
        spaceLeft = sub_ccp_sub->getStartTime() - getDocument()->subtitles->getEndTimeBefore(sub_ccp_sub) - 1;
        if(spaceLeft == 0)
        {
            //there is no space left to the right of the current sub -> disable certain controls
            ccp_copyCut_enable(false);
            theApp->slotStatusMsg( i18n("There is no space on the left of the selected subtitle!") );
        }
        else
        {
            ccp_copyCut_enable(true);
            ccp_limitOffset_max = spaceLeft;
	    long offset = spaceLeft;

            if(offset > pasteOffset)
            {
                offset = pasteOffset;
            }
	    b_enable_ccp_valuechanged = false;
	    te_ccp_offset->setTime( CSubtitles::getQTimeFromMSecs(offset) );
            sb_ccp_offset->setValue( CSubtitles::getQTimeFromMSecs(offset).msec() );
    	    b_enable_ccp_valuechanged = true;
            theApp->slotStatusMsg( i18n("Ready") );
        }
    }
    
    //if there is a space to paste the subs
    if(pb_ccp_apply->isEnabled())
    {
	//if subs in memory enable apply button
	ccp_enableApply();    
    }
}

void KSubtileView::lv_ccp_subtitlesList_selectionChanged(void)
{
    //check selected items
    QPtrList<QListViewItem> sel = lv_ccp_subtitlesList->selectedItems();
    if(sel.isEmpty())
    {
	//disable cut and past buttons
	pb_ccp_cut->setEnabled(false);
	pb_ccp_copy->setEnabled(false);
    }
    else
    {
	//enable cut and past buttons
	pb_ccp_cut->setEnabled(true);
	pb_ccp_copy->setEnabled(true);
    }

}

//enable or disable controls in the copy/cut section and apply button and timeedit in the ccp tab

void KSubtileView::ccp_copyCut_enable(bool enabled)
{

    te_ccp_offset->setEnabled(enabled);
    sb_ccp_offset->setEnabled(enabled);

    pb_ccp_apply->setEnabled(enabled);

//    pb_ccp_cut->setEnabled(enabled);
//    pb_ccp_copy->setEnabled(enabled);
//    pb_ccp_selectAll->setEnabled(enabled);

//    lv_ccp_subtitlesList->setEnabled(enabled);

}

void KSubtileView::pb_ccp_quickSelect_begin_clicked(void)
{
    //select last subtitle
    pm_editor_navigator_bar->selectSubtitle(getDocument()->subtitles->getFirstSubtitle());
    
    //set pulldown list to "before"
    com_ccp_afterBefore->setCurrentItem( 1 );
    
    //refill offset so ccp_limitOffset_max gets filled in right
    ccp_fillInOffset();
    
    //fill in standard length

    kapp->config()->setGroup("Editor Options");
    long offset = kapp->config()->readLongNumEntry("Default Paste Offset", ksubtilePreferences::pref_DefaultPasteOffset );
   
    
    //calculate offset
    if(getDocument()->subtitles->getFirstSubtitle()->getStartTime() > 0)
    {
	offset = getDocument()->subtitles->getFirstSubtitle()->getStartTime();
    }
    
    //fill in offset
    QTime offsetTime = CSubtitles::getQTimeFromMSecs( offset );
    b_enable_ccp_valuechanged = false;
    te_ccp_offset->setTime( offsetTime );
    b_enable_ccp_valuechanged = true;    
    sb_ccp_offset->setValue( offsetTime.msec() );
    
}

void KSubtileView::pb_ccp_quickSelect_end_clicked(void)
{
    //select last subtitle
    pm_editor_navigator_bar->selectSubtitle(getDocument()->subtitles->getLastSubtitle());
    
    //set pulldown list to "after"
    com_ccp_afterBefore->setCurrentItem( 0 );
    
    //refill offset so ccp_limitOffset_max gets filled in right
    ccp_fillInOffset();
    
    //get movie length
    long length = getPlayer()->getPlayerMovieLength();
    
    //fill in standard length

    kapp->config()->setGroup("Editor Options");
    long offset = kapp->config()->readLongNumEntry("Default Paste Offset", ksubtilePreferences::pref_DefaultPasteOffset );

    
    if(length != 0)
    {
	//calculate offset
	if(getDocument()->subtitles->getLastSubtitle()->getEndTime() < length)
	{
	    //the movie length is bigger than the endtime of the lastsub
	    offset = length - getDocument()->subtitles->getLastSubtitle()->getEndTime();
	}
    }
    
    //fill in offset
    QTime offsetTime = CSubtitles::getQTimeFromMSecs( offset );
    b_enable_ccp_valuechanged = false;    
    te_ccp_offset->setTime( offsetTime );
    b_enable_ccp_valuechanged = true;
    sb_ccp_offset->setValue( offsetTime.msec() );
    
}
    
void KSubtileView::pb_ccp_apply_clicked(void)
{
    //paste the subtitles
    CSubtitles* pasteSubs = new CSubtitles();
    
    QPtrListIterator<CSubtitle> it( *theApp->copySubtitles );   
    CSubtitle* sub;
    while( (sub = it.current()) != 0 )
    {
	//make a (deep) copy of the subtitles in memory
	pasteSubs->addSubtitle(new CSubtitle( *sub ));
	++it;
    }
    
    //determine insertTime
    long insertTime = 0;
    if(getDocument()->subtitles->getNrOfSubtitles() != 0)
    {
        if(com_ccp_afterBefore->currentText() == "after")
        {
	    insertTime = sub_ccp_sub->getEndTime() + CSubtitles::getMSecs(te_ccp_offset->time()) + sb_ccp_offset->value();
	}
	else
	{
	    insertTime = sub_ccp_sub->getStartTime() - CSubtitles::getMSecs(te_ccp_offset->time()) - sb_ccp_offset->value();	
	}
	
    }
    getDocument()->subtitles->insertSubtitles(pasteSubs, insertTime);
    
    //redraw navigator
    pm_editor_navigator_bar->drawSubs(getDocument()->subtitles, true, pasteSubs->getFirstSubtitle());    
    
    //the subs are copied now, so we can delete the list that was holding them(will not delete the items is was holding because autodelete is false)
    delete pasteSubs;
    
    //necessary for when we paste in a document with 0 subtitles
    ccp_enable(true);
    slotCCPSubClicked(pm_editor_navigator_bar->getSelectedSubtitle());
    connect(pm_editor_navigator_bar, SIGNAL(subClicked(CSubtitle *)), this, SLOT(slotCCPSubClicked(CSubtitle *)));    
    
    //refill cut/copy list
    ccp_fillInList();
    
    //the document will be modified

    getDocument()->setModified(true);
    
    theApp->slotStatusMsg(i18n("Paste succeeded"));
}

void KSubtileView::pb_ccp_copy_clicked(void)
{
    //copy the subtitles
    
    //check selected items
    
    QPtrList<QListViewItem> sel = lv_ccp_subtitlesList->selectedItems();
    QPtrListIterator<QListViewItem> it(sel);
    QListViewItem* lvItem;
 
    QPtrListIterator<CSubtitle> itsub = getDocument()->subtitles->getIterator();
 
    //clear copySubtitles
    theApp->copySubtitles->setAutoDelete(true);
    theApp->copySubtitles->clear();
    theApp->copySubtitles->setAutoDelete(false);
	
    //add selected subtitles to copySubtitles
    
    while ( (lvItem = it.current() ) != 0 )
    {
	itsub.toFirst();
	itsub += (lvItem->text(0)).toLong() - 1;
	
	//make a (deep) copy of the subtitle
	theApp->copySubtitles->addSubtitle(new CSubtitle(*itsub.current()));
	
	++it;
    }
    
    //move subs to 00:00:00,000       
    theApp->copySubtitles->moveSubtitles(0, theApp->copySubtitles->getFirstSubtitle(), theApp->copySubtitles->getLastSubtitle());
    
    //enable apply button
    pb_ccp_apply->setEnabled(true);
    
    theApp->slotStatusMsg(i18n("Selected subtitles copied into memory"));
}

void KSubtileView::pb_ccp_cut_clicked(void)
{
    int doit = KMessageBox::warningContinueCancel(0, i18n("This action will also delete the selected subtitles!\nDo you really want to continue?"),
                                         i18n("Warning"), i18n("Cut"));
    if(doit == KMessageBox::Continue)
    {
	//copy and delete the subtitles
	pb_ccp_copy_clicked();
    
	//delete selected
	QPtrList<QListViewItem> sel = lv_ccp_subtitlesList->selectedItems();
	QPtrListIterator<QListViewItem> it(sel);
	QListViewItem* lvItem;
 
	QPtrListIterator<CSubtitle> itsub = getDocument()->subtitles->getIterator();
 
	//delete selected subtitles in subtitles list
	
	//start at end
	it.toLast();
	while ( (lvItem = it.current() ) != 0 )
	{
	    itsub.toFirst();
	    itsub += (lvItem->text(0)).toLong() - 1;
	
	    //delete sub
	    getDocument()->subtitles->removeSubtitle(itsub.current());
	
	    --it;
	}
		
	//refresh list
	ccp_fillInList();
		
	//refresh navigator
	pm_editor_navigator_bar->drawSubs(getDocument()->subtitles, true, pm_editor_navigator_bar->getSelectedSubtitle());    	
	
	//check if didn't cut them all
	if(getDocument()->subtitles->getNrOfSubtitles() == 0)
	{
	    ccp_enable(false);
	    ccp_enableApply();
	}
	
	//the document will be modified

	getDocument()->setModified(true);
	
	theApp->slotStatusMsg(i18n("Selected subtitles cut into memory"));   
    }
}

void KSubtileView::com_ccp_afterBefore_activated(const QString &)
{
    com_ccp_afterBefore_highlighted("");
}

void KSubtileView::com_ccp_afterBefore_highlighted(const QString &)
{
    //this check is to prevent the app from crashing at startup
    if(getDocument()->subtitles->getNrOfSubtitles() != 0)
    {
        //recalculate the offset when "after" or "before" is chosen
        ccp_fillInOffset();
    }
}

void KSubtileView::te_ccp_offset_valueChanged( const QTime & newTime)
{
    if(b_enable_ccp_valuechanged)
    {

        long newOffset = CSubtitles::getMSecs(newTime) + sb_ccp_offset->value();

        if(newOffset > ccp_limitOffset_max)
        {
            newOffset = ccp_limitOffset_max;
        }
        if(newOffset < 1)
        {
            newOffset = 1;
        }

        QTime offsetTime = CSubtitles::getQTimeFromMSecs(newOffset);
        b_enable_ccp_valuechanged = false;
        te_ccp_offset->setTime(offsetTime);
        sb_ccp_offset->setValue(offsetTime.msec());
        b_enable_ccp_valuechanged = true;
    }
}

void KSubtileView::sb_ccp_offset_valueChanged( int newValue)
{
    if(b_enable_ccp_valuechanged)
    {

        long newOffset = CSubtitles::getMSecs(te_ccp_offset->time()) + newValue;

        if(newOffset > ccp_limitOffset_max)
        {
            newOffset = ccp_limitOffset_max;
        }
        if(newOffset < 1)
        {
            newOffset = 1;
        }

        QTime offsetTime = CSubtitles::getQTimeFromMSecs(newOffset);
        b_enable_ccp_valuechanged = false;
        te_ccp_offset->setTime(offsetTime);
        sb_ccp_offset->setValue(offsetTime.msec());
        b_enable_ccp_valuechanged = true;
    }
}


//enable or disable controls in the ccp tab

void KSubtileView::ccp_enable(bool enabled)
{

    com_ccp_afterBefore->setEnabled(enabled);

    tl_ccp_sub->setEnabled(enabled);
    tl_ccp_sub_line1->setEnabled(enabled);
    tl_ccp_sub_line2->setEnabled(enabled);

    te_ccp_offset->setEnabled(enabled);
    sb_ccp_offset->setEnabled(enabled);

    pb_ccp_quickSelect_begin->setEnabled(enabled);
    pb_ccp_quickSelect_end->setEnabled(enabled);
    
    pb_ccp_apply->setEnabled(enabled);
    
    pb_ccp_cut->setEnabled(enabled);
    pb_ccp_copy->setEnabled(enabled);
    pb_ccp_selectAll->setEnabled(enabled);

    lv_ccp_subtitlesList->setEnabled(enabled);

}

// reset all values in the ccp tab

void KSubtileView::ccp_reset()
{
    tl_ccp_sub->setText( "00:00:00,000  >>  00:00:00,000" );
    tl_ccp_sub_line1->setText( "" );
    tl_ccp_sub_line2->setText( "" );

    b_enable_ccp_valuechanged = false;
    te_ccp_offset->setTime( QTime(0,0,0,0) );
    sb_ccp_offset->setValue( 0 );
    b_enable_ccp_valuechanged = true;

    lv_ccp_subtitlesList->clear();
    sub_ccp_sub = 0;

}

/////////// EDITOR

void KSubtileView::initEditor()
{

    // reset values

    editor_reset();

    //check amount of subtitles

    if(getDocument()->subtitles->getNrOfSubtitles() == 0)
    {
        editor_enable(false);
        pb_editor_after_addNew->setEnabled(true);
        return;
    }
    else
    {
        editor_enable(true);
    }

    //disconnect all from navigator

    removeConnectionsToNavigator();

    //connect subClicked from the navigator

    connect(pm_editor_navigator_bar, SIGNAL(subClicked(CSubtitle *)), this, SLOT(slotEditorSubClicked(CSubtitle *)));

    //select a sub as current

    selectSub(pm_editor_navigator_bar->getSelectedSubtitle());

}

void KSubtileView::slotEditorSubClicked(CSubtitle * sub)
{
    selectSub(sub);
}

void KSubtileView::selectSub(CSubtitle* newSub)
{
    //fill in start values for sub and length

    b_enable_editor_valuechanged = false;
    te_editor_startTime->setTime(newSub->getStartTime_QTime());
    sb_editor_startTime->setValue(newSub->getStartTime_QTime().msec());

    QTime theLength = CSubtitles::getQTimeFromMSecs(newSub->getEndTime() - newSub->getStartTime());
    te_editor_length->setTime( theLength );
    sb_editor_length->setValue( theLength.msec() );
    b_enable_editor_valuechanged = true;

    //fill in lines

    le_editor_line1->setText(newSub->getLine1());
    le_editor_line2->setText(newSub->getLine2());

    //the change function of the textbox sets the apply button to enabled but we don't want that here

    pb_editor_apply->setEnabled(false);

    //set the time-boundaries between which the sub can be changed

    editor_limitSub_endPreviousSub = getDocument()->subtitles->getEndTimeBefore(newSub);
    editor_limitSub_startNextSub = getDocument()->subtitles->getStartTimeAfter(newSub);

    //show subtitle and center it

    pm_editor_navigator_bar->drawSubs(getDocument()->subtitles, false, newSub);
    pm_editor_navigator_bar->slotShowSub(newSub);

    //disable addnew-mode

    editor_addNew_mode = false;

    //enable or disable buttons on the left and right

    editor_enable_buttons();


}


void KSubtileView::pb_editor_apply_clicked()
{
    //if we are changing an existing subtitle, then we must delete the existing one first
    //in both cases(addnew and changing) we make a subtitle object which we add to the collection

    if(!editor_addNew_mode)
    {
        getDocument()->subtitles->removeSubtitle(pm_editor_navigator_bar->getSelectedSubtitle());
    }

    //make a new subtitle object to add to the subtitles collection

    long length = CSubtitles::getMSecs(te_editor_length->time()) + sb_editor_length->value();
    long start = CSubtitles::getMSecs(te_editor_startTime->time()) + sb_editor_startTime->value();

    CSubtitle* addSub = new CSubtitle(start, start + length, le_editor_line1->text(), le_editor_line2->text());

    getDocument()->subtitles->addSubtitle(addSub);

    //redraw the new situation

    pm_editor_navigator_bar->drawSubs(getDocument()->subtitles, true, addSub);

    //make sure we select the sub as active so the editor tab is setup properly again

    selectSub(addSub);

    getDocument()->setModified(true);
    pb_move_apply->setEnabled(false);
    //     KSubtileApp *theApp=(KSubtileApp *) parentWidget();
    theApp->slotStatusMsg( i18n("Edit completed") );
}


////////////////// EDITOR LITTLE BUTTONS

//time icon clicked in move tab next to starttime

void KSubtileView::pb_stretch_play_startTime_clicked()
{
    //the small play button in the stretch tab

    getPlayer()->te_player_startTime->setTime(te_stretch_startTime->time());
    getPlayer()->pb_player_play_clicked();
}

void KSubtileView::pb_move_play_startTime_clicked()
{
    //the small play button in the move tab
    getPlayer()->te_player_startTime->setTime(te_move_startTime->time());
    getPlayer()->pb_player_play_clicked();
}

void KSubtileView::pb_editor_play_startTime_clicked()
{
    //the small play button in the editor tab
    getPlayer()->te_player_startTime->setTime(te_editor_startTime->time());
    getPlayer()->pb_player_play_clicked();
}

void KSubtileView::pb_editor_curpos_startTime_clicked()
{
    //time icon clicked in editor tab next to starttime
    if(te_editor_startTime->isEnabled())
    {
        QTime curTime = CSubtitles::getQTimeFromMSecs(getPlayer()->getPlayerCurrentPos());
        b_enable_editor_valuechanged = false;
        te_editor_startTime->setTime( curTime );
        b_enable_editor_valuechanged = true;
        sb_editor_startTime->setValue( curTime.msec() );
    }
}


/////////////EDITOR BUTTONS

void KSubtileView::pb_editor_after_go_clicked()
{
    CSubtitle* currentSub = pm_editor_navigator_bar->getSelectedSubtitle();
    QPtrListIterator<CSubtitle> it = getDocument()->subtitles->getIterator();
    CSubtitle* sub;
    while ( (sub = it.current() ) != 0 )
    {
        ++it;
        if(*currentSub == *sub)
        {
            if( (sub = it.current()) != 0 )
            {
                selectSub(sub);
                return;
            }
        }
    }
}

void KSubtileView::pb_editor_before_go_clicked()
{
    CSubtitle* currentSub = pm_editor_navigator_bar->getSelectedSubtitle();
    QPtrListIterator<CSubtitle> it = getDocument()->subtitles->getIterator();
    CSubtitle* sub;
    while ( (sub = it.current() ) != 0 )
    {
        if(*currentSub == *sub)
        {
            --it;
            if( (sub = it.current()) != 0 )
            {
                selectSub(sub);
                return;
            }
        }
        ++it;
    }
}

void KSubtileView::pb_editor_deleteCurrent_clicked()
{
    //this is the subtitle we need to delete

    CSubtitle* deleteSub = pm_editor_navigator_bar->getSelectedSubtitle();

    //the document will be modified

    getDocument()->setModified(true);

    //decide which sub to select next, or in the case of 1 sub we reset the editor

    if(pb_editor_after_go->isEnabled())
    {
        //we can go one to the right

        pb_editor_after_go_clicked();

        // delete the subtitle

        getDocument()->subtitles->removeSubtitle(deleteSub);
        selectSub(pm_editor_navigator_bar->getSelectedSubtitle());
        pm_editor_navigator_bar->drawSubs(getDocument()->subtitles, true, pm_editor_navigator_bar->getSelectedSubtitle());
        return;
    }
    else if(pb_editor_before_go->isEnabled())
    {
        //we can't go to the right but we can go back one sub

        pb_editor_before_go_clicked();

        // delete the subtitle

        getDocument()->subtitles->removeSubtitle(deleteSub);
        selectSub(pm_editor_navigator_bar->getSelectedSubtitle());
        pm_editor_navigator_bar->drawSubs(getDocument()->subtitles, true, pm_editor_navigator_bar->getSelectedSubtitle());

        return;
    }
    else
    {
        //only one sub in the collection

        getDocument()->subtitles->removeSubtitle(deleteSub);

        //redraw navigator bar

        pm_editor_navigator_bar->drawSubs(getDocument()->subtitles, true);

        //disable everything in the editor tab but the right addnew button

        editor_reset();
        editor_enable(false);
        pb_editor_after_addNew->setEnabled(true);
    }

}

void KSubtileView::pb_editor_before_addNew_clicked()
{

    //reset the values

    editor_reset();

    //fill in starttime and length should be 2secs default

    //get length from config
    kapp->config()->setGroup("Editor Options");
    long newSubLength = kapp->config()->readLongNumEntry("Default Add New Length", ksubtilePreferences::pref_DefaultAddNewLength );


    long newStartTime = 0;
    long newLength = 0;
    CSubtitle* currentSub = pm_editor_navigator_bar->getSelectedSubtitle();
    if(currentSub->getStartTime() - editor_limitSub_endPreviousSub - 1 >= newSubLength)
    {
        //ok it fits in
        newStartTime = currentSub->getStartTime() - newSubLength;
        newLength = newSubLength - 1;
    }
    else
    {
        newStartTime = editor_limitSub_endPreviousSub + 1;
        newLength = currentSub->getStartTime() - editor_limitSub_endPreviousSub - 2;
    }

    //we need now to set a new maximum(the minimum stays the same as it was)

    editor_limitSub_startNextSub = currentSub->getStartTime();

    //fill in new values

    b_enable_editor_valuechanged = false;
    QTime start = CSubtitles::getQTimeFromMSecs(newStartTime);
    te_editor_startTime->setTime(start);
    sb_editor_startTime->setValue(start.msec());

    QTime length = CSubtitles::getQTimeFromMSecs(newLength);
    te_editor_length->setTime(length);
    sb_editor_length->setValue(length.msec());
    b_enable_editor_valuechanged = true;

    //set apply false because the first line will be empty so we can't let the user apply the sub

    pb_editor_apply->setEnabled(false);
    le_editor_line1->setFocus();

    //set addnew-mode

    editor_addNew_mode = true;

    //disable addnew and delete buttons

    editor_enable_buttons();

    //for some reason it needs reconnection?? somebody explain me why the connection was lost?

    connect(pm_editor_navigator_bar, SIGNAL(subClicked(CSubtitle *)), this, SLOT(slotEditorSubClicked(CSubtitle *)));
}

void KSubtileView::pb_editor_after_addNew_clicked()
{

    //reset the values

    editor_reset();

    //fill in starttime and length should be 2secs default

    //get length from config
    kapp->config()->setGroup("Editor Options");
    long newSubLength = kapp->config()->readLongNumEntry("Default Add New Length", ksubtilePreferences::pref_DefaultAddNewLength );


    long newStartTime = 0;
    long newLength = 0;
    CSubtitle* currentSub = pm_editor_navigator_bar->getSelectedSubtitle();
    if(currentSub != 0)
    {
        if(editor_limitSub_startNextSub - currentSub->getEndTime() - 1 >= newSubLength)
        {
            //ok it fits in

            newStartTime = currentSub->getEndTime() + 1;
            newLength = newSubLength - 1;
        }
        else
        {
            newStartTime = currentSub->getEndTime() + 1;
            newLength = editor_limitSub_startNextSub - currentSub->getEndTime() - 2;
        }

        //we need now to set a new minimum(the maximum stays the same as it was)

        editor_limitSub_endPreviousSub = currentSub->getEndTime();
    }
    else
    {
        //it is the first sub we add, then we have no currentsub

        //start at 0 and length 2(default)

        newStartTime = 0;
        newLength = newSubLength - 1;

        //set min and max limit

        editor_limitSub_endPreviousSub = -1;
        editor_limitSub_startNextSub = 86400000;
    }

    //fill in new values

    b_enable_editor_valuechanged = false;
    QTime start = CSubtitles::getQTimeFromMSecs(newStartTime);
    te_editor_startTime->setTime(start);
    sb_editor_startTime->setValue(start.msec());

    QTime length = CSubtitles::getQTimeFromMSecs(newLength);
    te_editor_length->setTime(length);
    sb_editor_length->setValue(length.msec());
    b_enable_editor_valuechanged = true;

    //set apply false because the first line will be empty so we can't let the user apply the sub

    pb_editor_apply->setEnabled(false);
    le_editor_line1->setFocus();

    //set addnew-mode

    editor_addNew_mode = true;

    //disable addnew and delete buttons

    editor_enable_buttons();

    //for some reason it needs reconnection?? somebody explain me why the connection was lost?

    connect(pm_editor_navigator_bar, SIGNAL(subClicked(CSubtitle *)), this, SLOT(slotEditorSubClicked(CSubtitle *)));

}

void KSubtileView::pb_editor_before_deleteAll_clicked()
{
    int doit = KMessageBox::warningYesNo(0,
                                         i18n("This will delete all subtitles before the current one!\nDo you really want to continue?"),
                                         i18n("Warning"));
    if(doit == KMessageBox::Yes)
    {
        //go through every sub from the beginning and send those subs to hell!  until you must bow before the currentSub of course...
        CSubtitle* currentSub = pm_editor_navigator_bar->getSelectedSubtitle();
        QPtrListIterator<CSubtitle> it = getDocument()->subtitles->getIterator();
        CSubtitle* sub;
        while ( (sub = it.current() ) != 0 )
        {
            ++it;
            if(!(*currentSub == *sub))
            {
                getDocument()->subtitles->removeSubtitle(sub);
            }
            else
            {
                break;
            }
        }
	
	//the document will be modified

	getDocument()->setModified(true);

        //make the editor buttons and navigator ok

        pm_editor_navigator_bar->drawSubs(getDocument()->subtitles, true, currentSub);
        selectSub(currentSub);
    }
}

void KSubtileView::pb_editor_after_deleteAll_clicked()
{
    int doit = KMessageBox::warningYesNo(0,
                                         i18n("This will delete all subtitles after the current one!\nDo you really want to continue?"),
                                         i18n("Warning"));
    if(doit == KMessageBox::Yes)
    {
        CSubtitle* currentSub = pm_editor_navigator_bar->getSelectedSubtitle();
        QPtrListIterator<CSubtitle> it = getDocument()->subtitles->getIterator();
        CSubtitle* sub;
        it.toLast();
        while ( (sub = it.current() ) != 0 )
        {
            --it;
            if(!(*currentSub == *sub))
            {
                getDocument()->subtitles->removeSubtitle(sub);
            }
            else
            {
                break;
            }
        }

	//the document will be modified

	getDocument()->setModified(true);
	
        //make editor buttons and navigator correct

        pm_editor_navigator_bar->drawSubs(getDocument()->subtitles, true, currentSub);
        selectSub(currentSub);
    }
}

/////////////EDITOR VALUECHANGED


void KSubtileView::te_editor_startTime_valueChanged( const QTime & newTime)
{
    if(b_enable_editor_valuechanged)
    {
        long newStart = CSubtitles::getMSecs(newTime) + sb_editor_startTime->value();

        if(newStart <= editor_limitSub_endPreviousSub)
        {
            newStart = editor_limitSub_endPreviousSub + 1;
        }

        long length = CSubtitles::getMSecs(te_editor_length->time()) + sb_editor_length->value();

        if(newStart >= editor_limitSub_startNextSub - length)
        {
            newStart = editor_limitSub_startNextSub - length - 1;
        }

        QTime startTime = CSubtitles::getQTimeFromMSecs(newStart);
        b_enable_editor_valuechanged = false;
        te_editor_startTime->setTime(startTime);
        sb_editor_startTime->setValue(startTime.msec());
        b_enable_editor_valuechanged = true;

        editor_apply_enable();
    }

}


void KSubtileView::sb_editor_startTime_valueChanged( int newValue)
{

    if(b_enable_editor_valuechanged)
    {
        long newStart = CSubtitles::getMSecs(te_editor_startTime->time()) + newValue;

        if(newStart <= editor_limitSub_endPreviousSub)
        {
            newStart = editor_limitSub_endPreviousSub + 1;
        }

        long length = CSubtitles::getMSecs(te_editor_length->time()) + sb_editor_length->value();

        if(newStart >= editor_limitSub_startNextSub - length)
        {
            newStart = editor_limitSub_startNextSub - length - 1;
        }

        QTime startTime = CSubtitles::getQTimeFromMSecs(newStart);
        b_enable_editor_valuechanged = false;
        te_editor_startTime->setTime(startTime);
        sb_editor_startTime->setValue(startTime.msec());
        b_enable_editor_valuechanged = true;

        editor_apply_enable();
    }

}

void KSubtileView::te_editor_length_valueChanged( const QTime & newTime)
{

    if(b_enable_editor_valuechanged)
    {

        long newLength = CSubtitles::getMSecs(newTime) + sb_editor_length->value();
        long start = CSubtitles::getMSecs(te_editor_startTime->time()) + sb_editor_startTime->value();

        if(start + newLength >= editor_limitSub_startNextSub)
        {
            newLength = editor_limitSub_startNextSub - start - 1;
        }

        QTime lengthTime = CSubtitles::getQTimeFromMSecs(newLength);
        b_enable_editor_valuechanged = false;
        te_editor_length->setTime(lengthTime);
        sb_editor_length->setValue(lengthTime.msec());
        b_enable_editor_valuechanged = true;

        editor_apply_enable();
    }

}


void KSubtileView::sb_editor_length_valueChanged( int newValue)
{
    if(b_enable_editor_valuechanged)
    {

        long newLength = CSubtitles::getMSecs(te_editor_length->time()) + newValue;
        long start = CSubtitles::getMSecs(te_editor_startTime->time()) + sb_editor_startTime->value();

        if(start + newLength >= editor_limitSub_startNextSub)
        {
            newLength = editor_limitSub_startNextSub - start - 1;
        }

        QTime lengthTime = CSubtitles::getQTimeFromMSecs(newLength);
        b_enable_editor_valuechanged = false;
        te_editor_length->setTime(lengthTime);
        sb_editor_length->setValue(lengthTime.msec());
        b_enable_editor_valuechanged = true;

        editor_apply_enable();
    }
}


void KSubtileView::editor_apply_enable()
{
    if(le_editor_line1->text() != QString(""))
    {
        pb_editor_apply->setEnabled(true);
    }
    else
    {
        pb_editor_apply->setEnabled(false);
    }
}

//////////EDITOR ENABLE/RESET

/** En/disables buttons according to how many subs there are */

void KSubtileView::editor_enable(bool enabled)
{

    pb_editor_before_go->setEnabled(enabled);
    pb_editor_before_addNew->setEnabled(enabled);
    pb_editor_before_deleteAll->setEnabled(enabled);
    pb_editor_after_go->setEnabled(enabled);
    pb_editor_after_addNew->setEnabled(enabled);
    pb_editor_after_deleteAll->setEnabled(enabled);
    pb_editor_deleteCurrent->setEnabled(enabled);

    le_editor_line1->setEnabled(enabled);
    le_editor_line2->setEnabled(enabled);

    te_editor_startTime->setEnabled(enabled);
    sb_editor_startTime->setEnabled(enabled);

    te_editor_length->setEnabled(enabled);
    sb_editor_length->setEnabled(enabled);

}

void KSubtileView::editor_enable_buttons(void)
{

    if(getDocument()->subtitles->getNrOfSubtitles() == 0)
    {
        //disable buttons
        editor_enable(false);
    }
    else
    {
        // enable all buttons

        editor_enable(true);

        //disable some

        //if first, then we can't delete before or go to sub before

        if(*pm_editor_navigator_bar->getSelectedSubtitle() == *getDocument()->subtitles->getFirstSubtitle())
        {
            pb_editor_before_go->setEnabled(false);
            pb_editor_before_deleteAll->setEnabled(false);
        }

        //if last, then we can't delete after or go to sub after

        if(*pm_editor_navigator_bar->getSelectedSubtitle() == *getDocument()->subtitles->getLastSubtitle())
        {
            pb_editor_after_go->setEnabled(false);
            pb_editor_after_deleteAll->setEnabled(false);
        }

        //check to see if we have space to add a subtitle before the current

        if(pm_editor_navigator_bar->getSelectedSubtitle()->getStartTime() - getDocument()->subtitles->getEndTimeBefore(pm_editor_navigator_bar->getSelectedSubtitle()) - 1 > 0)
        {
            //ok we have space somewhere in time
        }
        else
        {
            //no space left
            pb_editor_before_addNew->setEnabled(false);
        }

        //check to see if we have space to add a subtitle after the current

        if(getDocument()->subtitles->getStartTimeAfter(pm_editor_navigator_bar->getSelectedSubtitle()) - pm_editor_navigator_bar->getSelectedSubtitle()->getEndTime() - 1 > 0)
        {
            //ok we have space somewhere in time
        }
        else
        {
            //no space left
            pb_editor_after_addNew->setEnabled(false);
        }

    }

    //if we are adding a new sub
    if(editor_addNew_mode)
    {
        if(getDocument()->subtitles->getNrOfSubtitles() == 0)
        {
            //we enable all because it was disabled in the above part of this function

            editor_enable(true);

            //if it is the first sub we add, then we should disable the go buttons too

            pb_editor_before_go->setEnabled(false);
            pb_editor_after_go->setEnabled(false);
        }

        //now we disable delete and addnew

        pb_editor_before_addNew->setEnabled(false);
        pb_editor_after_addNew->setEnabled(false);

        pb_editor_before_deleteAll->setEnabled(false);
        pb_editor_after_deleteAll->setEnabled(false);

        //disable delete current

        pb_editor_deleteCurrent->setEnabled(false);
    }
}

void KSubtileView::editor_reset()
{
    b_enable_editor_valuechanged = false;
    te_editor_startTime->setTime( QTime(0,0,0,0) );
    te_editor_length->setTime( QTime(0,0,0,0) );
    sb_editor_startTime->setValue(0);
    sb_editor_length->setValue(0);
    b_enable_editor_valuechanged = true;
    le_editor_line2->setText("");
    le_editor_line1->setText("");

}

//make sure the first line is filled in

void KSubtileView::le_editor_line1_textChanged( const QString & newString)
{
    if( newString != QString("") )
    {
        pb_editor_apply->setEnabled(true);
    }
    else
    {
        pb_editor_apply->setEnabled(false);
    }
}

//make sure if the second line is filled in that the first line also needs to be filled in

void KSubtileView::le_editor_line2_textChanged( const QString &)
{
    editor_apply_enable();
}
