/***************************************************************************
 *   Copyright (C) 2004-2007 by Giovanni Venturi                           *
 *   giovanni@ksniffer.org                                                 *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Steet, Fifth Floor, Boston, MA  02110-1301, USA.          *
 ***************************************************************************/

#ifndef PROTOCOLMANAGER_H
#define PROTOCOLMANAGER_H

class Packet;
class QStringList;
class QString;

#include "../packetstructures.h"
#include "protocolnamelist.h"

class ProtocolManager
{
public:
  ProtocolManager(ptrPacketType packet, u_int8_t proto, ProtocolNameList *pnl);

  QStringList headerLines() const;
  QString getProtocol() const;

private:
  Packet *m_packet;
  u_int8_t m_proto;
  ProtocolNameList *m_protocolNameList;
};

#endif
