/***************************************************************************
 *   Copyright (C) 2004-2007 by Giovanni Venturi                           *
 *   giovanni@ksniffer.org                                                 *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Steet, Fifth Floor, Boston, MA  02110-1301, USA.          *
 ***************************************************************************/

#ifndef PARSECONFIG_H
#define PARSECONFIG_H

#include <libxml/xmlmemory.h>
#include <libxml/parser.h>

class ParseConfig
{
  private:
    void parseStandard(xmlNodePtr cur);
    void parseExtras(xmlNodePtr cur);

  private:
    char m_strInterface[15];
    char m_strSniffFile[100];
    char m_strResultFile[100];
    int m_sniffType;
    long m_nPackSizeTime;
    long m_nUnits;
    bool m_error;   // if the document doesn't contain the wanted XML items, 'error' will be true

  public:
    ParseConfig(char *docname);

    char *interface();
    char *sniffFile();
    char *sniffResultFile();
    int sniffType();
    long nPackSizeTime();
    long nUnits();
    bool error();
};

#endif // PARSECONFIG_H
