/***************************************************************************
 *   Copyright (C) 2004-2007 by Giovanni Venturi                           *
 *   giovanni@ksniffer.org                                                 *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Steet, Fifth Floor, Boston, MA  02110-1301, USA.          *
 ***************************************************************************/

#include <netinet/in.h>

#include <qstringlist.h>

#include <klocale.h>
//#include <kdebug.h>

#include "../packet.h"
#include "../packetstructures.h"
#include "lcc.h"

LinuxCookedCaptureFrame::LinuxCookedCaptureFrame(Packet *packet)
{
  m_packet = packet;
}


QStringList LinuxCookedCaptureFrame::headerLines() const
{
  QStringList list;

  if (m_packet)
  {
    struct LCC *lcc = (struct LCC *) m_packet->getPacket();

    list << i18n("Linux Cooked Capture Frame Field", "Packet type: %1").arg(htons(lcc->sll_pkttype));
    list << i18n("Linux Cooked Capture Frame Field", "Link layer address type: %1").arg(htons(lcc->sll_hatype));
    list << i18n("Linux Cooked Capture Frame Field", "Link layer address length: %1").arg(htons(lcc->sll_halen));
    list << i18n("Linux Cooked Capture Frame Field", "Protocol type: 0x%1").arg(htons(lcc->sll_etype), 0, 16);
  }

  return list;
}


unsigned short LinuxCookedCaptureFrame::protocol() const
{
  struct LCC *lcc = (struct LCC *) m_packet->getPacket();

  return htons(lcc->sll_etype);
}

