/***************************************************************************
 *   Copyright (C) 2004-2008 by Giovanni Venturi                           *
 *   giovanni@ksniffer.org                                                 *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Steet, Fifth Floor, Boston, MA  02110-1301, USA.          *
 ***************************************************************************/

#include <qstring.h>
#include <qstringlist.h>

#include "protocolmanager.h"
#include "tcp-protocol.h"
#include "udp-protocol.h"
#include "icmp-protocol.h"
#include "../packet.h"

ProtocolManager::ProtocolManager(ptrPacketType packet, u_int8_t proto, PortNumberNameList *pnnl)
{
  m_packet = (Packet *) packet;
  struct IpHdr *ip = (struct IpHdr*) (packet + m_packet->frameHeaderLength());
  int hdrlen = ip->ihl << 2;
  ptrPacketType p = (ptrPacketType) ip;
  p += hdrlen;

  m_packet = (Packet *) p;
  m_proto = proto;
  m_portNumberNameList = pnnl;
}


QStringList ProtocolManager::headerLines() const
{
  IcmpProtocol *icmp;
  TcpProtocol *tcp;
  UdpProtocol *udp;
  QStringList list;

  if (m_packet)
  {
    switch (m_proto)
    {
      case 1:
        // ICMP protocol
        icmp = new IcmpProtocol(m_packet);
        list = icmp->headerLines();
        break;
      case 6:
        // TCP protocol
        tcp = new TcpProtocol(m_packet, m_portNumberNameList);
        list = tcp->headerLines();
        break;
      case 17:
        // UDP protocol
        udp = new UdpProtocol(m_packet, m_portNumberNameList);
        list = udp->headerLines();
    }
  }

  return list;
}


QString ProtocolManager::getProtocol() const
{
  QString proto;

  if (m_packet)
  {
#warning parse the /etc/protocols file
    switch (m_proto)
    {
      case 1:
        // ICMP protocol
        proto = "ICMP";
        break;
      case 6:
        // TCP protocol
        proto = "TCP";
        break;
      case 17:
        // UDP protocol
        proto = "UDP";
      default:
        proto = QString::null;
    }
  }

  return proto;
}
