#ifndef __LOCKOUT_H__
#define __LOCKOUT_H__

#include <kpanelapplet.h>

class KAction;

/**
 * @short A KShutDown panel applet.
 * Based on the Lockout applet.
 */
class Lockout: public KPanelApplet
{
	Q_OBJECT
public:
	/**
	 * Constructs a new applet.
	 * @param configFile A configuration file (provided by the Kicker)
	 * @param parent A parent widget
	 */
	Lockout(const QString& configFile, QWidget *parent = 0);

	/**
	 * Destructor.
	 */
	~Lockout();

	/**
	 * Returns a suggested height for a given @p width.
	 */
	int heightForWidth(int width) const;

	/**
	 * Returns a suggested width for a given @p height.
	 */
	int widthForHeight(int height) const;
private:
	bool _transparent;
	KAction
		*_cancelAction,
		*_configureKShutDownAction,
		*_lockScreenAction,
		*_logoutAction,
		*_rebootAction,
		*_shutDownAction;
	void callKShutDown(const QCString &function);
	void initActions();
	void runCommand(const QString &command);
private slots:
	void slotCancel();
	void slotConfigureKShutDown();
	void slotIconChanged();
	void slotLockScreen();
	void slotLogout();
	void slotReboot();
	void slotShowKShutDown();
	void slotShutDown();
};

#endif // __LOCKOUT_H__
