/***************************************************************************
                          kmyhistorycombo.cpp  -  description
                             -------------------
    begin                : Tue Oct 16 2001
    copyright            : (C) 2001 by Dominik Seichter
    email                : domseichter@web.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

// QT includes
#include <qlistbox.h>

// Own includes
#include "kmyhistorycombo.h"

#include <kapplication.h>
#include <kconfig.h>

#include <qtimer.h>

#define TIMER_DELAY 500

KMyHistoryCombo::KMyHistoryCombo(QWidget* parent, const char* name)
    :KHistoryCombo(parent, name)
{
    QStringList history;
    QStringList completion;
    KConfig* config = kapp->config();
    config->setGroup( name );
    this->setDuplicatesEnabled( false );
    
    history = config->readListEntry("History");
    completion = config->readListEntry("CompletionItems");
    m_timer = new QTimer();
    
    setHistoryItems( history );

    completionObject()->setItems( ( completion.isEmpty() ? history : completion ) );
    setCompletionMode( (KGlobalSettings::Completion)config->readNumEntry( "CompletionMode",
                        KGlobalSettings::completionMode() ) );    
                        
    connect( this, SIGNAL( textChanged( const QString & ) ), this, SLOT( textChangedGovernor() ) );
    connect( m_timer, SIGNAL( timeout() ), this, SIGNAL( delayedTextChanged() ) );
}

KMyHistoryCombo::~KMyHistoryCombo()
{
    delete m_timer;
}

void KMyHistoryCombo::saveSettings()
{
    addToHistory( text() );

    KConfig* config = kapp->config();
    
    config->setGroup( name() ? name() : "KMyHistoryCombo" );
    config->writeEntry( "History", historyItems() );
    config->writeEntry( "CompletionItems", completionObject()->items() );
    config->writeEntry( "CompletionMode", completionMode() );

    config->sync();
}

QString KMyHistoryCombo::text( int index ) const 
{
    return this->listBox()->text( index );
}

void KMyHistoryCombo::setText( const QString & text )
{
    this->lineEdit()->setText( text );
}

void KMyHistoryCombo::add( const QString & text )
{
    int i;
    for ( i = 0; i < this->count(); i++ )
        if( this->text( i ) == text ) {
            QString tmp = this->text( i );
            this->listBox()->removeItem( i );
            this->insertItem( tmp, 0 );
            return;
        }

    if( this->count() == this->maxCount() )
        this->listBox()->removeItem( this->maxCount() );

    this->insertItem( text, 0 );
}

bool KMyHistoryCombo::isEmpty() const
{
    return this->lineEdit()->text().isEmpty();
}

void KMyHistoryCombo::textChangedGovernor()
{
    m_timer->stop();
    m_timer->start( TIMER_DELAY, true );
}
