/***************************************************************************
                          fileoperation.h  -  description
                             -------------------
    begin                : Sun Nov 11 2001
    copyright            : (C) 2001 by Dominik Seichter
    email                : domseichter@web.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef FILEOPERATION_H
#define FILEOPERATION_H

#include <qobject.h>
#include <kio/jobclasses.h>
#include <kurl.h>

class QString;
class FileOperation: public QObject {
    Q_OBJECT
    public:
        FileOperation();
        ~FileOperation();

        bool start( const KURL & src, const KURL & dest, int mode, bool overwrite );
        bool fcopy( const QString & src, const QString & dest );

        inline const QString & error() const;
        static QString getName( const QString & file );

    private slots:
        void slotResult( KIO::Job * job );

    private:
        bool locked;
        bool canceled;
        int result;

        QString m_error;
};

inline const QString & FileOperation::error() const
{ 
    return m_error; 
}

#endif
