/***************************************************************************
                          profiledlg.h  -  description
                             -------------------
    begin                : Sat Nov 20 2004
    copyright            : (C) 2004 by Dominik Seichter
    email                : domseichter@web.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef PROFILEDLG_H
#define PROFILEDLG_H

#include <kdialogbase.h>

class KListBox;
class KPushButton;
class KRenameImpl;

/**
@author Dominik Seichter
*/
class ProfileDlg : public KDialogBase
{
    Q_OBJECT
    
    public:
        ProfileDlg(KRenameImpl* krename, QWidget *parent = 0, const char *name = 0);
        ~ProfileDlg();

    private slots:
        void enableControls();
        void slotLoadProfile();
        void slotCreateProfile();
        void slotDeleteProfile();
           
    private:
        const QString getProfilePath( const QString & name );
        const QString readProfilePath( const QString & name );

        const QString listToString( QValueList<int> & list );
        const QValueList<int> stringToList( const QString & );
        
        void writeXML( const QString & name );
        void loadXML( const QString & path );
        
    private:
        KRenameImpl* m_krename;
        
        KListBox* profiles;
        
        KPushButton* createProfile;
        KPushButton* loadProfile;
        KPushButton* deleteProfile;
};

#endif
